/**
 * Classe Hasard
 * La classe qui place au hasard les mines sur le Terrain.
 * 
 * 1) on fait le cadre avec des Cases Vides qui n'existent pas: pratique
 *    (colonne 0 et rang largeur+1)(ligne 0 et ligne hauteur+1)
 * 2) on slectionne les 20% de cases avec des bombes
 * 
 * 3) on rempli le tableau
 *
 *
 * @author Dabancourt C.
 * @version 1.0 08/08/2000
 */

import java.util.Random;


class Hasard{

	private int champMine[][];
	private int largeur, hauteur;
	
	Hasard(int plargeur, int phauteur){
		
		largeur=plargeur; hauteur=phauteur;
		champMine = new int[largeur+2][hauteur+2];
		 
	// 1 (tout  0 y compris les bords!
		for (int i=0; i<=largeur + 1; i++)
			for (int j=0; j<=hauteur + 1; j++)
				champMine[i][j]=0;
			
	// 2
		int nbMine = (int) (largeur * hauteur ) *20/100; // on place 20% de mines
		Random random = new  Random();
		int i = 0; int col=1; int lig=1; int trouver=1;

		while ( i<=nbMine) {

			trouver = 1 + random.nextInt(hauteur*largeur-1);
			col = trouver%largeur+ 1;
			lig = trouver/largeur + 1;

			if (champMine[col][lig]!=-1){
				champMine[col][lig]=-1;
	// on a mis une mine : les 8 cases adjacentes ont un voisin  min de plus		
				for (int x=col-1; x<=col+1 ; x++){
					for (int y=lig-1; y<=lig+1 ; y++)
						if(champMine[x][y]!=-1)   // sauf si c'est une mines
							champMine[x][y]=champMine[x][y]+1;
				}
				i++;
			}
			
		}
		
	}

	public int getHasardResultat(int x, int y){
		x++;y++; // pour enlever le bord
		if (champMine[x][y]==-1)
			return 10;
		else
			return champMine[x][y];
	}


}
