<%@ Import namespace="System" %>
<%@ Import namespace="System.Data" %>
<%@ Import namespace="System.Data.OleDb" %>

<HTML>
<HEAD>
<title>
Exemple de calcul avec ASP.NET (math26.aspx)
</title>
<script language="vb" runat="server">
Dim oConn As New OleDbConnection("provider=SQLOLEDB.1;Data" & _
    "Source=Default;Initial Catalog=ASPNET_WCC;" & _
    "uid=DeDieu;pwd=")

Sub Page_Load(ByVal Sender As Object, e As EventArgs)
  If Page.IsPostBack Then 'Connexion sur POST seulement
    oConn.Open()
  End If
End Sub

Sub MAJTable(sngCalcStock As Single)
  Dim objAdp As New OleDbDataAdapter()
  Dim dsWCC As New DataSet()
  Dim strSQL As String = "SELECT * FROM WCC_MATH"
  Dim odbWCC As OleDbCommandBuilder = New OleDbCommandBuilder(objAdp)

  objAdp.SelectCommand = New OleDbCommand(strSQL, oConn)
  objAdp.Fill(dsWCC)

  Dim rowWCC As DataRow 
  rowWCC = dsWCC.Tables("WCC_MATH").NewRow 
  rowWCC("RESULT") = sngCalcStock  ' Injectons le rsultat
  rowWCC("DATE_ENTERED")= System.DateTime.Now.ToShortDateString 
  dsWCC.Tables("WCC_MATH").Rows.Add(rowWCC)
  objAdp.Update(dsWCC, "WCC_MATH")
End Sub

Sub btnCalculer_OnClick(Source As Object, e As EventArgs)
  Dim sngVal1 As Single = txtSaisieVal1.Text
  Dim sngVal2 As Single = txtSaisieVal2.Text
  Dim strOperateur As String = OperateurMath.SelectedItem.Text
  Dim sngResultat As Single

Try
  Select Case strOperateur
Case "x"
  sngResultat = sngVal1 * sngVal2
Case "/"
  sngResultat = sngVal1 / sngVal2
Case "+"
  sngResultat = sngVal1 + sngVal2
Case "-"
  sngResultat = sngVal1 - sngVal2
End Select
Catch errTrop As OverflowException
  Response.Write("Rsultat trop grand comme valeur de type Single.")
Catch errZero As DivideByZeroException
  Response.Write("Je ne sais pas diviser par zro ! ")
Finally
  MAJTable(sngResultat)
End Try
End Sub

Function TesterNumerique(objValue As Object, args As EventArgs) As Boolean
  If IsNumeric(objValue) Then
    Return True
  Else
    Return False
  End If
End Function
</script>
</HEAD>

<body>
<form runat="Server">
<P>
Saisissez les deux valeurs numriques puis cliquez Calculer :</P>
<P>       
<asp:TextBox id="txtSaisieVal1" runat="server"></asp:TextBox>
<asp:DropDownList id="OperateurMath" runat="server">
<asp:ListItem>x</asp:ListItem>
<asp:ListItem>/</asp:ListItem>
<asp:ListItem>+</asp:ListItem>
<asp:ListItem>-</asp:ListItem>
</asp:DropDownList>
<asp:TextBox id="txtSaisieVal2" runat="server" ></asp:TextBox>
<asp:Button id=btnCalculer runat="server" Text="Calculer" OnClick="btnCalculer_OnClick"></asp:Button>


</form>
</body>
</html>
