<%@ Import namespace=System.Data %>
<%@ Import namespace=System.Data.OleDb %>
<%@ OutputCache Duration=600 %>
<html>
<head>
<title>ASP.NET Math Program</title>
<script language=VB runat=server>
Sub Page_Load(ByVal Sender As Object, e As EventArgs)
If Page.IsPostBack Then We only want to connect on post back
   Dim oConn As OleDbConnection
   oConn = New OleDbConnection(provider=SQLOLEDB.1;Data  & _
      Source=KLAVEN;Initial Catalog=ASPNET WCC; & _
        uid=sa;pwd=testbox)
      oConn.Open()
End If
End Sub

Sub UpdateTableWithResult(sngResults As Single)

Dim objAdp As New OleDbDataAdapter()
Dim dsWCC As New DataSet()
Dim strSQL As String = "SELECT * FROM Math_WCC"
Dim odbWCC As OleDbCommandBuilder = New OleDbCommandBuilder(objAdp)

objAdp.SelectCommand = New OleDbCommand(strSQL, oConn)
objAdp.Fill(dsWCC)


Dim rowWCC As New DataRow = dsWCC.Tables("Math_WCC").NewRow 
rowWCC("RESULT") = sngResults Our results will go here 
rowWCC("DATE_ENTERED")= System.DateTime.Now.ToShortDateString 
dsWCC.Tables("Math_WCC").Rows.Add(rowWCC)
objAdp.Update(dsWCC, "Math_WCC")
End Sub


Sub btnGetResult_OnClickClick(Source As Object, e As EventArgs)
Dim sngFirstValue As Single = txtValue1.Text
Dim sngSecondValue As Single =As Single = txtValue2.Text
Dim strOperator As String = MathOperator.SelectedItem.Text

Dim sngResult As Single
Try

Select Case strOperator
Case multiply
sngResult = sngValue1 * sngValue2
Case divide
sngResult = sngValue1 / sngValue2
Case add
sngResult = sngValue1 + sngValue2
Case subtract
sngResult = sngValue1  sngValue2
End Select

Catch e As OverflowException
Response.Write(The result was too large to represent & _
		as a single.)

Catch e As DivideByZeroException
Response.Write(You cannot divide by zero.)

Finally
	UpdateTableWithResult(sngResult)
End Try


Function CheckValue(objValue As Object, args As EventArgs) 
If IsNumeric(objValue) Then
Return True
Else
Return False
End If
End Function
</script>
</head>
<body>
<form runat=server>
Please enter your values and click Get Results.
 <br/>
<asp:TextBox id=txtValue1 runat=server></asp:TextBox>
<asp:DropDownList id=MathOperator runat=server>
<asp:ListItem>x</asp:ListItem>
<asp:ListItem>/</asp:ListItem>
<asp:ListItem>+</asp:ListItem>
<asp:ListItem>-</asp:ListItem>
</asp:DropDownList>
<asp:TextBox id=txtValue2 runat=server ></asp:TextBox>
<asp:Button id=btnGetResult runat="server" Text="Get Result" OnClick="btnGetResult_OnClick"></asp:Button>

  <asp:RequiredFieldValidator id=FirstValueHasValue
       runat=server
       ControlToValidate=txtValue1
       ErrorMessage=You must enter value in the first box.
       Display=none>
  </asp:RequiredFieldValidator>

  <asp:CustomValidator id=FirstValueIsNumber runat=server
       ControlToValidate=txtValue1
       OnServerValidate=CheckValue( & txtValue1.Text &_
       )
       ErrorMessage=The first value does not contain a  & _
          number.
       Display=None>
  </asp:CustomValidator>

  <asp:RequiredFieldValidator id=SecondValueHasValue
       runat=server
       ControlToValidate=txtValue2
       ErrorMessage=You must enter value in the second box.
       Display=none>
  </asp:RequiredFieldValidator>

  <asp:CustomValidator id=FirstValueIsNumber runat=server
       ControlToValidate=txtValue2
       OnServerValidate=CheckValue(&_
         txttxtValue2.Text & _ )
       ErrorMessage=The second value does not contain  & _
         number.
       Display=None>
  </asp:CustomValidator>

  <asp:RequiredFieldValidator id=MathOperatorHasValue
       runat=server
       ControlToValidate=MathOperator
       ErrorMessage=You must choose an operator.
       Display=none>
  </asp:RequiredFieldValidator>

  <asp:ValidationSummary id=MathSummary runat=server
       HeaderText=The following errors were encountered:
       ShowSummary=True
       DisplayMode=BulletList>
   </asp:ValidationSummary>
</form>
</body>
</html>
