<%@Import Namespace="System.Decimal" %>
<html>
<head>
<title>
Exemple de calcul avec ASP.NET (math20.aspx)
</title>

<script language="vb" runat="Server">
Dim decVal1 As Decimal
Dim decVal2 As Decimal
Dim strOperateur As String

Sub Page_Load(Source as Object, e As EventArgs)
End Sub

Sub btnCalculer_OnClick(Source As Object, e As EventArgs)
  decVal1 = txtSaisieVal1.Text
  decVal2 = txtSaisieVal2.Text
  strOperateur = OperateurMath.SelectedItem.Text
  Dim decResultat As Decimal

  Try
  Select Case strOperateur
    Case "x"
      decResultat = FoncMultiplier(decVal1, decVal2)
    Case "/"
      decResultat = FoncDiviser(decVal1, decVal2)
    Case "+"
      decResultat = FoncAdditionner(decVal1, decVal2)
    Case "-"
      decResultat = FoncSoustraire(decVal1, decVal2)
  End Select
  Catch errTrop As OverflowException
    Response.Write("Rsultat trop grand comme valeur de type Decimal. ")
  Catch errZero As DivideByZeroException
    Response.Write("Je ne sais pas diviser par zro ! ")
  Finally
    Response.Write("Le rsultat de votre calcul est : " & decResultat)
  End Try
End Sub

Function FoncMultiplier(decVal1 As Decimal, decVal2 As Decimal)
Dim decResultat As Decimal
  decResultat = Multiply(decVal1, decVal2)
  Return decResultat
End Function

Function FoncDiviser(decVal1 As Decimal, decVal2 As Decimal)
Dim decResultat As Decimal
  decResultat = Divide(decVal1, decVal2)
  Return decResultat
End Function

Function FoncAdditionner(decVal1 As Decimal, decVal2 As Decimal)
Dim decResultat As Decimal
  decResultat = Add(decVal1, decVal2)
  Return decResultat
End Function

Function FoncSoustraire(decVal1 As Decimal, decVal2 As Decimal)
Dim decResultat As Decimal
  decResultat = Subtract(decVal1, decVal2)
  Return decResultat
End Function

Function TesterNumerique(objValue As Object, args As EventArgs) As Boolean
If IsNumeric(objValue) Then
  Return True
Else
  Return False
End If
End Function

</script>
</head>

<body>

<form runat="Server">
Saisissez les deux valeurs numriques :
<br/>
<asp:TextBox id="txtSaisieVal1" runat="server"></asp:TextBox>

<asp:DropDownList id="OperateurMath" runat="Server">
<asp:ListItem>x</asp:ListItem>
<asp:ListItem>/</asp:ListItem>
<asp:ListItem>+</asp:ListItem>
<asp:ListItem>-</asp:ListItem>
</asp:DropDownList>

<asp:TextBox id="txtSaisieVal2" runat="Server" >
</asp:TextBox>

<asp:Button id=btnCalculer runat="Server" Text="Calculer" OnClick="btnCalculer_OnClick">
</asp:Button>


</form>
</body>
</html>
