<%@ Import namespace="System" %>
<%@ Import namespace="System.Data" %>
<%@ Import namespace="System.Data.OleDb" %>

<HTML>
<HEAD>
<title>
Exemple de calcul avec ASP.NET (math26.aspx)
</title>
<script language="vb" runat="server">

Sub Page_Load(ByVal Sender As Object, e As EventArgs)
  If Page.IsPostBack Then 'Connexion sur POST seulement
  Dim oConn As OleDbConnection
  oConn = New OleDbConnection("provider=SQLOLEDB.1;Data" & _
    "Source=Default;Initial Catalog=ASPNET WCC;" & _
    "uid=sa;pwd=testbox")
  oConn.Open()
  End If
End Sub

Sub MAJTable(decCalcStock As Decimal)
  Dim objAdp As New OleDbDataAdapter()
  Dim dsWCC As New DataSet()
  Dim strSQL As String = "SELECT * FROM Math_WCC"
  Dim odbWCC As OleDbCommandBuilder = New OleDbCommandBuilder(objAdp)

  objAdp.SelectCommand = New OleDbCommand(strSQL, oConn)
  objAdp.Fill(dsWCC)

  Dim rowWCC As New DataRow = dsWCC.Tables("Math_WCC").NewRow 
  rowWCC("RESULT") = decCalcStock  ' Injectons le rsultat
  rowWCC("DATE_ENTERED")= System.DateTime.Now.ToShortDateString 
  dsWCC.Tables("Math_WCC").Rows.Add(rowWCC)
  objAdp.Update(dsWCC, "Math_WCC")
End Sub

Sub btnCalculer_OnClick(Source As Object, e As EventArgs)
  decVal1 = txtSaisieVal1.Text
  decVal2 = txtSaisieVal2.Text
  strOperateur = OperateurMath.SelectedItem.Text
  Dim decResultat As Decimal
Try
  Select Case strOperateur
Case "x"
  decResultat = FoncMultiplier(decVal1, decVal2)
Case "/"
  decResultat = FoncDiviser(decVal1, decVal2)
Case "+"
  decResultat = FoncAdditionner(decVal1, decVal2)
Case "-"
  decResultat = FoncSoustraire(decVal1, decVal2)
End Select
Catch errTrop As OverflowException
  Response.Write("Rsultat trop grand comme valeur de type Decimal.")
Catch errZero As DivideByZeroException
  Response.Write("Je ne sais pas diviser par zro ! ")
Finally
  MAJTable(decResultat)
End Try
End Sub

Function FoncMultiplier(decVal1 As Decimal, decVal2 As Decimal)
  Dim decResultat As Decimal
  decResultat = Multiply(decVal1, decVal2)
  Return decResultat
End Function

Function FoncDiviser(decVal1 As Decimal, decVal2 As Decimal)
  Dim decResultat As Decimal
  decResultat = Divide(decVal1, decVal2)
  Return decResultat
End Function

Function FoncAdditionner(decVal1 As Decimal, decVal2 As Decimal)
  Dim decResultat As Decimal
  decResultat = Add(decVal1, decVal2)
  Return decResultat
End Function

Function FoncSoustraire(decVal1 As Decimal, decVal2 As Decimal)
  Dim decResultat As Decimal
  decResultat = Subtract(decVal1, decVal2)
  Return decResultat
End Function

Function TesterNumerique(objValue As Object, args As EventArgs) As Boolean
  If IsNumeric(objValue) Then
    Return True
  Else
    Return False
  End If
End Function
</script>
</HEAD>

<body>
<form runat="Server">
<P>
Saisissez les deux valeurs numriques puis cliquez Calculer :</P>
<P>       
<asp:TextBox id="txtSaisieVal1" runat="server"></asp:TextBox>
<asp:DropDownList id="OperateurMath" runat="server">
<asp:ListItem>x</asp:ListItem>
<asp:ListItem>/</asp:ListItem>
<asp:ListItem>+</asp:ListItem>
<asp:ListItem>-</asp:ListItem>
</asp:DropDownList>
<asp:TextBox id="txtSaisieVal2" runat="server" ></asp:TextBox>
<asp:Button id=btnCalculer runat="server" Text="Calculer" OnClick="btnCalculer_OnClick"></asp:Button>

<asp:RequiredFieldValidator id="Val1Existe" runat="server"
ControlToValidate="txtSaisieVal1"
ErrorMessage="Il faut saisir une valeur numrique dans la premire zone." 
Display="none">
</asp:RequiredFieldValidator>

<asp:CustomValidator id="Val1Numerik" runat="server"
ControlToValidate="txtSaisieVal1"
OnServerValidate="TesterNumerique(" & txtSaisieVal1.Text & ")"
ErrorMessage="La premire valeur saisie contient autre chose que des chiffres." 
Display="None">
</asp:CustomValidator>

<asp:RequiredFieldValidator id="Val2Existe" runat="server"
ControlToValidate="txtSaisieVal2"
ErrorMessage="Il faut saisir une valeur numrique dans la seconde zone." 
Display="none">
</asp:RequiredFieldValidator>

<asp:CustomValidator id="Val2Numerik" runat="server"
ControlToValidate="txtSaisieVal2"
OnServerValidate="TesterNumerique(" & txtSaisieVal2.Text & ")"
ErrorMessage="La seconde valeur saisie contient autre chose que des chiffres." 
Display="None">
</asp:CustomValidator>

<asp:RequiredFieldValidator id="OperateurMathExiste"
runat="server"
ControlToValidate="OperateurMath"
ErrorMessage="Vous devez choisir un oprateur."
Display="none">
</asp:RequiredFieldValidator>

<asp:ValidationSummary id="MathSummary" runat="server">
HeaderText="Voici les erreurs dtectes :"
ShowSummary="True"
DisplayMode="BulletList">
</asp:ValidationSummary>

</form>
</body>
</html>
