<?xml version="1.0" encoding="ISO-8859-1"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/TR/WD-xsl">
	<xsl:template>
		<xsl:script><![CDATA[
	function affPrix(e, tag)
		{
		node = e.selectSingleNode(tag);
		if (node == null)
			return "" ;
		return formatNumber(node.text, "#,0") + " FF";
		}]]>
		</xsl:script>
		<DIV>
			<STYLE>
	BODY {margin:0}
	.bg {font:10pt Arial; background-color:#006666; color:white}
	H1 {font:bold 20pt Arial; width:100%; margin-top:1em}
	.row {font:10pt Arial; text-align:right; border-bottom:1px solid #006666}
	.rowx {font:10pt Arial; text-align:center; border-bottom:1px solid #006666}
	.rowb {font: bold 10pt Arial; text-align:right; border-bottom:1px solid #006666}
	.header {font:bold 10pt Arial; cursor:hand; padding:2px; border:2px outset gray}
</STYLE><CENTER>
			<TABLE cellspacing="0">
				<THEAD class="bg">
		<TH class="header" onClick="triColonne('datesimul', 'Date de simulation')">Date</TH>
		<TH class="header" onClick="triNumColonne('prix', 'Prix du vhicule')">Prix du vhicule</TH>
		<TH class="header" onClick="triNumColonne('montant', 'Montant du prt')">Montant du prt</TH>
		<TH class="header" onClick="triNumColonne('duree', 'Dure du prt')">Dure du prt</TH>
		<TH class="header" onClick="triNumColonne('mensualite', 'Mensualit')">Mensualit</TH>
		<TH class="header" onClick="triNumColonne('couttotal', 'Cot total')">Cot total</TH>
		<TH class="header" onClick="triNumColonne('taux', 'Taux (TEG)')">Taux</TH>
					<UserHead/>
				</THEAD>
				<xsl:for-each select="simulations/simulation">
					<TR>
						<TD class="row" style="text-align:center">Le <xsl:value-of select="datesimul"/></TD>
						<TD class="row"><xsl:eval>affPrix(this, "prix")</xsl:eval></TD>
						<TD class="rowb"><xsl:eval>affPrix(this, "montant")</xsl:eval></TD>
						<TD class="rowx"><xsl:value-of select="duree"/> ans</TD>
						<TD class="rowb"><xsl:eval>affPrix(this, "mensualite")</xsl:eval></TD>
						<TD class="row"><xsl:eval>affPrix(this, "couttotal")</xsl:eval></TD>
						<TD class="rowx"><xsl:value-of select="taux"/>%</TD>
						<UserCol/>
					</TR>
					<TR><TD COLSPAN="99" CLASS="bg"></TD></TR>
				</xsl:for-each>
			</TABLE></CENTER>
		</DIV>
	</xsl:template>
</xsl:stylesheet>
