<?xml version="1.0" encoding="ISO-8859-1"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/TR/WD-xsl">
<xsl:template>
<xsl:script><![CDATA[
	function affPrix(e, tag)
		{
		node = e.selectSingleNode(tag);
		if (node == null)
			return "" ;
		return formatNumber(node.text, "#,0") + " FF";
		}]]>
</xsl:script>
<DIV>
<STYLE>
	H1 {font:bold 20pt Arial; width:100%; margin-top:1em}
	.rien {font:10pt Arial; text-align:right; border-bottom:2px solid #FFCC00; color: #999999}
	.row2 {font: bold 12pt Arial; text-align:right; border-bottom:2px solid #408080}
	.row {font: bold 12pt Arial; text-align:right}
	.header {font: 12pt Arial; background-color:#FFCC00; color:#000000}
	.headerb {font: bold 12pt Arial; background-color:#FFCC00; color:#000000}
	.header2 {font: 12pt Arial; background-color:#DDDDDD; color:#000000}
	.header2b {font: bold 12pt Arial; background-color:#DDDDDD; color:#000000}
</STYLE>
<TABLE width="80%" cellspacing="0">
	<xsl:for-each select="simulation">
	<TR>
		<TD class="rien" COLSPAN="2">Date de simulation :<xsl:value-of select="datesimul"/></TD>
	</TR>
	<TR>
		<TD class="row">Prix du vhicule</TD>
		<TD class="row"><xsl:eval>affPrix(this, "prix")</xsl:eval></TD>
	</TR>
	<TR>
		<TD class="header">Montant du prt</TD>
		<TD class="headerb"><xsl:eval>affPrix(this, "montant")</xsl:eval></TD>
	</TR>
	<TR>
		<TD class="header2">Dure du prt</TD>
		<TD class="header2"><xsl:value-of select="duree"/> ans</TD>
	</TR>
	<TR>
		<TD class="header">Mensualit</TD>
		<TD class="headerb"><xsl:eval>affPrix(this, "mensualite")</xsl:eval></TD>
	</TR>
	<TR>
		<TD class="header2">Cot total</TD>
		<TD class="header2"><xsl:eval>affPrix(this, "couttotal")</xsl:eval></TD>
	</TR>
	<TR>
		<TD class="header">Taux</TD>
		<TD class="header"><xsl:value-of select="taux"/>%</TD>
	</TR>
	</xsl:for-each>
</TABLE>
</DIV>
</xsl:template>
</xsl:stylesheet>
