/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.parser;

import com.sun.xml.parser.AttributeDecl;
import com.sun.xml.parser.ContentModel;
import com.sun.xml.parser.ContentModelState;
import com.sun.xml.parser.ElementDecl;
import com.sun.xml.parser.ElementValidator;
import com.sun.xml.parser.EndOfInputException;
import com.sun.xml.parser.ExternalEntity;
import com.sun.xml.parser.Parser;
import com.sun.xml.parser.SimpleHashtable;
import com.sun.xml.util.XmlNames;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ValidatingParser
extends Parser {
    private SimpleHashtable ids = new SimpleHashtable();
    private final EmptyValidator EMPTY = new EmptyValidator();

    public ValidatingParser() {
        this.setIsValidating(true);
    }

    public ValidatingParser(boolean bl) {
        this();
        if (bl) {
            this.setErrorHandler(new 1());
        }
    }

    void afterRoot() throws SAXException {
        Enumeration enumeration = this.ids.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Boolean bl = (Boolean)this.ids.get(string);
            if (!Boolean.FALSE.equals(bl)) continue;
            this.error("V-024", new Object[]{string});
        }
    }

    void afterDocument() {
        this.ids.clear();
    }

    void validateAttributeSyntax(AttributeDecl attributeDecl, String string) throws SAXException {
        if (attributeDecl.type == "ID") {
            Boolean bl;
            if (!XmlNames.isName(string)) {
                this.error("V-025", new Object[]{string});
            }
            if ((bl = (Boolean)this.ids.get(string)) == null || bl.equals(Boolean.FALSE)) {
                this.ids.put(string, Boolean.TRUE);
                return;
            }
            this.error("V-026", new Object[]{string});
            return;
        }
        if (attributeDecl.type == "IDREF") {
            Boolean bl;
            if (!XmlNames.isName(string)) {
                this.error("V-027", new Object[]{string});
            }
            if ((bl = (Boolean)this.ids.get(string)) == null) {
                this.ids.put(string, Boolean.FALSE);
                return;
            }
        } else {
            if (attributeDecl.type == "IDREFS") {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    Boolean bl;
                    string = stringTokenizer.nextToken();
                    if (!XmlNames.isName(string)) {
                        this.error("V-027", new Object[]{string});
                    }
                    if ((bl = (Boolean)this.ids.get(string)) != null) continue;
                    this.ids.put(string, Boolean.FALSE);
                }
                return;
            }
            if (attributeDecl.type == "NMTOKEN") {
                if (!XmlNames.isNmtoken(string)) {
                    this.error("V-028", new Object[]{string});
                    return;
                }
            } else {
                if (attributeDecl.type == "NMTOKENS") {
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    while (stringTokenizer.hasMoreTokens()) {
                        string = stringTokenizer.nextToken();
                        if (XmlNames.isNmtoken(string)) continue;
                        this.error("V-028", new Object[]{string});
                    }
                    return;
                }
                if (attributeDecl.type == "ENUMERATION") {
                    int n = 0;
                    while (n < attributeDecl.values.length) {
                        if (string.equals(attributeDecl.values[n])) {
                            return;
                        }
                        ++n;
                    }
                    this.error("V-029", new Object[]{string});
                    return;
                }
                if (attributeDecl.type == "NOTATION") {
                    int n = 0;
                    while (n < attributeDecl.values.length) {
                        if (string.equals(attributeDecl.values[n])) {
                            return;
                        }
                        ++n;
                    }
                    this.error("V-030", new Object[]{string});
                    return;
                }
                if (attributeDecl.type == "ENTITY") {
                    if (!this.isUnparsedEntity(string)) {
                        this.error("V-031", new Object[]{string});
                        return;
                    }
                } else {
                    if (attributeDecl.type == "ENTITIES") {
                        StringTokenizer stringTokenizer = new StringTokenizer(string);
                        while (stringTokenizer.hasMoreTokens()) {
                            string = stringTokenizer.nextToken();
                            if (this.isUnparsedEntity(string)) continue;
                            this.error("V-031", new Object[]{string});
                        }
                        return;
                    }
                    if (attributeDecl.type != "CDATA") {
                        throw new InternalError(attributeDecl.type);
                    }
                }
            }
        }
    }

    ContentModel newContentModel(String string) {
        return new ContentModel(string);
    }

    ContentModel newContentModel(char c, ContentModel contentModel) {
        return new ContentModel(c, contentModel);
    }

    ElementValidator newValidator(ElementDecl elementDecl) {
        if (elementDecl.contentType == null || elementDecl.contentType == "ANY") {
            return ElementValidator.ANY;
        }
        if (elementDecl.contentType == "EMPTY") {
            return this.EMPTY;
        }
        if (elementDecl.contentType.charAt(1) == '#') {
            return new MixedValidator(elementDecl);
        }
        return new ChildrenValidator(elementDecl);
    }

    private boolean isUnparsedEntity(String string) {
        Object object = this.entities.get(string);
        if (object == null || !(object instanceof ExternalEntity)) {
            return false;
        }
        return ((ExternalEntity)object).notation != null;
    }

    private final class 1
    extends HandlerBase {
        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        /* synthetic */ 1() {
        }
    }

    class EmptyValidator
    extends ElementValidator {
        public void consume(String string) throws SAXException {
            ValidatingParser.this.error("V-033", null);
        }

        public void text() throws SAXException {
            ValidatingParser.this.error("V-033", null);
        }

        EmptyValidator() {
            ValidatingParser.this = ValidatingParser.this;
        }
    }

    class MixedValidator
    extends ElementValidator {
        private ElementDecl element;

        MixedValidator(ElementDecl elementDecl) {
            ValidatingParser.this = ValidatingParser.this;
            this.element = elementDecl;
        }

        public void consume(String string) throws SAXException {
            String string2 = this.element.contentType;
            int n = 8;
            while ((n = string2.indexOf(string, n + 1)) >= 9) {
                char c;
                if (string2.charAt(n - 1) != '|' || (c = string2.charAt(n + string.length())) != '|' && c != ')') continue;
                return;
            }
            ValidatingParser.this.error("V-034", new Object[]{this.element.name, string, string2});
        }
    }

    class ChildrenValidator
    extends ElementValidator {
        private ContentModelState state;
        private String name;

        ChildrenValidator(ElementDecl elementDecl) {
            ValidatingParser.this = ValidatingParser.this;
            this.state = new ContentModelState(elementDecl.model);
            this.name = elementDecl.name;
        }

        public void consume(String string) throws SAXException {
            if (this.state == null) {
                ValidatingParser.this.error("V-035", new Object[]{this.name, string});
                return;
            }
            try {
                this.state = this.state.advance(string);
                return;
            }
            catch (EndOfInputException endOfInputException) {
                ValidatingParser.this.error("V-036", new Object[]{this.name, string});
                return;
            }
        }

        public void text() throws SAXException {
            ValidatingParser.this.error("V-037", new Object[]{this.name});
        }

        public void done() throws SAXException {
            if (this.state != null && !this.state.terminate()) {
                ValidatingParser.this.error("V-038", new Object[]{this.name});
            }
        }
    }
}

