/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.tree;

import com.sun.xml.tree.DomEx;
import com.sun.xml.tree.NodeBase;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;

abstract class DataNode
extends NodeBase
implements CharacterData {
    char[] data;

    DataNode() {
    }

    DataNode(char[] cArray, int n, int n2) {
        this.data = new char[n2];
        System.arraycopy(cArray, n, this.data, 0, n2);
    }

    DataNode(String string) {
        if (string != null) {
            this.data = new char[string.length()];
            string.getChars(0, this.data.length, this.data, 0);
            return;
        }
        this.data = new char[0];
    }

    public char[] getText() {
        return this.data;
    }

    public void setText(char[] cArray) {
        this.data = cArray;
    }

    public String toString() {
        return new String(this.data);
    }

    public String getData() {
        return this.toString();
    }

    public void setData(String string) {
        if (string == null) {
            this.setText(null);
            return;
        }
        this.setText(string.toCharArray());
    }

    public int getLength() {
        if (this.data == null) {
            return 0;
        }
        return this.data.length;
    }

    public String substringData(int n, int n2) throws DOMException {
        if (n < 0 || n > this.data.length || n2 < 0) {
            throw new DomEx(1);
        }
        n2 = Math.min(n2, this.data.length - n);
        return new String(this.data, n, n2);
    }

    public void appendData(String string) {
        int n = string.length();
        char[] cArray = new char[n + this.data.length];
        System.arraycopy(this.data, 0, cArray, 0, this.data.length);
        string.getChars(0, n, cArray, this.data.length);
        this.data = cArray;
    }

    public void insertData(int n, String string) throws DOMException {
        if (n < 0 || n >= this.data.length) {
            throw new DomEx(1);
        }
        int n2 = string.length();
        char[] cArray = new char[n2 + this.data.length];
        System.arraycopy(this.data, 0, cArray, 0, n);
        string.getChars(0, n2, cArray, n);
        System.arraycopy(this.data, n, cArray, n + n2, this.data.length - n);
        this.data = cArray;
    }

    public void deleteData(int n, int n2) throws DOMException {
        if (n < 0 || n >= this.data.length || n2 < 0) {
            throw new DomEx(1);
        }
        n2 = Math.min(n2, this.data.length - n);
        char[] cArray = new char[this.data.length - n2];
        System.arraycopy(this.data, 0, cArray, 0, n);
        System.arraycopy(this.data, n + n2, cArray, n, cArray.length - n);
        this.data = cArray;
    }

    public void replaceData(int n, int n2, String string) throws DOMException {
        if (n < 0 || n >= this.data.length || n2 < 0) {
            throw new DomEx(1);
        }
        if (n + n2 >= this.data.length) {
            this.deleteData(n, n2);
            this.appendData(string);
            return;
        }
        if (string.length() == n2) {
            string.getChars(0, string.length(), this.data, n);
            return;
        }
        char[] cArray = new char[this.data.length + (string.length() - n2)];
        System.arraycopy(this.data, 0, cArray, 0, n);
        string.getChars(0, string.length(), cArray, n);
        System.arraycopy(this.data, n + n2, cArray, n + string.length(), this.data.length - (n + n2));
        this.data = cArray;
    }

    public String getNodeValue() {
        return this.getData();
    }

    public void setNodeValue(String string) {
        this.setData(string);
    }
}

