/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.parser;

import com.sun.xml.parser.ElementValidator;
import com.sun.xml.parser.EndOfInputException;
import com.sun.xml.parser.LexicalEventListener;
import com.sun.xml.parser.Parser;
import com.sun.xml.parser.XmlReader;
import com.sun.xml.util.XmlChars;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Locale;
import org.xml.sax.DocumentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

final class InputEntity
implements Locator {
    private int start;
    private int finish;
    private char[] buf;
    private int lineNumber = 1;
    private boolean returnedFirstHalf = false;
    private String name;
    private InputEntity next;
    private InputSource input;
    private Reader reader;
    private boolean isClosed;
    private ErrorHandler errHandler;
    private Locale locale;
    private StringBuffer rememberedText;
    private int startRemember;
    private boolean isPE;
    private static final int BUFSIZ = 8193;
    private static final char[] newline = new char[]{'\n'};

    public static InputEntity getInputEntity(ErrorHandler errorHandler, Locale locale) {
        InputEntity inputEntity = new InputEntity();
        inputEntity.errHandler = errorHandler;
        inputEntity.locale = locale;
        return inputEntity;
    }

    private InputEntity() {
    }

    public boolean isInternal() {
        return this.reader == null;
    }

    public boolean isDocument() {
        return this.next == null;
    }

    public boolean isParameterEntity() {
        return this.isPE;
    }

    public String getName() {
        return this.name;
    }

    public void init(InputSource inputSource, String string, InputEntity inputEntity, boolean bl) throws IOException, SAXException {
        this.input = inputSource;
        this.isPE = bl;
        this.reader = inputSource.getCharacterStream();
        if (this.reader == null) {
            InputStream inputStream = inputSource.getByteStream();
            this.reader = inputStream == null ? XmlReader.createReader(new URL(inputSource.getSystemId()).openStream()) : (inputSource.getEncoding() != null ? XmlReader.createReader(inputSource.getByteStream(), inputSource.getEncoding()) : XmlReader.createReader(inputSource.getByteStream()));
        }
        this.next = inputEntity;
        this.buf = new char[8193];
        this.name = string;
        this.checkRecursion(inputEntity);
    }

    public void init(char[] cArray, String string, InputEntity inputEntity, boolean bl) throws SAXException {
        this.next = inputEntity;
        this.buf = cArray;
        this.finish = cArray.length;
        this.name = string;
        this.isPE = bl;
        this.checkRecursion(inputEntity);
    }

    private void checkRecursion(InputEntity inputEntity) throws SAXException {
        if (inputEntity == null) {
            return;
        }
        inputEntity = inputEntity.next;
        while (inputEntity != null) {
            if (inputEntity.name != null && inputEntity.name.equals(this.name)) {
                this.fatal("P-069", new Object[]{this.name});
            }
            inputEntity = inputEntity.next;
        }
    }

    public InputEntity pop() throws IOException {
        this.close();
        return this.next;
    }

    public boolean isEOF() throws IOException, SAXException {
        if (this.reader != null && this.start >= this.finish && !this.isClosed) {
            try {
                this.fillbuf();
            }
            catch (EndOfInputException endOfInputException) {
                return true;
            }
        }
        return this.start >= this.finish;
    }

    public String getEncoding() {
        if (this.reader == null) {
            return null;
        }
        if (this.reader instanceof XmlReader) {
            return ((XmlReader)this.reader).getEncoding();
        }
        if (this.reader instanceof InputStreamReader) {
            return ((InputStreamReader)this.reader).getEncoding();
        }
        return null;
    }

    public char getc() throws IOException, SAXException {
        if (this.finish <= this.start) {
            this.fillbuf();
        }
        if (this.finish > this.start) {
            char c = this.buf[this.start++];
            if (this.returnedFirstHalf) {
                if (c >= '\udc00' && c <= '\udfff') {
                    this.returnedFirstHalf = false;
                    return c;
                }
                this.fatal("P-070", new Object[]{Integer.toHexString(c)});
            }
            if (c >= ' ' && c <= '\ud7ff' || c == '\t' || c == '\r' || c >= '\ue000' && c <= '\ufffd') {
                return c;
            }
            if (c == '\n') {
                if (!this.isInternal()) {
                    ++this.lineNumber;
                }
                return c;
            }
            if (c >= '\ud800' && c < '\udc00') {
                this.returnedFirstHalf = true;
                return c;
            }
            this.fatal("P-071", new Object[]{Integer.toHexString(c)});
        }
        throw new EndOfInputException();
    }

    public boolean peekc(char c) throws IOException, SAXException {
        if (this.finish <= this.start) {
            this.fillbuf();
        }
        if (this.finish > this.start) {
            if (this.buf[this.start] == c) {
                ++this.start;
                return true;
            }
            return false;
        }
        return false;
    }

    public void ungetc() {
        if (this.start == 0) {
            throw new InternalError("ungetc");
        }
        --this.start;
        if (this.buf[this.start] == '\n') {
            if (!this.isInternal()) {
                --this.lineNumber;
                return;
            }
        } else if (this.returnedFirstHalf) {
            this.returnedFirstHalf = false;
        }
    }

    public boolean maybeWhitespace() throws IOException, SAXException {
        boolean bl = false;
        while (true) {
            char c;
            if (this.finish <= this.start) {
                this.fillbuf();
            }
            if (this.finish <= this.start) {
                return bl;
            }
            if ((c = this.buf[this.start++]) != ' ' && c != '\t' && c != '\n' && c != '\r') break;
            bl = true;
            if (c != '\n' || this.isInternal()) continue;
            ++this.lineNumber;
        }
        if (this.buf[--this.start] == '\n' && !this.isInternal()) {
            --this.lineNumber;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean parsedContent(DocumentHandler documentHandler, ElementValidator elementValidator) throws IOException, SAXException {
        int n;
        int n2 = n = this.start;
        boolean bl = false;
        while (true) {
            block18: {
                char c;
                block22: {
                    block21: {
                        block20: {
                            block19: {
                                if (n < this.finish) break block19;
                                if (n > n2) {
                                    elementValidator.text();
                                    documentHandler.characters(this.buf, n2, n - n2);
                                    bl = true;
                                    this.start = n;
                                }
                                if (this.isEOF()) {
                                    return bl;
                                }
                                n2 = this.start;
                                n = n2 - 1;
                                break block18;
                            }
                            c = this.buf[n];
                            if (c > ']' && c <= '\ud7ff' || c < '&' && c >= ' ' || c > '<' && c < ']' || c > '&' && c < '<' || c == '\t' || c >= '\ue000' && c <= '\ufffd') break block18;
                            if (c == '<' || c == '&') break;
                            if (c != '\n') break block20;
                            if (!this.isInternal()) {
                                ++this.lineNumber;
                            }
                            break block18;
                        }
                        if (c != '\r') break block21;
                        if (!this.isInternal()) {
                            documentHandler.characters(this.buf, n2, n - n2);
                            documentHandler.characters(newline, 0, 1);
                            bl = true;
                            ++this.lineNumber;
                            if (this.finish > n + 1 && this.buf[n + 1] == '\n') {
                                ++n;
                            }
                            n2 = this.start = n + 1;
                        }
                        break block18;
                    }
                    if (c != ']') break block22;
                    switch (this.finish - n) {
                        case 2: {
                            if (this.buf[n + 1] != ']') break;
                        }
                        case 1: {
                            if (this.reader != null) {
                                if (this.isClosed) break;
                                if (n == n2) {
                                    throw new InternalError("fillbuf");
                                }
                                if (--n > n2) {
                                    elementValidator.text();
                                    documentHandler.characters(this.buf, n2, n - n2);
                                    bl = true;
                                    this.start = n;
                                }
                                this.fillbuf();
                                n2 = n = this.start;
                                break;
                            }
                            break block18;
                        }
                        default: {
                            if (this.buf[n + 1] == ']' && this.buf[n + 2] == '>') {
                                this.fatal("P-072", null);
                                break;
                            }
                            break block18;
                        }
                    }
                    break block18;
                }
                if (c >= '\ud800' && c <= '\udfff') {
                    if (this.checkSurrogatePair(n)) {
                        ++n;
                        break block18;
                    } else {
                        --n;
                        break;
                    }
                }
                this.fatal("P-071", new Object[]{Integer.toHexString(c)});
            }
            ++n;
        }
        if (n == n2) {
            return bl;
        }
        elementValidator.text();
        documentHandler.characters(this.buf, n2, n - n2);
        this.start = n;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean unparsedContent(DocumentHandler documentHandler, ElementValidator elementValidator, boolean bl, String string) throws IOException, SAXException {
        if (!this.peek("![CDATA[")) {
            return false;
        }
        if (documentHandler instanceof LexicalEventListener) {
            ((LexicalEventListener)documentHandler).startCDATA();
        }
        while (true) {
            boolean bl2 = false;
            boolean bl3 = bl;
            int n = this.start;
            while (n < this.finish) {
                block29: {
                    char c = this.buf[n];
                    if (!XmlChars.isChar(c)) {
                        bl3 = false;
                        if (c >= '\ud800' && c <= '\udfff') {
                            if (this.checkSurrogatePair(n)) {
                                ++n;
                                break block29;
                            } else {
                                --n;
                                break;
                            }
                        }
                        this.fatal("P-071", new Object[]{Integer.toHexString(this.buf[n])});
                    }
                    if (c == '\n') {
                        if (!this.isInternal()) {
                            ++this.lineNumber;
                        }
                    } else if (c == '\r') {
                        if (!this.isInternal()) {
                            if (bl3) {
                                if (string != null) {
                                    this.errHandler.error(new SAXParseException(Parser.messages.getMessage(this.locale, string), this));
                                }
                                documentHandler.ignorableWhitespace(this.buf, this.start, n - this.start);
                                documentHandler.ignorableWhitespace(newline, 0, 1);
                            } else {
                                elementValidator.text();
                                documentHandler.characters(this.buf, this.start, n - this.start);
                                documentHandler.characters(newline, 0, 1);
                            }
                            ++this.lineNumber;
                            if (this.finish > n + 1 && this.buf[n + 1] == '\n') {
                                ++n;
                            }
                            this.start = n + 1;
                        }
                    } else if (c != ']') {
                        if (c != ' ' && c != '\t') {
                            bl3 = false;
                        }
                    } else if (n + 2 < this.finish) {
                        if (this.buf[n + 1] == ']' && this.buf[n + 2] == '>') {
                            bl2 = true;
                            break;
                        }
                        bl3 = false;
                    } else {
                        --n;
                        break;
                    }
                }
                ++n;
            }
            if (bl3) {
                if (string != null) {
                    this.errHandler.error(new SAXParseException(Parser.messages.getMessage(this.locale, string), this));
                }
                documentHandler.ignorableWhitespace(this.buf, this.start, n - this.start);
            } else {
                elementValidator.text();
                documentHandler.characters(this.buf, this.start, n - this.start);
            }
            if (bl2) {
                this.start = n + 3;
                if (!(documentHandler instanceof LexicalEventListener)) return true;
                break;
            }
            this.start = n;
            this.fillbuf();
            if (!this.isEOF()) continue;
            this.fatal("P-073", null);
        }
        ((LexicalEventListener)documentHandler).endCDATA();
        return true;
    }

    private boolean checkSurrogatePair(int n) throws SAXException {
        if (n + 1 >= this.finish) {
            return false;
        }
        char c = this.buf[n++];
        char c2 = this.buf[n];
        if (c >= '\ud800' && c < '\udc00' && c2 >= '\udc00' && c2 <= '\udfff') {
            return true;
        }
        this.fatal("P-074", new Object[]{Integer.toHexString(c & 0xFFFF), Integer.toHexString(c2 & 0xFFFF)});
        return false;
    }

    public boolean ignorableWhitespace(DocumentHandler documentHandler) throws IOException, SAXException {
        boolean bl = false;
        int n = this.start;
        block5: while (true) {
            if (this.finish <= this.start) {
                if (bl) {
                    documentHandler.ignorableWhitespace(this.buf, n, this.start - n);
                }
                this.fillbuf();
                n = this.start;
            }
            if (this.finish <= this.start) {
                return bl;
            }
            char c = this.buf[this.start++];
            switch (c) {
                case '\n': {
                    if (!this.isInternal()) {
                        ++this.lineNumber;
                    }
                }
                case '\t': 
                case ' ': {
                    bl = true;
                    continue block5;
                }
                case '\r': {
                    bl = true;
                    if (!this.isInternal()) {
                        ++this.lineNumber;
                    }
                    documentHandler.ignorableWhitespace(this.buf, n, this.start - 1 - n);
                    documentHandler.ignorableWhitespace(newline, 0, 1);
                    if (this.start >= this.finish || this.buf[this.start] == '\n') {
                        // empty if block
                    }
                    n = ++this.start;
                    continue block5;
                }
            }
            break;
        }
        this.ungetc();
        if (bl) {
            documentHandler.ignorableWhitespace(this.buf, n, this.start - n);
        }
        return bl;
    }

    public boolean peek(String string) throws IOException, SAXException {
        int n = string.length();
        if (this.finish <= this.start || this.finish - this.start < n) {
            this.fillbuf();
        }
        if (this.finish <= this.start) {
            return false;
        }
        int n2 = 0;
        while (n2 < n && this.start + n2 < this.finish) {
            if (this.buf[this.start + n2] != string.charAt(n2)) {
                return false;
            }
            ++n2;
        }
        if (n2 < n) {
            if (this.reader == null || this.isClosed) {
                return false;
            }
            if (n > this.buf.length) {
                this.fatal("P-077", new Object[]{new Integer(this.buf.length)});
            }
            this.fillbuf();
            return this.peek(string);
        }
        this.start += n;
        return true;
    }

    public void startRemembering() {
        if (this.startRemember != 0) {
            throw new InternalError();
        }
        this.startRemember = this.start;
    }

    public String rememberText() {
        String string;
        if (this.rememberedText != null) {
            this.rememberedText.append(this.buf, this.startRemember, this.start - this.startRemember);
            string = this.rememberedText.toString();
        } else {
            string = new String(this.buf, this.startRemember, this.start - this.startRemember);
        }
        this.startRemember = 0;
        this.rememberedText = null;
        return string;
    }

    private Locator getLocator() {
        InputEntity inputEntity = this;
        while (inputEntity != null && inputEntity.input == null) {
            inputEntity = inputEntity.next;
        }
        if (inputEntity == null) {
            return this;
        }
        return inputEntity;
    }

    public String getPublicId() {
        Locator locator = this.getLocator();
        if (locator == this) {
            return this.input.getPublicId();
        }
        return locator.getPublicId();
    }

    public String getSystemId() {
        Locator locator = this.getLocator();
        if (locator == this) {
            return this.input.getSystemId();
        }
        return locator.getSystemId();
    }

    public int getLineNumber() {
        Locator locator = this.getLocator();
        if (locator == this) {
            return this.lineNumber;
        }
        return locator.getLineNumber();
    }

    public int getColumnNumber() {
        return -1;
    }

    private void fillbuf() throws IOException, SAXException {
        boolean bl;
        if (this.reader == null || this.isClosed) {
            return;
        }
        if (this.startRemember != 0) {
            if (this.rememberedText == null) {
                this.rememberedText = new StringBuffer(this.buf.length);
            }
            this.rememberedText.append(this.buf, this.startRemember, this.start - this.startRemember);
        }
        boolean bl2 = bl = this.finish > 0 && this.start > 0;
        if (bl) {
            --this.start;
        }
        int n = this.finish - this.start;
        System.arraycopy(this.buf, this.start, this.buf, 0, n);
        this.start = 0;
        this.finish = n;
        try {
            n = this.buf.length - n;
            n = this.reader.read(this.buf, this.finish, n);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.fatal("P-075", new Object[]{unsupportedEncodingException.getMessage()});
        }
        catch (CharConversionException charConversionException) {
            this.fatal("P-076", new Object[]{charConversionException.getMessage()});
        }
        if (n >= 0) {
            this.finish += n;
        } else {
            this.close();
        }
        if (bl) {
            ++this.start;
        }
        if (this.startRemember != 0) {
            this.startRemember = 1;
        }
    }

    public void close() {
        try {
            if (this.reader != null && !this.isClosed) {
                this.reader.close();
            }
            this.isClosed = true;
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private void fatal(String string, Object[] objectArray) throws SAXException {
        SAXParseException sAXParseException = new SAXParseException(Parser.messages.getMessage(this.locale, string, objectArray), this);
        this.close();
        this.errHandler.fatalError(sAXParseException);
        throw sAXParseException;
    }
}

