/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.tree;

import java.io.IOException;
import java.io.Writer;

public class XmlWriteContext {
    private Writer writer;
    private int indentLevel;
    private boolean prettyOutput;

    public XmlWriteContext(Writer writer) {
        this.writer = writer;
    }

    public XmlWriteContext(Writer writer, int n) {
        this.writer = writer;
        this.prettyOutput = true;
        this.indentLevel = n;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public boolean isEntityDeclared(String string) {
        return "amp".equals(string) || "lt".equals(string) || "gt".equals(string) || "quot".equals(string) || "apos".equals(string);
    }

    public int getIndentLevel() {
        return this.indentLevel;
    }

    public void setIndentLevel(int n) {
        this.indentLevel = n;
    }

    public void printIndent() throws IOException {
        int n = this.indentLevel;
        if (!this.prettyOutput) {
            return;
        }
        this.writer.write(10);
        while (n >= 8) {
            this.writer.write(9);
            n -= 8;
        }
        while (n-- > 0) {
            this.writer.write(32);
        }
    }

    public boolean isPrettyOutput() {
        return this.prettyOutput;
    }
}

