/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.parser;

import java.io.ByteArrayInputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.util.Hashtable;

final class XmlReader
extends Reader {
    private static final int MAXPUSHBACK = 512;
    private Reader in;
    private String assignedEncoding;
    private boolean closed;
    private static final Hashtable charsets = new Hashtable(31);

    public static Reader createReader(InputStream inputStream) throws IOException {
        return new XmlReader(inputStream);
    }

    public static Reader createReader(InputStream inputStream, String string) throws IOException {
        if (string == null) {
            return new XmlReader(inputStream);
        }
        if ("UTF-8".equalsIgnoreCase(string) || "UTF8".equalsIgnoreCase(string)) {
            return new Utf8Reader(inputStream);
        }
        if ("US-ASCII".equalsIgnoreCase(string) || "ASCII".equalsIgnoreCase(string)) {
            return new AsciiReader(inputStream);
        }
        if ("ISO-8859-1".equalsIgnoreCase(string)) {
            return new Iso8859_1Reader(inputStream);
        }
        return new InputStreamReader(inputStream, XmlReader.std2java(string));
    }

    private static String std2java(String string) {
        String string2 = string.toUpperCase();
        if ((string2 = (String)charsets.get(string2)) != null) {
            return string2;
        }
        return string;
    }

    public String getEncoding() {
        return this.assignedEncoding;
    }

    /*
     * Exception decompiling
     */
    private XmlReader(InputStream var1_1) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CASE]], but top level block is 7[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    private void useEncodingDecl(PushbackInputStream var1_1, String var2_2) throws IOException {
        var3_3 = new byte[512];
        var4_4 = var1_1.read(var3_3, 0, var3_3.length);
        var1_1.unread(var3_3, 0, var4_4);
        var5_5 = new InputStreamReader((InputStream)new ByteArrayInputStream(var3_3, 4, var4_4), var2_2);
        var6_6 = var5_5.read();
        if (var6_6 != 108) {
            this.setEncoding(var1_1, "UTF-8");
            return;
        }
        var7_7 = new StringBuffer();
        var8_8 = null;
        var9_9 = null;
        var10_10 = false;
        var11_11 = '\u0000';
        var12_12 = false;
        var13_13 = 0;
        block0: while (var13_13 < 507) {
            block19: {
                block20: {
                    var6_6 = var5_5.read();
                    if (var6_6 == -1) break;
                    if (var6_6 == 32 || var6_6 == 9 || var6_6 == 10 || var6_6 == 13) break block19;
                    if (var13_13 == 0) break;
                    if (var6_6 == 63) {
                        var12_12 = true;
                    } else if (var12_12) {
                        if (var6_6 == 62) break;
                        var12_12 = false;
                    }
                    if (var9_9 != null && var10_10) break block20;
                    if (var8_8 == null) {
                        if (!Character.isWhitespace((char)var6_6)) {
                            var8_8 = var7_7;
                            var7_7.setLength(0);
                            var7_7.append((char)var6_6);
                            var10_10 = false;
                        }
                    } else if (Character.isWhitespace((char)var6_6)) {
                        var9_9 = var8_8.toString();
                    } else if (var6_6 == 61) {
                        if (var9_9 == null) {
                            var9_9 = var8_8.toString();
                        }
                        var10_10 = true;
                        var8_8 = null;
                        var11_11 = '\u0000';
                    } else {
                        var8_8.append((char)var6_6);
                    }
                    break block19;
                }
                if (Character.isWhitespace((char)var6_6)) break block19;
                if (var6_6 != 34 && var6_6 != 39) ** GOTO lbl-1000
                if (var11_11 == '\u0000') {
                    var11_11 = (char)var6_6;
                    var7_7.setLength(0);
                } else if (var6_6 == var11_11) {
                    if ("encoding".equals(var9_9)) {
                        this.assignedEncoding = var7_7.toString();
                        var13_13 = 0;
                        while (var13_13 < this.assignedEncoding.length()) {
                            var6_6 = this.assignedEncoding.charAt(var13_13);
                            if (!(var6_6 >= 65 && var6_6 <= 90 || var6_6 >= 97 && var6_6 <= 122) && (var13_13 == 0 || var13_13 <= 0 || var6_6 != 45 && (var6_6 < 48 || var6_6 > 57) && var6_6 != 46 && var6_6 != 95)) break block0;
                            ++var13_13;
                        }
                        this.setEncoding(var1_1, this.assignedEncoding);
                        return;
                    }
                    var9_9 = null;
                } else lbl-1000:
                // 2 sources

                {
                    var7_7.append((char)var6_6);
                }
            }
            ++var13_13;
        }
        this.setEncoding(var1_1, "UTF-8");
    }

    private void setEncoding(InputStream inputStream, String string) throws IOException {
        this.assignedEncoding = string;
        this.in = XmlReader.createReader(inputStream, string);
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        if (this.closed) {
            return -1;
        }
        int n3 = this.in.read(cArray, n, n2);
        if (n3 == -1) {
            this.close();
        }
        return n3;
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        int n = this.in.read();
        if (n == -1) {
            this.close();
        }
        return n;
    }

    public boolean markSupported() {
        if (this.in == null) {
            return false;
        }
        return this.in.markSupported();
    }

    public void mark(int n) throws IOException {
        if (this.in != null) {
            this.in.mark(n);
        }
    }

    public void reset() throws IOException {
        if (this.in != null) {
            this.in.reset();
        }
    }

    public long skip(long l) throws IOException {
        if (this.in == null) {
            return 0L;
        }
        return this.in.skip(l);
    }

    public boolean ready() throws IOException {
        if (this.in == null) {
            return false;
        }
        return this.in.ready();
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.in.close();
        this.in = null;
        this.closed = true;
    }

    static {
        charsets.put("UTF-16", "Unicode");
        charsets.put("ISO-10646-UCS-2", "Unicode");
        charsets.put("EBCDIC-CP-US", "cp037");
        charsets.put("EBCDIC-CP-CA", "cp037");
        charsets.put("EBCDIC-CP-NL", "cp037");
        charsets.put("EBCDIC-CP-WT", "cp037");
        charsets.put("EBCDIC-CP-DK", "cp277");
        charsets.put("EBCDIC-CP-NO", "cp277");
        charsets.put("EBCDIC-CP-FI", "cp278");
        charsets.put("EBCDIC-CP-SE", "cp278");
        charsets.put("EBCDIC-CP-IT", "cp280");
        charsets.put("EBCDIC-CP-ES", "cp284");
        charsets.put("EBCDIC-CP-GB", "cp285");
        charsets.put("EBCDIC-CP-FR", "cp297");
        charsets.put("EBCDIC-CP-AR1", "cp420");
        charsets.put("EBCDIC-CP-HE", "cp424");
        charsets.put("EBCDIC-CP-BE", "cp500");
        charsets.put("EBCDIC-CP-CH", "cp500");
        charsets.put("EBCDIC-CP-ROECE", "cp870");
        charsets.put("EBCDIC-CP-YU", "cp870");
        charsets.put("EBCDIC-CP-IS", "cp871");
        charsets.put("EBCDIC-CP-AR2", "cp918");
    }

    static abstract class BaseReader
    extends Reader {
        protected InputStream instream;
        protected byte[] buffer;
        protected int start;
        protected int finish;

        BaseReader(InputStream inputStream) {
            super(inputStream);
            this.instream = inputStream;
            this.buffer = new byte[8192];
        }

        public boolean ready() throws IOException {
            return this.instream == null || this.finish - this.start > 0 || this.instream.available() != 0;
        }

        public void close() throws IOException {
            if (this.instream != null) {
                this.instream.close();
                this.finish = 0;
                this.start = 0;
                this.buffer = null;
                this.instream = null;
            }
        }
    }

    static final class Utf8Reader
    extends BaseReader {
        private char nextChar;

        Utf8Reader(InputStream inputStream) {
            super(inputStream);
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            int n3 = 0;
            int n4 = 0;
            if (n2 <= 0) {
                return 0;
            }
            if (this.nextChar != '\u0000') {
                cArray[n + n3++] = this.nextChar;
                this.nextChar = '\u0000';
            }
            while (n3 < n2) {
                int n5;
                block19: {
                    if (this.finish <= this.start) {
                        if (this.instream == null) {
                            n4 = -1;
                            break;
                        }
                        this.start = 0;
                        this.finish = this.instream.read(this.buffer, 0, this.buffer.length);
                        if (this.finish <= 0) {
                            this.close();
                            n4 = -1;
                            break;
                        }
                    }
                    if (((n4 = this.buffer[this.start] & 0xFF) & 0x80) == 0) {
                        ++this.start;
                        cArray[n + n3++] = (char)n4;
                        continue;
                    }
                    n5 = this.start;
                    try {
                        if ((this.buffer[n5] & 0xE0) == 192) {
                            n4 = (this.buffer[n5++] & 0x1F) << 6;
                            n4 += this.buffer[n5++] & 0x3F;
                            break block19;
                        }
                        if ((this.buffer[n5] & 0xF0) == 224) {
                            n4 = (this.buffer[n5++] & 0xF) << 12;
                            n4 += (this.buffer[n5++] & 0x3F) << 6;
                            n4 += this.buffer[n5++] & 0x3F;
                            break block19;
                        }
                        if ((this.buffer[n5] & 0xF8) == 240) {
                            n4 = (this.buffer[n5++] & 7) << 18;
                            n4 += (this.buffer[n5++] & 0x3F) << 12;
                            n4 += (this.buffer[n5++] & 0x3F) << 6;
                            if ((n4 += this.buffer[n5++] & 0x3F) > 0x10FFFF) {
                                throw new CharConversionException("UTF-8 encoding of character 0x00" + Integer.toHexString(n4) + " can't be converted to Unicode.");
                            }
                            this.nextChar = (char)(56320 + ((n4 -= 65536) & 0x3FF));
                            n4 = 55296 + (n4 >> 10);
                            break block19;
                        }
                        throw new CharConversionException("Unconvertible UTF-8 character beginning with 0x" + Integer.toHexString(this.buffer[this.start] & 0xFF));
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        n4 = 0;
                    }
                }
                if (n5 > this.finish) {
                    System.arraycopy(this.buffer, this.start, this.buffer, 0, this.finish - this.start);
                    this.finish -= this.start;
                    this.start = 0;
                    n5 = this.instream.read(this.buffer, this.finish, this.buffer.length - this.finish);
                    if (n5 < 0) {
                        this.close();
                        throw new CharConversionException("Partial UTF-8 char");
                    }
                    this.finish += n5;
                    continue;
                }
                ++this.start;
                while (this.start < n5) {
                    if ((this.buffer[this.start] & 0xC0) != 128) {
                        this.close();
                        throw new CharConversionException("Malformed UTF-8 char -- is an XML encoding declaration missing?");
                    }
                    ++this.start;
                }
                cArray[n + n3++] = (char)n4;
                if (this.nextChar == '\u0000' || n3 >= n2) continue;
                cArray[n + n3++] = this.nextChar;
                this.nextChar = '\u0000';
            }
            if (n3 > 0) {
                return n3;
            }
            if (n4 == -1) {
                return -1;
            }
            return 0;
        }
    }

    static final class AsciiReader
    extends BaseReader {
        AsciiReader(InputStream inputStream) {
            super(inputStream);
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            if (this.instream == null) {
                return -1;
            }
            int n3 = 0;
            while (n3 < n2) {
                byte by;
                if (this.start >= this.finish) {
                    this.start = 0;
                    this.finish = this.instream.read(this.buffer, 0, this.buffer.length);
                    if (this.finish <= 0) {
                        if (this.finish > 0) break;
                        this.close();
                        break;
                    }
                }
                if (((by = this.buffer[this.start++]) & 0x80) != 0) {
                    throw new CharConversionException("Illegal ASCII character, 0x" + Integer.toHexString(this.buffer[this.start] & 0xFF));
                }
                cArray[n + n3] = (char)by;
                ++n3;
            }
            if (n3 == 0 && this.finish <= 0) {
                return -1;
            }
            return n3;
        }
    }

    static final class Iso8859_1Reader
    extends BaseReader {
        Iso8859_1Reader(InputStream inputStream) {
            super(inputStream);
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            if (this.instream == null) {
                return -1;
            }
            int n3 = 0;
            while (n3 < n2) {
                if (this.start >= this.finish) {
                    this.start = 0;
                    this.finish = this.instream.read(this.buffer, 0, this.buffer.length);
                    if (this.finish <= 0) {
                        if (this.finish > 0) break;
                        this.close();
                        break;
                    }
                }
                cArray[n + n3] = (char)(0xFF & this.buffer[this.start++]);
                ++n3;
            }
            if (n3 == 0 && this.finish <= 0) {
                return -1;
            }
            return n3;
        }
    }
}

