/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.tree;

import com.sun.xml.tree.DomEx;
import com.sun.xml.tree.ElementNode;
import com.sun.xml.tree.NamespaceScoped;
import com.sun.xml.tree.NodeBase;
import com.sun.xml.tree.XmlDocument;
import com.sun.xml.tree.XmlWriteContext;
import com.sun.xml.util.XmlNames;
import java.io.IOException;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

final class AttributeNode
extends NodeBase
implements Attr,
NamespaceScoped {
    private String name;
    private String value;
    private boolean specified;
    private String defaultValue;
    private ElementNode nameScope;

    public AttributeNode(AttributeNode attributeNode) throws DOMException {
        this(attributeNode.name, attributeNode.value, attributeNode.specified, attributeNode.defaultValue);
        this.nameScope = attributeNode.nameScope;
        this.setOwnerDocument((XmlDocument)attributeNode.getOwnerDocument());
    }

    public AttributeNode(String string, String string2, boolean bl, String string3) throws DOMException {
        if (!XmlNames.isName(string)) {
            throw new DomEx(5);
        }
        this.name = string;
        this.value = string2;
        this.specified = bl;
        this.defaultValue = string3;
    }

    void setNameScope(ElementNode elementNode) {
        if (elementNode != null && this.nameScope != null) {
            throw new IllegalStateException(this.getMessage("A-000", new Object[]{elementNode.getTagName()}));
        }
        this.nameScope = elementNode;
    }

    ElementNode getNameScope() {
        return this.nameScope;
    }

    String getDefaultValue() {
        return this.defaultValue;
    }

    public String getNamespace() {
        if (this.nameScope == null) {
            throw new IllegalStateException(this.getMessage("A-001"));
        }
        int n = this.name.indexOf(58);
        if (n < 0) {
            return this.nameScope.getNamespace();
        }
        String string = this.name.substring(0, n);
        if ("xml".equals(string) || "xmlns".equals(string)) {
            return null;
        }
        String string2 = this.nameScope.getInheritedAttribute("xmlns:" + string);
        if (string2 == null) {
            throw new IllegalStateException();
        }
        return string2;
    }

    public String getLocalName() {
        int n = this.name.indexOf(58);
        if (n < 0) {
            return this.name;
        }
        return this.name.substring(n + 1);
    }

    public short getNodeType() {
        return 2;
    }

    public String getName() {
        return this.name;
    }

    public String getNodeName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.setNodeValue(string);
    }

    public String getNodeValue() {
        return this.value;
    }

    public boolean getSpecified() {
        return this.specified;
    }

    public void setNodeValue(String string) {
        this.value = string;
        this.specified = true;
    }

    void setSpecified(boolean bl) {
        this.specified = bl;
    }

    public Node getParentNode() {
        return null;
    }

    public Node getNextSibling() {
        return null;
    }

    public Node getPreviousSibling() {
        return null;
    }

    public void writeXml(XmlWriteContext xmlWriteContext) throws IOException {
        Writer writer = xmlWriteContext.getWriter();
        writer.write(this.name);
        writer.write("=\"");
        this.writeChildrenXml(xmlWriteContext);
        writer.write(34);
    }

    public void writeChildrenXml(XmlWriteContext xmlWriteContext) throws IOException {
        Writer writer = xmlWriteContext.getWriter();
        int n = 0;
        while (n < this.value.length()) {
            char c = this.value.charAt(n);
            switch (c) {
                case '<': {
                    writer.write("&lt;");
                    break;
                }
                case '>': {
                    writer.write("&gt;");
                    break;
                }
                case '&': {
                    writer.write("&amp;");
                    break;
                }
                case '\'': {
                    writer.write("&apos;");
                    break;
                }
                case '\"': {
                    writer.write("&quot;");
                    break;
                }
                default: {
                    writer.write(c);
                    break;
                }
            }
            ++n;
        }
    }

    public Node cloneNode(boolean bl) {
        try {
            return new AttributeNode(this);
        }
        catch (DOMException dOMException) {
            throw new RuntimeException(this.getMessage("A-002"));
        }
    }
}

