/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.tree;

import com.sun.xml.parser.AttributeListEx;
import com.sun.xml.parser.DtdEventListener;
import com.sun.xml.parser.LexicalEventListener;
import com.sun.xml.parser.Parser;
import com.sun.xml.tree.AttributeSet;
import com.sun.xml.tree.Doctype;
import com.sun.xml.tree.ElementFactory;
import com.sun.xml.tree.ElementNode;
import com.sun.xml.tree.NodeEx;
import com.sun.xml.tree.PINode;
import com.sun.xml.tree.ParentNode;
import com.sun.xml.tree.ParseContext;
import com.sun.xml.tree.TextNode;
import com.sun.xml.tree.XmlDocument;
import java.util.Locale;
import java.util.Vector;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.EntityReference;
import org.xml.sax.AttributeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlDocumentBuilder
implements LexicalEventListener {
    private static final String xmlURI = "http://www.w3.com/XML/1998/namespace";
    private XmlDocument document;
    private Locator locator;
    private ParseContextImpl context = new ParseContextImpl();
    private Locale locale = Locale.getDefault();
    private ElementFactory factory;
    private Parser parser;
    private Vector attrTmp = new Vector();
    private ParentNode[] elementStack;
    private int topOfStack;
    private boolean inDTD;
    private boolean inCDataSection;
    private boolean ignoringLexicalInfo = true;
    private boolean disableNamespaces = false;

    public boolean isIgnoringLexicalInfo() {
        return this.ignoringLexicalInfo;
    }

    public void setIgnoringLexicalInfo(boolean bl) {
        this.ignoringLexicalInfo = bl;
    }

    public boolean getDisableNamespaces() {
        return this.disableNamespaces;
    }

    public void setDisableNamespaces(boolean bl) {
        this.disableNamespaces = bl;
    }

    public void setParser(org.xml.sax.Parser parser) {
        parser.setDocumentHandler(this);
        if (parser instanceof Parser) {
            this.parser = (Parser)parser;
            this.parser.setDTDHandler(new DtdListener());
            return;
        }
        this.parser = null;
    }

    public Parser getParser() {
        return this.parser;
    }

    public XmlDocument getDocument() {
        return this.document;
    }

    public Locale getLocale() {
        if (this.parser != null) {
            return this.parser.getLocale();
        }
        return this.locale;
    }

    public void setLocale(Locale locale) throws SAXException {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (this.parser != null) {
            this.parser.setLocale(locale);
        }
        this.locale = locale;
    }

    public Locale chooseLocale(String[] stringArray) throws SAXException {
        Locale locale = XmlDocument.catalog.chooseLocale(stringArray);
        if (locale != null) {
            this.setLocale(locale);
        }
        return locale;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public Locator getDocumentLocator() {
        return this.locator;
    }

    public XmlDocument createDocument() {
        XmlDocument xmlDocument = new XmlDocument();
        if (this.factory != null) {
            xmlDocument.setElementFactory(this.factory);
        }
        return xmlDocument;
    }

    public final void setElementFactory(ElementFactory elementFactory) {
        this.factory = elementFactory;
    }

    public final ElementFactory getElementFactory() {
        return this.factory;
    }

    public void startDocument() throws SAXException {
        this.document = this.createDocument();
        if (this.locator != null) {
            this.document.setSystemId(this.locator.getSystemId());
        }
        this.elementStack = new ParentNode[200];
        this.topOfStack = 0;
        this.elementStack[this.topOfStack] = this.document;
        this.inDTD = false;
        this.document.startParse(this.context);
    }

    public void endDocument() throws SAXException {
        if (this.topOfStack != 0) {
            throw new IllegalStateException(this.getMessage("XDB-000"));
        }
        this.document.doneParse(this.context);
        this.document.trimToSize();
    }

    private String getNamespaceURI(String string) {
        if ("xml".equals(string)) {
            return xmlURI;
        }
        if ("xmlns".equals(string)) {
            return null;
        }
        return this.elementStack[this.topOfStack].getInheritedAttribute("xmlns:" + string);
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        String string2;
        String string3;
        int n;
        AttributeSet attributeSet = null;
        ElementNode elementNode = null;
        int n2 = n = attributeList == null ? 0 : attributeList.getLength();
        if (n != 0) {
            try {
                if (!this.disableNamespaces) {
                    int n3 = 0;
                    while (n3 < n) {
                        string3 = attributeList.getType(n3);
                        if (!"CDATA".equals(string3) && !string3.startsWith("NMTOKEN") && string.indexOf(58) != -1) {
                            this.error(new SAXParseException(this.getMessage("XDB-001", new Object[]{attributeList.getName(n3)}), this.locator));
                        }
                        ++n3;
                    }
                }
                attributeSet = new AttributeSet(attributeList);
            }
            catch (DOMException dOMException) {
                this.fatal(new SAXParseException(this.getMessage("XDB-002", new Object[]{dOMException.getMessage()}), this.locator, dOMException));
            }
        }
        try {
            if (this.disableNamespaces) {
                elementNode = (ElementNode)this.document.createElementEx(string);
            } else {
                int n4 = string.indexOf(58);
                string3 = "xmlns";
                String string4 = "";
                string2 = string;
                if (n4 != -1) {
                    string3 = "xmlns:" + string.substring(0, n4);
                    string2 = string.substring(n4 + 1);
                    if (string.lastIndexOf(58) != n4) {
                        this.error(new SAXParseException(this.getMessage("XDB-003", new Object[]{string}), this.locator));
                    }
                }
                if (attributeSet != null) {
                    string4 = attributeSet.getValue(string3);
                }
                if ("".equals(string4)) {
                    string4 = this.elementStack[this.topOfStack].getInheritedAttribute(string3);
                }
                elementNode = (ElementNode)this.document.createElementEx(string4, string2);
                if (string2 != string) {
                    elementNode.setTag(string);
                }
            }
        }
        catch (DOMException dOMException) {
            this.fatal(new SAXParseException(this.getMessage("XDB-004", new Object[]{dOMException.getMessage()}), this.locator, dOMException));
        }
        if (attributeList != null && attributeList instanceof AttributeListEx) {
            elementNode.setIdAttributeName(((AttributeListEx)attributeList).getIdAttributeName());
        }
        if (n != 0) {
            elementNode.setAttributes(attributeSet);
        }
        this.elementStack[this.topOfStack++].appendChild(elementNode);
        this.elementStack[this.topOfStack] = elementNode;
        elementNode.startParse(this.context);
        if (!this.disableNamespaces) {
            int n5 = string.indexOf(58);
            if (n5 > 0 && this.getNamespaceURI(string3 = string.substring(0, n5)) == null) {
                this.error(new SAXParseException(this.getMessage("XDB-005", new Object[]{string3}), this.locator));
            }
            if (n != 0) {
                int n6 = 0;
                while (n6 < n) {
                    string2 = attributeSet.item(n6).getNodeName();
                    n5 = string2.indexOf(58);
                    if (n5 > 0 && !"xmlns".equals(string3 = string2.substring(0, n5))) {
                        String string5 = this.getNamespaceURI(string3);
                        if (string5 == null) {
                            this.error(new SAXParseException(this.getMessage("XDB-006", new Object[]{string3}), this.locator));
                        } else {
                            if (string2.lastIndexOf(58) != n5) {
                                this.error(new SAXParseException(this.getMessage("XDB-007", new Object[]{string2}), this.locator));
                            }
                            string2 = string2.substring(n5 + 1);
                            string2 = String.valueOf(string5) + '\uffff' + string2;
                            if (this.attrTmp.contains(string2)) {
                                this.error(new SAXParseException(this.getMessage("XDB-008", new Object[]{attributeSet.item(n6).getNodeName()}), this.locator));
                            } else {
                                this.attrTmp.addElement(string2);
                            }
                        }
                    }
                    ++n6;
                }
                this.attrTmp.setSize(0);
            }
        }
    }

    public void endElement(String string) throws SAXException {
        ElementNode elementNode = (ElementNode)this.elementStack[this.topOfStack];
        this.elementStack[this.topOfStack--] = null;
        if (!string.equals(elementNode.getTagName())) {
            this.fatal(new SAXParseException(this.getMessage("XDB-009", new Object[]{string, elementNode.getTagName()}), this.locator));
        }
        try {
            elementNode.doneParse(this.context);
            elementNode.reduceWaste();
            this.elementStack[this.topOfStack].doneChild(elementNode, this.context);
            return;
        }
        catch (DOMException dOMException) {
            this.fatal(new SAXParseException(this.getMessage("XDB-004", new Object[]{dOMException.getMessage()}), this.locator, dOMException));
            return;
        }
    }

    public void comment(String string) throws SAXException {
        if (this.ignoringLexicalInfo || this.inDTD) {
            return;
        }
        Comment comment = this.document.createComment(string);
        ParentNode parentNode = this.elementStack[this.topOfStack];
        try {
            parentNode.appendChild(comment);
            parentNode.doneChild((NodeEx)((Object)comment), this.context);
            return;
        }
        catch (DOMException dOMException) {
            this.fatal(new SAXParseException(this.getMessage("XDB-004", new Object[]{dOMException.getMessage()}), this.locator, dOMException));
            return;
        }
    }

    public void startCDATA() throws SAXException {
        if (this.ignoringLexicalInfo) {
            return;
        }
        CDATASection cDATASection = this.document.createCDATASection("");
        ParentNode parentNode = this.elementStack[this.topOfStack];
        try {
            this.inCDataSection = true;
            parentNode.appendChild(cDATASection);
            return;
        }
        catch (DOMException dOMException) {
            this.fatal(new SAXParseException(this.getMessage("XDB-004", new Object[]{dOMException.getMessage()}), this.locator, dOMException));
            return;
        }
    }

    public void endCDATA() throws SAXException {
        if (!this.inCDataSection) {
            return;
        }
        ParentNode parentNode = this.elementStack[this.topOfStack];
        try {
            this.inCDataSection = false;
            parentNode.doneChild((NodeEx)parentNode.getLastChild(), this.context);
            return;
        }
        catch (DOMException dOMException) {
            this.fatal(new SAXParseException(this.getMessage("XDB-004", new Object[]{dOMException.getMessage()}), this.locator, dOMException));
            return;
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        ParentNode parentNode = this.elementStack[this.topOfStack];
        if (this.inCDataSection) {
            String string = new String(cArray, n, n2);
            CDATASection cDATASection = (CDATASection)parentNode.getLastChild();
            cDATASection.appendData(string);
            return;
        }
        TextNode textNode = this.document.newText(cArray, n, n2);
        try {
            parentNode.appendChild(textNode);
            parentNode.doneChild(textNode, this.context);
            return;
        }
        catch (DOMException dOMException) {
            this.fatal(new SAXParseException(this.getMessage("XDB-004", new Object[]{dOMException.getMessage()}), this.locator, dOMException));
            return;
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.ignoringLexicalInfo) {
            return;
        }
        ParentNode parentNode = this.elementStack[this.topOfStack];
        if (this.inCDataSection) {
            String string = new String(cArray, n, n2);
            CDATASection cDATASection = (CDATASection)parentNode.getLastChild();
            cDATASection.appendData(string);
            return;
        }
        TextNode textNode = this.document.newText(cArray, n, n2);
        try {
            parentNode.appendChild(textNode);
            parentNode.doneChild(textNode, this.context);
            return;
        }
        catch (DOMException dOMException) {
            this.fatal(new SAXParseException(this.getMessage("XDB-004", new Object[]{dOMException.getMessage()}), this.locator, dOMException));
            return;
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (!this.disableNamespaces && string.indexOf(58) != -1) {
            this.error(new SAXParseException(this.getMessage("XDB-010"), this.locator));
        }
        if (this.inDTD) {
            return;
        }
        ParentNode parentNode = this.elementStack[this.topOfStack];
        try {
            PINode pINode = (PINode)this.document.createProcessingInstruction(string, string2);
            parentNode.appendChild(pINode);
            parentNode.doneChild(pINode, this.context);
            return;
        }
        catch (DOMException dOMException) {
            this.fatal(new SAXParseException(this.getMessage("XDB-004", new Object[]{dOMException.getMessage()}), this.locator, dOMException));
            return;
        }
    }

    public void startParsedEntity(String string) throws SAXException {
        if (this.ignoringLexicalInfo) {
            return;
        }
        EntityReference entityReference = this.document.createEntityReference(string);
        this.elementStack[this.topOfStack++].appendChild(entityReference);
        this.elementStack[this.topOfStack] = (ParentNode)((Object)entityReference);
    }

    public void endParsedEntity(String string, boolean bl) throws SAXException {
        ParentNode parentNode = this.elementStack[this.topOfStack];
        if (!(parentNode instanceof EntityReference)) {
            return;
        }
        parentNode.setReadonly(true);
        this.elementStack[this.topOfStack--] = null;
        if (!string.equals(parentNode.getNodeName())) {
            this.fatal(new SAXParseException(this.getMessage("XDB-011", new Object[]{string, parentNode.getNodeName()}), this.locator));
        }
        try {
            this.elementStack[this.topOfStack].doneChild(parentNode, this.context);
            return;
        }
        catch (DOMException dOMException) {
            this.fatal(new SAXParseException(this.getMessage("XDB-004", new Object[]{dOMException.getMessage()}), this.locator, dOMException));
            return;
        }
    }

    private void error(SAXParseException sAXParseException) throws SAXException {
        if (this.parser != null) {
            this.parser.getErrorHandler().error(sAXParseException);
            return;
        }
        throw sAXParseException;
    }

    private void fatal(SAXParseException sAXParseException) throws SAXException {
        if (this.parser != null) {
            this.parser.getErrorHandler().fatalError(sAXParseException);
        }
        throw sAXParseException;
    }

    String getMessage(String string) {
        return this.getMessage(string, null);
    }

    String getMessage(String string, Object[] objectArray) {
        if (this.locale == null) {
            this.getLocale();
        }
        return XmlDocument.catalog.getMessage(this.locale, string, objectArray);
    }

    static /* synthetic */ boolean access$1(XmlDocumentBuilder xmlDocumentBuilder) {
        return xmlDocumentBuilder.inDTD;
    }

    class ParseContextImpl
    implements ParseContext {
        public ErrorHandler getErrorHandler() {
            if (XmlDocumentBuilder.this.parser != null) {
                return XmlDocumentBuilder.this.parser.getErrorHandler();
            }
            return null;
        }

        public Locale getLocale() {
            return XmlDocumentBuilder.this.getLocale();
        }

        public Locator getLocator() {
            return XmlDocumentBuilder.this.locator;
        }

        ParseContextImpl() {
            XmlDocumentBuilder.this = XmlDocumentBuilder.this;
        }
    }

    class DtdListener
    implements DtdEventListener {
        private Doctype doctype;
        private String publicId;
        private String systemId;
        private String internalSubset;

        public void startDtd(String string) {
            this.doctype = XmlDocumentBuilder.this.document.createDoctype(string);
            XmlDocumentBuilder.this.inDTD = true;
        }

        public void externalDtdDecl(String string, String string2) throws SAXException {
            this.publicId = string;
            this.systemId = string2;
        }

        public void internalDtdDecl(String string) throws SAXException {
            this.internalSubset = string;
        }

        public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
            if (!XmlDocumentBuilder.this.disableNamespaces && string.indexOf(58) != -1) {
                XmlDocumentBuilder.this.error(new SAXParseException(XmlDocumentBuilder.this.getMessage("XDB-012"), XmlDocumentBuilder.this.locator));
            }
            this.doctype.addEntityNode(string, string2, string3, null);
        }

        public void internalEntityDecl(String string, String string2) throws SAXException {
            if (!XmlDocumentBuilder.this.disableNamespaces && string.indexOf(58) != -1) {
                XmlDocumentBuilder.this.error(new SAXParseException(XmlDocumentBuilder.this.getMessage("XDB-012"), XmlDocumentBuilder.this.locator));
            }
            this.doctype.addEntityNode(string, string2);
        }

        public void notationDecl(String string, String string2, String string3) throws SAXException {
            if (!XmlDocumentBuilder.this.disableNamespaces && string.indexOf(58) != -1) {
                XmlDocumentBuilder.this.error(new SAXParseException(XmlDocumentBuilder.this.getMessage("XDB-013"), XmlDocumentBuilder.this.locator));
            }
            this.doctype.addNotation(string, string2, string3);
        }

        public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
            if (!XmlDocumentBuilder.this.disableNamespaces && string.indexOf(58) != -1) {
                XmlDocumentBuilder.this.error(new SAXParseException(XmlDocumentBuilder.this.getMessage("XDB-012"), XmlDocumentBuilder.this.locator));
            }
            this.doctype.addEntityNode(string, string2, string3, string4);
        }

        public void endDtd() {
            this.doctype.setPrintInfo(this.publicId, this.systemId, this.internalSubset);
            XmlDocumentBuilder.this.document.appendChild(this.doctype);
            XmlDocumentBuilder.this.inDTD = false;
        }

        DtdListener() {
            XmlDocumentBuilder.this = XmlDocumentBuilder.this;
        }
    }
}

