/**
 * Etude de cas CouponBleu - Commande de Textiles
 */


import sunsoft.jws.visual.rt.base.*;
import sunsoft.jws.visual.rt.shadow.java.awt.*;
import org.w3c.dom.NodeList ;
import com.sun.xml.tree.ElementNode ;
import com.sun.xml.tree.XmlDocument;
import java.awt.*;
import java.io.CharArrayWriter ;
import java.io.IOException ;
import java.net.URL ;


public class Commande extends Group
    {
    private CommandeRoot gui;
    private CommandeRpc com ;
    private URL codeBase ;

    public Commande()
    {
	// On initialise le validateur de bon de commande
	com = new CommandeRpc() ;

	addForwardedAttributes();
    }


    protected Root initRoot()
    {
        // Initialisation de la fenetre de commande
        gui = new CommandeRoot(this);

        addAttributeForward(gui.getMainChild());
        return gui;
    }

    protected void initGroup()
    {
    gui.Date.set("text", com.getDate()) ;
    gui.Fournisseur.set("text", com.getFournisseur()) ;
    }
    public void setCodeBase(URL u)
    {
/*
    Ajouter dans ComandeMain le code lors de l'init() :

    Commande group = new Commande();
    group.setCodeBase(getCodeBase()) ;
*/
    codeBase = u ;
    }
    
    public boolean action(Message msg, Event evt, Object what)
    {
	if (msg.target == gui.Validation)
	{
	    String NCommande = (String)gui.Commande.get("text") ;
	    if (NCommande.length() != 6) {
		afficheErrorMessage("Le numro de commande doit etre numrique sur 6 chiffres") ;
		return false ;
	    }
	    try {
		com.setCommande(Integer.parseInt(NCommande)) ;
	    } catch (NumberFormatException e) {
		afficheErrorMessage("Numro de commande incorrect\nEntrez un nombre de six chiffres");
		return false ;
	    }
	    com.setDate((String)gui.Date.get("text")) ;
	    String Client = (String)gui.Client.get("text") ;
	    if (Client.length() != 13) {
		afficheErrorMessage("L'identifiant client doit faire 13 caractres") ;
		return false ;
	    }
    	    com.setClient(Client) ;
	    com.setFournisseur((String)gui.Fournisseur.get("text")) ;

	    try {
		com.setTissus(0, Integer.parseInt((String)gui.Tissus1.get("text"))) ;
		com.setDescription(0, (String)gui.Description1.get("text")) ;
		com.setCouleur(0, Integer.parseInt((String)gui.Couleur1.get("text"))) ;
		com.setArticle(0, Integer.parseInt((String)gui.Article1.get("text"))) ;
		com.setDimension(0, Integer.parseInt((String)gui.Dimension1.get("text"))) ;
		com.setQuantite(0, Integer.parseInt((String)gui.Quantite1.get("text"))) ;

	    } catch (NumberFormatException e) {
		afficheErrorMessage("Les informations saisies pour le premier article sont incorrectes\nEntrez des valeurs numriques positives");
		return false ;
	    }

	    String Tissus2 = (String)gui.Tissus2.get("text");
	    if (! "0".equals(Tissus2)) try {
		com.setTissus(1, Integer.parseInt((String)gui.Tissus2.get("text"))) ;
		com.setDescription(1, (String)gui.Description2.get("text")) ;
		com.setCouleur(1, Integer.parseInt((String)gui.Couleur2.get("text"))) ;
		com.setArticle(1, Integer.parseInt((String)gui.Article2.get("text"))) ;
		com.setDimension(1, Integer.parseInt((String)gui.Dimension2.get("text"))) ;
		com.setQuantite(1, Integer.parseInt((String)gui.Quantite2.get("text"))) ;
	    } catch (NumberFormatException e) {
		afficheErrorMessage("Les informations saisies pour le second article sont incorrectes\nEntrez des valeurs numriques positives");
		return false ;
	    }
	    XmlDocument doc = com.EmetCommande(
		gui,
		codeBase.getProtocol() + "://" +
		codeBase.getHost() + ":" +
		codeBase.getPort() +
		"/servlet/CouponBleu") ;
	    afficheConfirmCommande(doc) ;
	    return true ;
	}
	return false;
    }

    private void afficheConfirmCommande(XmlDocument doc)
    {
	doc.getDocumentElement().normalize() ; // Compacte les noeuds texte adjacents
	NodeList NLArticle = doc.getDocumentElement().getElementsByTagName("editexml:ConfirmArticle") ;
	String SConfirm = "" ;
	
	for (int i = 0; i < NLArticle.getLength(); i ++)
	{
	    NodeList NL = NLArticle.item(i).getChildNodes() ;

	    int Tissus = Integer.parseInt(NL.item(0).getChildNodes().item(0).getNodeValue()) ;
	    String Description = NL.item(1).getChildNodes().item(0).getNodeValue() ;
	    int Couleur = Integer.parseInt(NL.item(2).getChildNodes().item(0).getNodeValue()) ;
	    int Article = Integer.parseInt(NL.item(3).getChildNodes().item(0).getNodeValue()) ;
	    int Dimension = Integer.parseInt(NL.item(4).getChildNodes().item(0).getNodeValue()) ;
	    int Quantite = Integer.parseInt(NL.item(5).getChildNodes().item(0).getNodeValue()) ;
	    int Disponible = Integer.parseInt(NL.item(6).getChildNodes().item(0).getNodeValue()) ;
	    String LDate = NL.item(7).getChildNodes().item(0).getNodeValue() ;

	SConfirm = SConfirm + "L'article de rfrence : " + Article + " est disponible en quantit : " + Disponible + " pour le : " + LDate + "\n" ;
	SConfirm = SConfirm + "\tRappel : Code tissus : " + Tissus + ", Description : " + Description + ", Code couleur : " + Couleur + ", Code dimension : " + Dimension + ", Quantit : " + Quantite + "\n\n" ;
	}
	
	gui.TexteConfirm.set("text", SConfirm);
	try {
	    CharArrayWriter toStr = new CharArrayWriter() ;
	    doc.write (toStr);	
   	    gui.XmlConfirm.set("text", toStr.toString());
	} catch (IOException e) {
	}
        gui.ConfirmCommande.show();
    }

    private void afficheErrorMessage(String msg)
    {
	gui.LabelErreur.set("text", msg);
        gui.MessageErreur.show();
    }
}
