/*
 * Etude de cas CouponBleu - CommandeRpc.java
 */

import sunsoft.jws.visual.rt.base.*;
import sunsoft.jws.visual.rt.shadow.java.awt.*;

import java.io.IOException;
import java.io.CharArrayWriter ;
import java.net.URL;
import java.util.Date ;
import java.text.SimpleDateFormat ;

import org.w3c.dom.Element;

import com.sun.xml.tree.XmlDocument;
import com.sun.xml.parser.Resolver;


/*
 * CommandeRpc construit le document XML contenant le bon de commande de
 * Textiles et transmet le document au serveur XML de CouponBleu.
 */
public class CommandeRpc
{
    private final static String tagCommandeTextile = "CommandeTextile" ;
    private final static String tagArticle = "Article" ;
    private final static String NameSpace = "editexml:" ;
    private final static int NbArticles = 2 ;
 
    private int Commande = 0 ;
    private final static String tagCommande = "NumeroCommande" ;
    private String DateM = null ;
    private final static String tagDate = "DateMessage" ;
    private String Client = null ;
    private final static String tagClient = "IdentClient" ;
    private String Fournisseur = null ;
    private final static String tagFournisseur = "IdentFournisseur" ;
    private int Tissus[] = { 0, 0 } ;
    private final static String tagTissus = "CodeTissus" ;
    private String Description[] = { null, null } ;
    private final static String tagDescription = "DescriptionArticle" ;
    private int Couleur[] = { 0, 0 } ;
    private final static String tagCouleur = "CodeCouleur" ;
    private int Article[] = { 0, 0 } ;
    private final static String tagRefArticle = "ReferenceCommandeArticle" ;
    private int Dimension[] = { 0, 0 } ;
    private final static String tagDimension = "CodeDimension" ;
    private int Quantite[] = { 0, 0 } ;
    private final static String tagQuantite = "Quantite" ;
    
    // Identification publique du DTD de commande de Textiles
    private final static String IdentEditexmlDtd = "-//EDITEXML//DTD Commande de Textiles//FR" ;

    // Initialisation d'un bon de commande
    public CommandeRpc()
    {
	Fournisseur = new String("7623910956341") ; // Identification unique de CouponBleu
	DateM = new SimpleDateFormat("yyyyMMdd").format(new Date()) ;
    }

    public void setCommande(int value)
	{ Commande = value ; }
    public int getCommande()
	{ return Commande ; }

    public void setDate(String value)
	{ DateM = value ; }
    public String getDate()
	{ return DateM ; }

    public void setClient(String value)
	{ Client = value ; }
    public String getClient()
	{ return Client ; }

    public void setFournisseur(String value)
	{ Fournisseur = value ; }
    public String getFournisseur()
	{ return Fournisseur ; }

    public void setTissus(int article, int value)
	{ Tissus[article] = value ; }
    public int getTissus(int article)
	{ return Tissus[article] ; }

    public void setDescription(int article, String value)
	{ Description[article] = value ; }
    public String getDescription(int article)
	{ return Description[article] ; }

    public void setCouleur(int article, int value)
	{ Couleur[article] = value ; }
    public int getCouleur(int article)
	{ return Couleur[article] ; }

    public void setArticle(int article, int value)
	{ Article[article] = value ; }
    public int getArticle(int article)
	{ return Article[article] ; }

    public void setDimension(int article, int value)
	{ Dimension[article] = value ; }
    public int getDimension(int article)
	{ return Dimension[article] ; }

    public void setQuantite(int article, int value)
	{ Quantite[article] = value ; }
    public int getQuantite(int article)
	{ return Quantite[article] ; }


    /*
     * Envoi d'une commande
     */
    public XmlDocument EmetCommande(CommandeRoot gui, String url)
    {
	XmlRpcClient	client ;
	XmlDocument	doc ;
	Element		root ;
	Element		elem ;
	Element		article ;
	
	try {

	    // On prepare la requete XML
	    client = new XmlRpcClient(new URL (url)) ;

	    // On creer le bon de commande au format XML, il sera valid par le serveur
	    doc = new XmlDocument ();
	    doc.setDoctype (
		IdentEditexmlDtd,			    // dtdPublicId
		"http://www.couponbleu.com/editexml.dtd",   // dtdSystemId
		null);					    // internalSubset

	    root = doc.createElement(NameSpace + tagCommandeTextile);
	    doc.appendChild(root);

	    // On ajoute l'entete de la commande (numro, date, client, fournisseur)
	    elem = doc.createElement(NameSpace + tagCommande);
	    elem.appendChild(doc.createTextNode(new Integer(Commande).toString()));
	    root.appendChild(elem) ;

	    elem = doc.createElement(NameSpace + tagDate);
	    elem.appendChild(doc.createTextNode(DateM));
	    root.appendChild(elem) ;

	    elem = doc.createElement(NameSpace + tagClient);
	    elem.appendChild(doc.createTextNode(Client.toString()));
	    root.appendChild(elem) ;
   
	    elem = doc.createElement(NameSpace + tagFournisseur);
	    elem.appendChild(doc.createTextNode(Fournisseur.toString()));
	    root.appendChild(elem) ;

	    for (int i = 0; i < NbArticles; i ++)
	    {
		if (Tissus[i] == 0)
		    continue ;
		// On ajoute l'article de la commande
		article = doc.createElement(NameSpace + tagArticle);
		root.appendChild(article) ;

		elem = doc.createElement(NameSpace + tagTissus);
		elem.appendChild(doc.createTextNode(new Integer(Tissus[i]).toString()));
		article.appendChild(elem) ;

		elem = doc.createElement(NameSpace + tagDescription);
		elem.appendChild(doc.createTextNode(Description[i]));
		article.appendChild(elem) ;

		elem = doc.createElement(NameSpace + tagCouleur);
		elem.appendChild(doc.createTextNode(new Integer(Couleur[i]).toString()));
		article.appendChild(elem) ;

		elem = doc.createElement(NameSpace + tagRefArticle);
		elem.appendChild(doc.createTextNode(new Integer(Article[i]).toString()));
		article.appendChild(elem) ;

		elem = doc.createElement(NameSpace + tagDimension);
		elem.appendChild(doc.createTextNode(new Integer(Dimension[i]).toString()));
		article.appendChild(elem) ;

		elem = doc.createElement(NameSpace + tagQuantite);
		elem.appendChild(doc.createTextNode(new Integer(Quantite[i]).toString()));
		article.appendChild(elem) ;
	    }

	    // On transmet le document et on retourne la rponse valide
	    afficheCommandeTextile(gui, doc) ;
	    return client.call (doc);
	} catch (Exception e) {
	    e.printStackTrace (System.err);
            return null ;
	}
    }
    
    private void afficheCommandeTextile(CommandeRoot gui, XmlDocument doc)
    {
	try {
	    CharArrayWriter toStr = new CharArrayWriter() ;
	    doc.write (toStr);	
   	    gui.XmlCommande.set("text", toStr.toString());
	} catch (IOException e) {
	}
        gui.CommandeTextile.show();
    }
}
