/*
 * Etude de cas CouponBleu - EmetCommande.java
 */

import java.applet.Applet;
import java.util.StringTokenizer;
import java.net.URL;
import org.w3c.dom.Element;
import com.sun.xml.tree.XmlDocument;
import com.sun.xml.parser.Resolver;
import java.awt.Graphics;
import java.awt.Font;
import java.awt.Color;


public class EmetCommande extends Applet implements Runnable
    {
    private final static String tagCommandeTextile = "CommandeTextile" ;
    private final static String tagArticle = "Article" ;
    private final static String NameSpace = "editexml:" ;
    private final static int MaxArticles = 32 ;
    private int NbArticles ;
 
    private int Commande ;
    private final static String tagCommande = "NumeroCommande" ;
    private String DateM ;
    private final static String tagDate = "DateMessage" ;
    private String Client ;
    private final static String tagClient = "IdentClient" ;
    private String Fournisseur ;
    private final static String tagFournisseur = "IdentFournisseur" ;
    private int Tissus[] = new int[MaxArticles] ;
    private final static String tagTissus = "CodeTissus" ;
    private String Description[] = new String[MaxArticles] ;
    private final static String tagDescription = "DescriptionArticle" ;
    private int Couleur[] = new int[MaxArticles] ;
    private final static String tagCouleur = "CodeCouleur" ;
    private int Article[] = new int[MaxArticles] ;
    private final static String tagRefArticle = "ReferenceCommandeArticle" ;
    private int Dimension[] = new int[MaxArticles] ;
    private final static String tagDimension = "CodeDimension" ;
    private int Quantite[] = new int[MaxArticles] ;
    private final static String tagQuantite = "Quantite" ;
    
    // Identification publique du DTD de commande de Textiles
    private final static String IdentEditexmlDtd = "-//EDITEXML//DTD Commande de Textiles//FR" ;

    private String Statut ;
    private Thread tCommande ;
    private Font font ;

    public void init()
	{
	font = new java.awt.Font("Arial", Font.PLAIN, 36);
	Statut = "" ;

	Commande = Integer.parseInt(getParameter("NumeroCommande")) ;
	DateM = getParameter("DateMessage") ;
	Client = getParameter("IdentClient") ;
	Fournisseur = getParameter("IdentFournisseur") ;

	String sCommande = getParameter("Commande");
	NbArticles = 0 ;
	StringTokenizer stArticles = new StringTokenizer(sCommande, ";") ;
        while (stArticles.hasMoreTokens())
	    {
	    StringTokenizer stData = new StringTokenizer(stArticles.nextToken(), ",") ;
	    
	    Tissus[NbArticles] = Integer.parseInt(stData.nextToken()) ;
	    Description[NbArticles] = stData.nextToken() ;
	    Couleur[NbArticles] = Integer.parseInt(stData.nextToken()) ;
	    Article[NbArticles] = Integer.parseInt(stData.nextToken()) ;
	    Dimension[NbArticles] = Integer.parseInt(stData.nextToken()) ;
	    Quantite[NbArticles] = Integer.parseInt(stData.nextToken()) ;

	    NbArticles ++ ;
	    }
	}

    public void start()
	{
	tCommande = new Thread(this);
	tCommande.start();
	}
	
    public void stop()
	{
	tCommande.stop();
	}
	
    public void run()
	{
        /*
	 * Envoi de la commande au format XML
         */
	Statut = "Construction de la commande XML" ;
	showStatus(Statut) ;
	repaint();
	try {
	    Thread.currentThread().sleep(2000);
	    } catch (InterruptedException e) {
	    }

	XmlRpcClient	client ;
	XmlDocument	doc ;
	Element		root ;
	Element		elem ;
	Element		article ;
	
	try {

	    // On prepare la requete XML
	    client = new XmlRpcClient(
		new URL(
		    getCodeBase().getProtocol() + "://" +
		    getCodeBase().getHost() + ":" +
		    getCodeBase().getPort() +
		    "/servlet/CouponBleu")) ;

	    // On creer le bon de commande au format XML, il sera valid par le serveur
	    doc = new XmlDocument ();
	    doc.setDoctype (
		IdentEditexmlDtd,			    // dtdPublicId
		"http://www.couponbleu.com/editexml.dtd",   // dtdSystemId
		null);					    // internalSubset

	    root = doc.createElement(NameSpace + tagCommandeTextile);
	    doc.appendChild(root);

	    // On ajoute l'entete de la commande (numro, date, client, fournisseur)
	    elem = doc.createElement(NameSpace + tagCommande);
	    elem.appendChild(doc.createTextNode(new Integer(Commande).toString()));
	    root.appendChild(elem) ;

	    elem = doc.createElement(NameSpace + tagDate);
	    elem.appendChild(doc.createTextNode(DateM));
	    root.appendChild(elem) ;

	    elem = doc.createElement(NameSpace + tagClient);
	    elem.appendChild(doc.createTextNode(Client.toString()));
	    root.appendChild(elem) ;
   
	    elem = doc.createElement(NameSpace + tagFournisseur);
	    elem.appendChild(doc.createTextNode(Fournisseur.toString()));
	    root.appendChild(elem) ;

	    for (int i = 0; i < NbArticles; i ++)
	        {
		// On ajoute l'article de la commande
		article = doc.createElement(NameSpace + tagArticle);
		root.appendChild(article) ;

		elem = doc.createElement(NameSpace + tagTissus);
		elem.appendChild(doc.createTextNode(new Integer(Tissus[i]).toString()));
		article.appendChild(elem) ;

		elem = doc.createElement(NameSpace + tagDescription);
		elem.appendChild(doc.createTextNode(Description[i]));
		article.appendChild(elem) ;

		elem = doc.createElement(NameSpace + tagCouleur);
		elem.appendChild(doc.createTextNode(new Integer(Couleur[i]).toString()));
		article.appendChild(elem) ;

		elem = doc.createElement(NameSpace + tagRefArticle);
		elem.appendChild(doc.createTextNode(new Integer(Article[i]).toString()));
		article.appendChild(elem) ;

		elem = doc.createElement(NameSpace + tagDimension);
		elem.appendChild(doc.createTextNode(new Integer(Dimension[i]).toString()));
		article.appendChild(elem) ;

		elem = doc.createElement(NameSpace + tagQuantite);
		elem.appendChild(doc.createTextNode(new Integer(Quantite[i]).toString()));
		article.appendChild(elem) ;
		}

	    // On transmet le document
	    Statut = "Envoi de la commande, " + NbArticles + " article(s)" ;
	    showStatus(Statut) ;
	    repaint();

    	    XmlDocument reponse = client.call (doc);

	    Statut = "Confirmation de commande reue" ;
	    showStatus(Statut) ;
	    repaint();

	    } catch (Exception e) {
		Statut = "Envoi de la commande impossible" ;
		showStatus(Statut) ;
		repaint();
	    }
	}

    public void paint(Graphics gContext)
	{
	gContext.setFont(font);
	gContext.setColor(new Color(0,0,0x40));
        gContext.drawString(Statut, 10, 60);
	}
    }
