/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.upload;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.upload.BufferedMultipartInputStream;
import org.apache.struts.upload.MultipartElement;

public class MultipartIterator {
    public static int MAX_LINE_SIZE = 4096;
    protected HttpServletRequest request;
    protected BufferedMultipartInputStream inputStream;
    protected String boundary;
    protected byte[] boundaryBytes;
    protected boolean contentRead = false;
    protected long maxSize = -1L;
    protected long totalLength = 0L;
    protected int contentLength;
    protected int diskBufferSize = 20480;
    protected int bufferSize = 4096;
    protected String tempDir;

    public MultipartIterator(HttpServletRequest request) throws ServletException {
        this(request, -1);
    }

    public MultipartIterator(HttpServletRequest request, int bufferSize) throws ServletException {
        this(request, bufferSize, -1L);
    }

    public MultipartIterator(HttpServletRequest request, int bufferSize, long maxSize) throws ServletException {
        this(request, bufferSize, maxSize, null);
    }

    public MultipartIterator(HttpServletRequest request, int bufferSize, long maxSize, String tempDir) throws ServletException {
        this.request = request;
        this.maxSize = maxSize;
        if (bufferSize > -1) {
            this.bufferSize = bufferSize;
        }
        if (tempDir != null) {
            this.tempDir = tempDir;
        } else {
            tempDir = System.getProperty("java.io.tmpdir");
        }
        this.parseRequest();
    }

    public MultipartElement getNextElement() throws ServletException, UnsupportedEncodingException {
        String disposition = this.readLine();
        if (disposition != null && disposition.startsWith("Content-Disposition")) {
            boolean isFile;
            String name = MultipartIterator.parseDispositionName(disposition);
            String filename = MultipartIterator.parseDispositionFilename(disposition);
            String contentType = null;
            boolean bl = isFile = filename != null;
            if (isFile) {
                int colonIndex = (filename = new File(filename).getName()).indexOf(":");
                if (colonIndex == -1) {
                    colonIndex = filename.indexOf("\\\\");
                }
                int slashIndex = filename.lastIndexOf("\\");
                if (colonIndex > -1 && slashIndex > -1) {
                    filename = filename.substring(slashIndex + 1, filename.length());
                }
                contentType = this.readLine();
                contentType = MultipartIterator.parseContentType(contentType);
            }
            if (!isFile || contentType != null) {
                this.readLine();
            }
            MultipartElement element = null;
            if (isFile) {
                try {
                    File elementFile = this.createLocalFile();
                    element = new MultipartElement(name, filename, contentType, elementFile);
                }
                catch (IOException ioe) {
                    throw new ServletException("IOException while reading file element: " + ioe.getMessage(), (Throwable)ioe);
                }
            } else {
                StringBuffer textData = new StringBuffer();
                String line = this.readLine();
                while (line != null && !line.startsWith(this.boundary)) {
                    textData.append(line);
                    line = this.readLine();
                }
                if (textData.length() > 0 && textData.charAt(textData.length() - 1) == '\r') {
                    textData.setLength(textData.length() - 1);
                }
                element = new MultipartElement(name, textData.toString());
            }
            return element;
        }
        if (this.inputStream.markSupported()) {
            try {
                this.inputStream.reset();
            }
            catch (IOException ioe) {
                throw new ServletException("IOException while resetting input stream: " + ioe.getMessage());
            }
        }
        return null;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    protected void parseRequest() throws ServletException {
        this.contentLength = this.request.getContentLength();
        this.boundary = MultipartIterator.parseBoundary(this.request.getContentType());
        this.boundaryBytes = this.boundary.getBytes();
        try {
            this.inputStream = new BufferedMultipartInputStream((InputStream)this.request.getInputStream(), this.bufferSize, this.contentLength, this.maxSize);
            if (this.inputStream.markSupported()) {
                this.inputStream.mark(this.contentLength + 1);
            }
        }
        catch (IOException ioe) {
            throw new ServletException("Problem while reading request: " + ioe.getMessage(), (Throwable)ioe);
        }
        if (this.boundary == null || this.boundary.length() < 1) {
            this.boundary = MultipartIterator.parseBoundary(this.request.getHeader("Content-type"));
        }
        if (this.boundary == null || this.boundary.length() < 1) {
            throw new ServletException("MultipartIterator: cannot retrieve boundary for multipart request");
        }
        try {
            String firstLine = this.readLine();
            if (firstLine == null) {
                throw new ServletException("MultipartIterator: no multipart request data sent");
            }
            if (!firstLine.startsWith(this.boundary)) {
                throw new ServletException("MultipartIterator: invalid multipart request data, doesn't start with boundary");
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw new ServletException("MultipartIterator: encoding \"ISO-8859-1\" not supported");
        }
    }

    public static String parseBoundary(String contentType) {
        if (contentType.lastIndexOf("boundary=") != -1) {
            String _boundary = "--" + contentType.substring(contentType.lastIndexOf("boundary=") + 9);
            if (_boundary.endsWith("\n")) {
                return _boundary.substring(0, _boundary.length() - 1);
            }
            return _boundary;
        }
        return null;
    }

    public static String parseContentType(String contentTypeString) {
        int nameIndex = contentTypeString.indexOf("Content-Type: ");
        if (nameIndex != -1) {
            int endLineIndex = contentTypeString.indexOf("\n");
            if (endLineIndex == -1) {
                endLineIndex = contentTypeString.length() - 1;
            }
            return contentTypeString.substring(nameIndex + 14, endLineIndex);
        }
        return null;
    }

    public static String parseDispositionName(String dispositionString) {
        return MultipartIterator.parseForAttribute("name", dispositionString);
    }

    public static String parseDispositionFilename(String dispositionString) {
        return MultipartIterator.parseForAttribute("filename", dispositionString);
    }

    public static String parseForAttribute(String attribute, String parseString) {
        int nameIndex = parseString.indexOf(attribute + "=\"");
        if (nameIndex != -1) {
            int endQuoteIndex = parseString.indexOf("\"", nameIndex + attribute.length() + 3);
            if (endQuoteIndex != -1) {
                return parseString.substring(nameIndex + attribute.length() + 2, endQuoteIndex);
            }
            return "";
        }
        return null;
    }

    protected String readLine() throws ServletException, UnsupportedEncodingException {
        int bytesRead;
        byte[] bufferByte = new byte[this.bufferSize];
        if (this.totalLength >= (long)this.contentLength) {
            return null;
        }
        try {
            bytesRead = this.inputStream.readLine(bufferByte, 0, this.bufferSize);
        }
        catch (IOException ioe) {
            throw new ServletException("IOException while reading multipart request: " + ioe.getMessage());
        }
        if (bytesRead == -1) {
            return null;
        }
        this.totalLength += (long)bytesRead;
        return new String(bufferByte, 0, bytesRead, "ISO-8859-1");
    }

    protected File createLocalFile() throws IOException {
        File tempFile = File.createTempFile("strts", null, new File(this.tempDir));
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(tempFile), this.diskBufferSize);
        byte[] lineBuffer = new byte[MAX_LINE_SIZE];
        int bytesRead = this.inputStream.readLine(lineBuffer, 0, MAX_LINE_SIZE);
        boolean cutCarriage = false;
        boolean cutNewline = false;
        try {
            while (bytesRead != -1 && !MultipartIterator.equals(lineBuffer, 0, this.boundaryBytes.length, this.boundaryBytes)) {
                if (cutCarriage) {
                    fos.write(13);
                }
                if (cutNewline) {
                    fos.write(10);
                }
                cutCarriage = false;
                if (bytesRead > 0 && lineBuffer[bytesRead - 1] == 13) {
                    --bytesRead;
                    cutCarriage = true;
                }
                cutNewline = true;
                fos.write(lineBuffer, 0, bytesRead);
                bytesRead = this.inputStream.readLine(lineBuffer, 0, MAX_LINE_SIZE);
            }
        }
        catch (IOException ioe) {
            fos.close();
            tempFile.delete();
            throw ioe;
        }
        fos.flush();
        fos.close();
        return tempFile;
    }

    public static boolean equals(byte[] comp, int offset, int length, byte[] source) {
        if (length != source.length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (comp[offset + i] != source[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

