<%-- fruitPrice.jsp --%>
<%@ page import="java.util.*" %>
<%
String selectedFruit = request.getParameter("selectedFruit");
if (selectedFruit == null) {
   selectedFruit = "pommes";
}
%>
<jsp:useBean id="fruitList" class ="FruitMap">
<%
fruitList.put("pommes","2.99");
fruitList.put("oranges","2.59");
fruitList.put("prunes","3.99");
fruitList.put("pamplemousses","5.99");
fruitList.put("figues","2.99");
fruitList.put("mangues","4.99");
fruitList.put("poires","2.99");
%>
</jsp:useBean>

<html>
<head>
   <title>Calcul de prix total d'un fruit</title>
   <SCRIPT language="JavaScript">
      price = parseFloat(<%=fruitList.get(selectedFruit)%>);

      function submitForm() {
         document.fruitForm.submit();
      }

      function roundNumber(number, digits){
         return Math.round(number*Math.pow(10,digits))/Math.pow(10,digits);
         }
		
      function calcTotal() {
         document.fruitForm.total.value = roundNumber(price*parseInt(document.fruitForm.quantity.value),2);
      }

   </SCRIPT>
</head>

<body onload="calcTotal()">
<h1>Calcul de prix d'un fruit (fruitPrice.jsp)</h1>
Pour changer de fruit, slectionnez-le dans la liste.<br>
Pour faire calculer le total, saisissez la quantit en kg puis frappez la touche TAB du clavier.

<form method="POST" name="fruitForm">
<table border="1" cellpadding="3">
   <tr align="left" valign="top">
      <th bgcolor="#c0c0c0">Varit de fruit</th>
      <td>
         <select name="selectedFruit" onchange="submitForm();">
            <% 
            Iterator fruitNames = fruitList.keySet().iterator();
            while (fruitNames.hasNext()) {
               String newFruit = (String)fruitNames.next();
               out.print("<option value='" + newFruit + "' ");
               if (selectedFruit.equals(newFruit)){
                  out.print(" Selected ");
               }
               out.print(">" + newFruit);
            }
            %>
         </select>
      </td>
   </tr>
   <tr>
      <th bgcolor="#c0c0c0"">Prix (Euros):</th>
      <td><input type="text" size="15" name="price" disabled readonly value="<%= fruitList.get(selectedFruit) %>"</td>
   </tr>
   <tr>
      <th bgcolor="#c0c0c0">Poids:</th>
      <td><input type="text" size="15"  name="quantity" value="1" onchange="calcTotal();"></td>
   </tr>
   <tr>
      <th bgcolor="#c0c0c0">Total (Euros): </th>
      <td><input type="text" size="15"  name="total" disabled readonly value="" ></td>
   </tr>
</table>
</form>
</body>
</html>
