import java.util.*;

public class Cart {
  private Hashtable ht;

  public Cart() {
    ht = new Hashtable();
    }

    public void addItemToCart(CartItem item){
      String name = item.getName();
      int quantity = item.getQuantity();
      double price = item.getPrice();
      double totalPrice = item.getTotalPrice();
	
      CartItem oldItem = (CartItem)ht.get(name);
      if (oldItem != null){
        int q = oldItem.getQuantity();
        int newQuantity = q + quantity;
        item.setQuantity(newQuantity);
        item.setTotalPrice(price, newQuantity);
      }
      ht.put(name, item);
    }

    public void setNewItemQuantity(CartItem item){
      String name = item.getName();
      int quantity = item.getQuantity();
      if (quantity != 0 ) {
        ht.put(name, item);
      } else {
        ht.remove(name);
      }
  }

  public CartItem getCartItem(String name){
    CartItem item = (CartItem)ht.get(name);
    return item;
  }

  public boolean itemExists(CartItem item){
    String name = item.getName();
    item = getCartItem(name);
    if (item == null){
      return false;
    }else{
      return true;
    }
  }
	
  public Hashtable getCartList(){
    return this.ht;
  }

}
