<%-- cart.jsp --%>
<%@ page import="java.util.*,java.text.DecimalFormat" %>
<html>
<head>
  <title>Panier de commande (cart.jsp)</title>
  <SCRIPT language="JavaScript">
  function submitForm() {
    document.cartForm.submit();
  }

  function setNewQuantity(quantity) {
    document.cartForm.fruit.value=quantity;
  }

  function setFruit(fruit) {
    document.cartForm.fruit.value=fruit;
  }
  </SCRIPT>
</head>

<body>

<%
// Dfinition des variables de la page
FruitMap fruitList = new FruitMap();
CartItem item = new CartItem();
String submit = request.getParameter("Submit").trim();
String fruit = "";
Double price;
double p, totalPrice;
int quantity, existingQuantity;
Integer iQuantity, iExistingQuantity;
DecimalFormat df = new DecimalFormat ( "#,##0.00 euros" );

// Rcupre une instance de Cart;
// Cre une session cart si ncessaire
Cart cart = (Cart)session.getValue("cart");
if (cart == null) {
  cart = new Cart();
  session.setAttribute("cart", cart);
}

// Si des fruits ont t commands, affectation aux variables
// des valeurs du formulaire
if (submit.equals("Ajouter au panier")){
// Dfinition des paramtres de l'objet CartItem  ajouter au panier
  fruit = request.getParameter("selectedFruit");
  price = new Double((String)fruitList.get(fruit));
  p = price.doubleValue();
  quantity = 1;
  item = new CartItem(fruit, p, quantity);
  cart.addItemToCart(item);
} else {
  if(submit.equals("Recalculer les prix")){
    for (Enumeration e = request.getParameterNames() ; e.hasMoreElements() ;) {
      fruit = (String)e.nextElement();
      item = cart.getCartItem(fruit);
      if (item != null) {
        iQuantity = new Integer(request.getParameter(fruit));
        quantity = iQuantity.intValue();
        p = item.getPrice();
        if (item != null) {
          item.setQuantity(quantity);
          double newPrice = item.getPrice();
          item.setTotalPrice(p, quantity);
          cart.setNewItemQuantity(item);
        }
      }
    }
  }
}
%>
<a href="fruitSale.jsp">Ajouter d'autres fruits.</a><br>
<form method="post" name="cartForm">
<table border="1">
  <tr>
    <th bgcolor="#c0c0c0">Fruit</th>
    <th bgcolor="#c0c0c0">Prix au kilo</th>
    <th bgcolor="#c0c0c0">Quantit</th>
    <th bgcolor="#c0c0c0">Prix total</th>
  </tr>

<%
/** Rcupre la table HashTable du panier qui contient 
tous les articles. Balaye la liste pour afficher les 
valeurs dans un tableau **/

Hashtable cartList = cart.getCartList();
Iterator i = cartList.keySet().iterator();
while (i.hasNext()) {
  fruit = (String) i.next();
  item = (CartItem) cartList.get(fruit);
  p = item.getPrice();
  quantity = item.getQuantity();
  totalPrice = item.getTotalPrice();
  out.println("<tr><td>");
  out.println(fruit + "</td><td>");
  out.println(df.format ( p ) + "</td><th>");
  out.println("<input type=\"text\" size=\"1\" name=\"" + fruit + "\" value=\"" + quantity + "\" ></th><td>");
  out.println(df.format ( totalPrice )+ "</td></tr>");
}
%>
<tr>
  <th colspan="4"><input type="Submit" name="Submit" value="Recalculer les prix"></th>
</tr>
</table>
</form>
</body>
</html>
