/* Generated by Together */

package chstruts.actions;

// Imports de l'application
import chstruts.forms.LoginForm;

// Imports de Struts
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForward;  
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionForm;

// Imports de servlets
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

// Imports Java
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LoginAction extends Action
{
    SimpleDateFormat _sdf = new SimpleDateFormat ( "MM/dd/yy HH:mm:ss" );

    public ActionForward perform( ActionMapping mapping, 
                                  ActionForm form, 
                                  HttpServletRequest request,
                                  HttpServletResponse response) throws IOException, ServletException
    {
        String thisMethod = "perform() ";
        debug ( thisMethod, "in" );
        debug ( thisMethod, "form = " + form );

        LoginForm           loginForm   = (LoginForm) form;
        String              action      = loginForm.getAction();
        String              af          = null;
        
        try
        {
            debug ( thisMethod, "action=" + action );

            if ( action == null )
            {
                af = handleQuery ( loginForm );
            }
            else if ( action.equals ( "login" ) )
            {
                af = handlePage ( loginForm );
            }

            debug ( thisMethod, "done" );
            return mapping.findForward ( af );
        }
        catch (Exception e)
        {
            servlet.log("Action Exception", e);
            return (mapping.findForward("login"));
        }
    }
        
    private String handleQuery ( LoginForm form ) 
    {
        String thisMethod = "handleQuery() ";
        debug ( thisMethod, "in" );
        
        form.setTimeStamp ( _sdf.format ( new Date() ) );
        
        String actionForward = "login_ready"; 
        debug ( thisMethod, "done" );
        
        return ( actionForward );
    }
    
    private String handlePage ( LoginForm form ) 
    {
        String thisMethod = "handlePage() ";
        debug ( thisMethod, "in" );

        String actionForward;
        String uid      = form.getUserName ();
        String pwd      = form.getPassword ();
        int    tryCount = form.getTryCount ();
        
        debug ( thisMethod, "uid = " + uid + " pwd = " + pwd + " tryCount = " + tryCount );
        
        // Code here to lookup this uid pwd combo
        if ( tryCount < 3 )
        {
            form.setTryCount ( tryCount + 1 );
            actionForward = "login_failure"; 
        }
        else
        {
            actionForward = "login_complete"; 
        }
        
        // Have to update the timestamp
        form.setTimeStamp ( _sdf.format ( new Date() ) );
        
        debug ( thisMethod, "done returning: " + actionForward );
        
        return ( actionForward );
    }
    
    private void debug ( String method, String msg )
    {
        System.out.println ( "LoginAction." + method + ":" + msg );
    }
}
