#! /usr/bin/env python
# -*- coding: Latin-1 -*-

# Le fichier de dpart est un fichier <texte> dont chaque ligne contient
# un nombre rel (encod sous la forme d'une chane de caractres)    

from math import pi

def caractSphere(d):
    "renvoie les caractristiques d'une sphre de diamtre d"
    d = float(d)        # conversion de l'argument (=chane) en rel
    r = d/2             # rayon
    ss = pi*r**2        # surface de section
    se = 4*pi*r**2      # surface extrieure
    v = 4./3*pi*r**3    # volume (! la premire division doit tre relle !)
    # Le marqueur de conversion %8.2f utilis ci-dessous formate le nombre
    # affich de manire  occuper 8 caractres au total, en arrondissant
    # de manire  conserver deux chiffres aprs la virgule : 
    ch = "Diam. %6.2f cm Section = %8.2f cm " % (d, ss)
    ch = ch +"Surf. = %8.2f cm. Vol. = %9.2f cm" % (se, v)
    return ch

fiSource = raw_input("Nom du fichier  traiter : ")
fiDest = raw_input("Nom du fichier destinataire : ")
fs = open(fiSource, 'r')
fd = open(fiDest, 'w')
while 1:
    diam = fs.readline()
    if diam == "" or diam == "\n":
        break
    fd.write(caractSphere(diam) + "\n")         # enregistrement
fd.close()
fs.close()
