Imports System.Diagnostics

Public Class Tableaux
	Inherits System.Web.UI.Page
	Protected WithEvents txtNombre As System.Web.UI.WebControls.TextBox
	Protected WithEvents chkCubes As System.Web.UI.WebControls.CheckBox
	Protected WithEvents btnOK As System.Web.UI.WebControls.Button
	Protected WithEvents plh As System.Web.UI.WebControls.PlaceHolder
	Protected WithEvents chkTableauDyn As System.Web.UI.WebControls.CheckBox
	Protected WithEvents tblCarres As System.Web.UI.WebControls.Table

#Region " Code gnr par le Concepteur Web Form "

	'Cet appel est requis par le Concepteur Web Form.
	<System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()

	End Sub

	Private Sub Page_Init(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Init
		'CODEGEN: cet appel de mthode est requis par le Concepteur Web Form
		'Ne le modifiez pas en utilisant l'diteur de code.
		InitializeComponent()
	End Sub

#End Region

	' Affiche la liste des carrs et cubes
	Private Sub btnOK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnOK.Click
		Dim i As Integer
		' Supprime les lignes sous le titre
		Do While tblCarres.Rows.Count > 1
			tblCarres.Rows.RemoveAt(1)
		Loop

		' Indicateur de calcul des cubes
		Dim fCubes As Boolean = chkCubes.Checked

		' Ajuste l'en-tte selon l'indicateur de calcule de cubes
		tblCarres.Rows(0).Cells(2).Visible = fCubes

		' Ajoute les nouvelles lignes
		Dim nb As Integer = Val(txtNombre.Text)
		For i = 1 To nb
			' Ligne
			Dim r As TableRow
			r = New TableRow()
			' Sa couleur de fond
			r.BackColor = Color.Yellow

			' Cellules
			Dim c As TableCell

			' Le nombre
			c = New TableCell()
			c.HorizontalAlign = HorizontalAlign.Center
			c.Text = i.ToString
			' L'ajoute  la ligne
			r.Cells.Add(c)

			' Le carr
			c = New TableCell()
			c.HorizontalAlign = HorizontalAlign.Center
			c.Text = (i * i).ToString
			' En caractres gras
			c.Font.Bold = True
			' L'ajoute  la ligne
			r.Cells.Add(c)

			' Eventuellement le cube
			If fCubes Then
				c = New TableCell()
				c.HorizontalAlign = HorizontalAlign.Center
				c.Text = (i ^ 3).ToString
				' En caractres gras
				c.Font.Bold = True
				' et en bleu
				c.ForeColor = Color.Blue
				' L'ajoute  la ligne
				r.Cells.Add(c)
			End If

			' Ajoute la ligne au tableau
			tblCarres.Rows.Add(r)
		Next

		' Le tableau n'est affich que si le nombre de ligne est non nul
		tblCarres.Visible = nb > 0
	End Sub

	' Affiche un tableau dynamique
	Private Sub Page_PreRender(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.PreRender
		If chkTableauDyn.Checked Then
			' Dfinit le tableau
			Dim tbl As New Table()
			tbl.GridLines = GridLines.Both
			' Ajoute une ligne
			Dim r As TableRow
			r = New TableRow()
			tbl.Rows.Add(r)
			' Ajoute une cellule
			Dim c As TableCell
			c = New TableCell()
			c.Text = "Voici une liste"
			r.Cells.Add(c)
			' Ajoute une seconde cellule avec un contrle
			c = New TableCell()
			' Une liste
			Dim lst As New ListBox()
			Dim items() As ListItem = {New ListItem("AAA"), New ListItem("BBB"), New ListItem("CCC"), New ListItem("DDD")}
			lst.Items.AddRange(items)
			lst.Rows = 3
			lst.ID = "lst"
			c.Controls.Add(lst)
			r.Cells.Add(c)

			' Ajoute le tableau dans la page
			plh.Controls.Add(tbl)
		End If
	End Sub

End Class
