Imports System.ComponentModel
Imports System.Web.UI
Imports System.Web
Imports System.Web.UI.WebControls
Imports System.Drawing
Imports System.Drawing.Imaging
Imports System.Xml

'---- La classe du contrle Camembert
<DefaultProperty("Items"), _
ToolboxData("<{0}:Camembert runat=server></{0}:Camembert>")> _
Public Class Camembert
	Inherits System.Web.UI.WebControls.WebControl

	Private _PageName As String = "c.camembert"
	Private _Text As String
	Private _Width As New Unit(200)
	Private _Height As New Unit(200)
	Private _Items As New CamembertItemCollection

	'---- Proprit PageName
	<Bindable(True), DefaultValue("c.camembert")> _
	Public Property PageName() As String
		Get
			Return _PageName
		End Get

		Set(ByVal Value As String)
			_PageName = Value
		End Set
	End Property

	'---- Proprit Text
	<Bindable(True), DefaultValue("")> _
	Public Property Text() As String
		Get
			Return _Text
		End Get
		Set(ByVal Value As String)
			_Text = Value
		End Set
	End Property
	'---- Proprit Width
	<Bindable(True), DefaultValue(200)> _
	Public Overrides Property Width() As Unit
		Get
			Return _Width
		End Get

		Set(ByVal Value As Unit)
			_Width = Value
		End Set
	End Property

	'---- Proprit Height
	<Bindable(True), DefaultValue(200)> _
	Public Overrides Property Height() As Unit
		Get
			Return _Height
		End Get

		Set(ByVal Value As Unit)
			_Height = Value
		End Set
	End Property

	'---- Proprit Items
	<PersistenceMode(PersistenceMode.InnerProperty), _
	Description("La collection des lments du camembert")> _
	Public ReadOnly Property Items() As CamembertItemCollection
		Get
			Return _Items
		End Get
	End Property

	Protected Overrides Sub Render(ByVal output As System.Web.UI.HtmlTextWriter)
		' Construit l'url
		Dim url As String = String.Format("{0}?w={1}&h={2}&bc={3}&n={4}", _PageName, _Width.Value, _Height.Value, BackColor.ToArgb, Items.Count)
		' Ajoute les valeurs-couleurs
		Dim i As Integer = 0
		For Each itm As CamembertItem In Items
			i += 1
			url &= String.Format("&v{0}={1}&c{0}={2}", i, itm.Value, itm.Color.ToArgb)
		Next

		With output
			.AddAttribute(HtmlTextWriterAttribute.Alt, Text)
			.AddAttribute(HtmlTextWriterAttribute.Src, url)
			.RenderBeginTag(HtmlTextWriterTag.Img)
			.RenderEndTag()
		End With
	End Sub

	'---- Enregistre les donnes de persistance
	Protected Overrides Sub LoadViewState(ByVal savedState As Object)
		' Appelle la mthode de la classe de base
		MyBase.LoadViewState(savedState)

		' Avons-nous des lments ?
		If Not ViewState("Items") Is Nothing Then
			Dim Doc As New XmlDataDocument
			Doc.LoadXml(ViewState("Items"))

			' Vide la liste
			_Items.Clear()

			' Ajoute tous les lments
			For Each Elem As XmlElement In Doc.ChildNodes(0).ChildNodes
				Dim ci As New CamembertItem
				ci.Value = Elem.GetAttribute("Value")
				If Elem.GetAttribute("Color") <> "0" Then ci.Color = Color.FromArgb(Elem.GetAttribute("Color"))
				_Items.Add(ci)
			Next
		End If
	End Sub

	'---- Charge les donnes de persistance
	Protected Overrides Function SaveViewState() As Object
		' Cre un document XML avec les items
		Dim Doc As New XmlDataDocument
		Dim Elem As XmlElement = Doc.CreateElement("Items")
		For Each Item As CamembertItem In _Items
			Dim ItemElem As XmlElement = Doc.CreateElement("Item")
			ItemElem.SetAttribute("Value", Item.Value)
			ItemElem.SetAttribute("Color", Item.Color.ToArgb)
			Elem.AppendChild(ItemElem)
		Next

		' Ecrit dans le viewstate
		ViewState("Items") = Elem.OuterXml

		' Appelle la mthode de la classe de base
		Return MyBase.SaveViewState()
	End Function
End Class

'------------ Classe dfinissant un lment du camembert
Public Class CamembertItem

	Private _Value As Single
	Private _Color As Color

	'---- Constructeurs
	Public Sub New()
		_Value = 0
		_Color = Color.Gray
	End Sub

	Public Sub New(ByVal Valeur As Single, ByVal Couleur As Color)
		_Value = Valeur
		_Color = Couleur
	End Sub

	Public Sub New(ByVal Valeur As Single)
		_Value = Valeur
		_Color = Color.FromArgb(Rnd() * 255, Rnd() * 255, Rnd() * 255)
	End Sub

	'---- Proprit Value
	Public Property Value() As Single
		Get
			Return _Value
		End Get
		Set(ByVal Value As Single)
			_Value = Value
		End Set
	End Property

	'---- Proprit Color
	Public Property Color() As Color
		Get
			Return _Color
		End Get
		Set(ByVal Value As Color)
			_Color = Value
		End Set
	End Property

End Class

'------------ Classe dfinissant une collection d'lments de camembert
Public Class CamembertItemCollection
	Inherits System.Collections.CollectionBase

	' Proprit Item
	Default Public ReadOnly Property Item(ByVal index As Integer) As CamembertItem
		Get
			Return CType(list.Item(index), CamembertItem)
		End Get
	End Property

	'---- Mthode Add
	Public Overloads Function Add(ByVal value As CamembertItem) As Integer
		Return list.Add(value)
	End Function

End Class

'------------ Le HttpHandler
Public Class CamembertHandler
	Implements IHttpHandler

	Public ReadOnly Property IsReusable() As Boolean Implements System.Web.IHttpHandler.IsReusable
		Get
			Return True
		End Get
	End Property

	Public Sub ProcessRequest(ByVal context As System.Web.HttpContext) Implements System.Web.IHttpHandler.ProcessRequest

		' Rcupre les donnes du query string
		Dim Largeur As Integer = Convert.ToInt32(context.Request("w"))
		Dim Hauteur As Integer = Convert.ToInt32(context.Request("h"))
		Dim CouleurFond As Color = Color.FromArgb(Convert.ToInt32(context.Request("bc")))
		' Nombre de valeurs
		Dim n As Integer = Convert.ToInt32(context.Request("n"))
		' Tableaux des valeurs et couleurs
		Dim Valeurs(n - 1) As Decimal
		Dim Couleurs(n - 1) As Color

		For i As Integer = 1 To n
			Valeurs(i - 1) = Convert.ToDecimal(context.Request("v" & i))
			Couleurs(i - 1) = Color.FromArgb(Convert.ToInt32(context.Request("c" & i)))
		Next

		' Construit la bitmap
		Dim Bitmap As New Bitmap(Largeur, Hauteur)
		Dim g As Graphics = Graphics.FromImage(Bitmap)
		' Dessine le camembert
		DessineCamembert(g, CouleurFond, Valeurs, Couleurs, Largeur, Hauteur)

		' L'enregistre dans la rponse
		context.Response.ContentType = "image/gif"
		Bitmap.Save(context.Response.OutputStream, ImageFormat.Gif)

		' Nettoie
		Bitmap.Dispose()
		g.Dispose()

	End Sub

	Private Sub DessineCamembert(ByVal g As Graphics, ByVal Fond As Color, ByVal Valeurs() As Decimal, ByVal Couleurs() As Color, ByVal Largeur As Integer, ByVal Hauteur As Integer)

		' Remplit le rectangle
		Dim br As New SolidBrush(Fond)
		g.FillRectangle(br, 0, 0, Largeur, Hauteur)
		br.Dispose()

		' Calcule le total
		Dim Total As Decimal
		For Each Valeur As Decimal In Valeurs
			Total += Valeur
		Next

		' Garde-fou
		If Total = 0 Then Exit Sub

		' Dessine les portions (de camenbert, bien sr !)
		Dim Debut As Single
		Dim Fin As Single
		Dim Courant As Single
		For i As Integer = 0 To Valeurs.Length - 1
			Courant += Valeurs(i)
			Debut = Fin
			Fin = (Courant / Total) * 360.0
			br = New SolidBrush(Couleurs(i))
			g.FillPie(br, 0.0F, 0.0F, Largeur, Hauteur, Debut, Fin - Debut)
			br.Dispose()
		Next
	End Sub

End Class