Imports System.ComponentModel
Imports System.Web.UI
Imports System.Drawing

'---- La classe du contrle Compteur
<DefaultProperty("Value"), _
ToolboxData("<{0}:Compteur runat=server></{0}:Compteur>")> _
Public Class Compteur
	Inherits System.Web.UI.WebControls.WebControl

	Dim _Value As String = "0"

	<Bindable(True), Category("Appearance"), DefaultValue(0), Description("Valeur du compteur")> _
	Property Value() As String
		Get
			Return _Value
		End Get

		Set(ByVal Value As String)
			_Value = Value
		End Set
	End Property

	Protected Overrides Sub Render(ByVal output As System.Web.UI.HtmlTextWriter)
		With output
			' Prpare les attributs de style
			If Not BorderWidth.IsEmpty Then _
			 .AddStyleAttribute(HtmlTextWriterStyle.BorderWidth, BorderWidth.ToString)
			If Not BorderStyle = WebControls.BorderStyle.NotSet Then _
			 .AddStyleAttribute(HtmlTextWriterStyle.BorderStyle, BorderStyle.ToString)
			If Not BorderColor.Equals(Color.Empty) Then _
			 .AddStyleAttribute(HtmlTextWriterStyle.BorderColor, Global.GetColorString(BorderColor))
			If Not BorderColor.Equals(Color.Empty) Then _
			 .AddStyleAttribute(HtmlTextWriterStyle.Color, Global.GetColorString(ForeColor))
			If Not BorderColor.Equals(Color.Empty) Then _
			 .AddStyleAttribute(HtmlTextWriterStyle.BackgroundColor, Global.GetColorString(BackColor))
			If Not Font.Name = "" Then _
			 .AddStyleAttribute(HtmlTextWriterStyle.FontFamily, Font.Name)
			If Not BorderWidth.IsEmpty Then _
			 .AddStyleAttribute(HtmlTextWriterStyle.FontSize, Font.Size.ToString)
			If Font.Bold Then _
			 .AddStyleAttribute(HtmlTextWriterStyle.FontWeight, "bold")
			If Font.Italic Then _
			 .AddStyleAttribute(HtmlTextWriterStyle.FontStyle, "italic")

			' Ecrit la balise span avec les attributs prpars
			.RenderBeginTag("span")

			' Ajoute la valeur
			.Write(_Value)

			' Termine la balise span
			.RenderEndTag()
		End With
	End Sub

End Class
