Imports System.ComponentModel
Imports System.Web.UI
Imports System.Web.UI.WebControls
Imports System.IO
Imports System.Drawing

<DefaultProperty("Items"), _
DefaultEvent("TextChanged"), _
ToolboxData("<{0}:DropDownPlus runat=server></{0}:DropDownPlus>")> _
Public Class DropDownPlus
	Inherits System.Web.UI.WebControls.WebControl
	Implements IPostBackDataHandler

	'---- Donnes prives
	Private _Items As New ListItemCollection
	Private _AutoPostBack As Boolean = False

	'---- Constructeur
	Public Sub New()
		TextBackColor = SystemColors.Window
		ListBackColor = SystemColors.Window
		TextForeColor = SystemColors.WindowText
		ListForeColor = SystemColors.WindowText
		ListLines = 4
	End Sub

	'---- L'vnement
	Public Event TextChanged As EventHandler

	Protected Overridable Sub OnTextChanged(ByVal e As EventArgs)
		RaiseEvent TextChanged(Me, e)
	End Sub

	'---- Proprit Text
	<Bindable(True), _
	Category("Appearance"), _
	DefaultValue(""), _
	Description("Le texte slectionn")> _
	Property [Text]() As String
		Get
			Return CType(ViewState("Text"), String)
		End Get

		Set(ByVal Value As String)
			ViewState("Text") = Value
		End Set
	End Property

	'---- Proprit Items
	<Bindable(True), _
	PersistenceMode(PersistenceMode.InnerProperty), _
	Description("La collection des lments de la liste")> _
	Public ReadOnly Property Items() As ListItemCollection
		Get
			Return _Items
		End Get
	End Property

	'---- Proprit TextBackColor
	<Bindable(True), _
	Category("Appearance"), _
	DefaultValue(GetType(Color), "window"), _
	Description("Couleur de fond du texte")> _
	  Public Property TextBackColor() As Color
		Get
			Return CType(ViewState("TextBackColor"), Color)
		End Get
		Set(ByVal Value As Color)
			ViewState("TextBackColor") = Value
		End Set
	End Property

	'---- Proprit ListBackColor
	<Bindable(True), _
	Category("Appearance"), _
	DefaultValue(GetType(Color), "window"), _
	Description("Couleur de fond de la liste")> _
	  Public Property ListBackColor() As Color
		Get
			Return CType(ViewState("ListBackColor"), Color)
		End Get
		Set(ByVal Value As Color)
			ViewState("ListBackColor") = Value
		End Set
	End Property

	'---- Proprit TextForeColor
	<Bindable(True), _
	Category("Appearance"), _
	DefaultValue(GetType(Color), "windowtext"), _
	Description("Couleur du texte")> _
	  Public Property TextForeColor() As Color
		Get
			Return CType(ViewState("TextForeColor"), Color)
		End Get
		Set(ByVal Value As Color)
			ViewState("TextForeColor") = Value
		End Set
	End Property

	'---- Proprit ListForeColor
	<Bindable(True), _
	Category("Appearance"), _
	DefaultValue(GetType(Color), "windowtext"), _
	Description("Couleur de la liste")> _
	  Public Property ListForeColor() As Color
		Get
			Return CType(ViewState("ListForeColor"), Color)
		End Get
		Set(ByVal Value As Color)
			ViewState("ListForeColor") = Value
		End Set
	End Property

	'---- Proprit ListLines
	<Bindable(True), _
	Category("Appearance"), _
	DefaultValue(4), _
	  Description("Nombre de lignes de la liste")> _
	  Public Property ListLines() As Integer
		Get
			Return CType(ViewState("ListLines"), Integer)
		End Get
		Set(ByVal Value As Integer)
			ViewState("ListLines") = Value
		End Set
	End Property

	'---- Proprit AutoPostBack
	<Bindable(True), _
	DefaultValue(False), _
	Description("Indique si un changement dans le texte gnre un postback")> _
	Public Property AutoPostBack() As Boolean
		Get
			Return _AutoPostBack
		End Get
		Set(ByVal Value As Boolean)
			_AutoPostBack = Value
		End Set
	End Property

	'---- Mthode Render
	Protected Overrides Sub Render(ByVal output As System.Web.UI.HtmlTextWriter)
		Dim txtID As String = "txt" & ClientID
		Dim lstID As String = "lst" & ClientID
		Dim btnID As String = "btn" & ClientID
		With output
			' Zone de saisie de texte
			.AddAttribute(HtmlTextWriterAttribute.Type, "text")
			.AddAttribute(HtmlTextWriterAttribute.Id, txtID)
			.AddAttribute(HtmlTextWriterAttribute.Value, Text)
			.AddAttribute(HtmlTextWriterAttribute.Name, Me.UniqueID)
			.AddAttribute("onkeyup", String.Format("ChangeTexte({0}, {1});", lstID, txtID))
			.AddStyleAttribute(HtmlTextWriterStyle.Color, Global.GetColorString(TextForeColor))
			.AddStyleAttribute(HtmlTextWriterStyle.BackgroundColor, Global.GetColorString(TextBackColor))
			' Traitement du postback
			If _AutoPostBack Then
				.AddAttribute(HtmlTextWriterAttribute.Onchange, Page.GetPostBackEventReference(Me))
			End If
			.AddAttribute("language", "javascript")
			.RenderBeginTag(HtmlTextWriterTag.Input)
			.RenderEndTag()
			.WriteLine()

			' Le bouton
			.AddAttribute(HtmlTextWriterAttribute.Type, "button")
			.AddAttribute(HtmlTextWriterAttribute.Id, btnID)
			.AddAttribute(HtmlTextWriterAttribute.Name, btnID)
			.AddAttribute(HtmlTextWriterAttribute.Value, "V")
			.AddAttribute(HtmlTextWriterAttribute.Onclick, String.Format("HideOrShow({0});", lstID))
			.RenderBeginTag(HtmlTextWriterTag.Input)
			.RenderEndTag()
			.WriteLine()

			' La liste
			.AddAttribute(HtmlTextWriterAttribute.Id, lstID)
			.AddAttribute(HtmlTextWriterAttribute.Name, lstID)
			.AddAttribute(HtmlTextWriterAttribute.Size, ListLines.ToString)
			.AddStyleAttribute("left", "0")
			.AddStyleAttribute("top", "25")
			.AddStyleAttribute("width", "150")
			.AddStyleAttribute("position", "absolute")
			.AddAttribute("onkeydown", String.Format("KeySelect({0}, {1});", lstID, txtID))
			.AddAttribute("onblur", String.Format("Hide({0});", lstID))
			.AddAttribute(HtmlTextWriterAttribute.Onclick, String.Format("Select({0}, {1});", lstID, txtID))
			.AddStyleAttribute(HtmlTextWriterStyle.Color, Global.GetColorString(ListForeColor))
			.AddStyleAttribute(HtmlTextWriterStyle.BackgroundColor, Global.GetColorString(ListBackColor))
			.RenderBeginTag(HtmlTextWriterTag.Select)

			' Le contenu de la liste
			Dim li As ListItem
			For Each li In _Items
				.RenderBeginTag(HtmlTextWriterTag.Option)
				.Write(li.Text)
				.RenderEndTag()
				.WriteLine()
			Next
			.RenderEndTag()
			.WriteLine()

		End With
	End Sub

	'---- Chargement
	Private Sub DropDownPlus_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.Load
		' Associe le script js  la page
		Const ScriptID As String = "DDP"
		If (Not Page.IsClientScriptBlockRegistered(ScriptID)) Then
			Dim sc As String = "<script language=javascript src=DropDownPlus.js></script>"
			Page.RegisterClientScriptBlock(ScriptID, sc)
		End If

		' Ajoute la liste et la zone de texte  des tableaux de noms dans la page
		Dim element As String
		element = "document.getElementById(""lst" & ClientID & """)"
		Page.RegisterArrayDeclaration("DDP_lst", element)
		element = "document.getElementById(""txt" & ClientID & """)"
		Page.RegisterArrayDeclaration("DDP_txt", element)

		' Ajoute le script d'appel de la fonction d'initialisation
		Const ScriptStartupID As String = "DDPStartup"
		If (Not Page.IsStartupScriptRegistered(ScriptStartupID)) Then
			Dim sc As String = "<script language=javascript>Init();</script>"
			Page.RegisterStartupScript(ScriptID, sc)
		End If
	End Sub

	'---- Implmentation des interfaces lies au postback
	Public Function LoadPostData(ByVal postDataKey As String, ByVal postCollection As System.Collections.Specialized.NameValueCollection) As Boolean Implements System.Web.UI.IPostBackDataHandler.LoadPostData
		' Rcupre la valeur saisie
		Dim Valeur As String = postCollection(postDataKey)
		If Text Is Nothing Then Text = ""
		If Not Text.Equals(Valeur) Then
			' Changement
			Text = Valeur
			Return True
		Else
			' Pas de changement
			Return False
		End If
	End Function

	Public Sub RaisePostDataChangedEvent() Implements System.Web.UI.IPostBackDataHandler.RaisePostDataChangedEvent
		OnTextChanged(EventArgs.Empty)
	End Sub

	'---- Masque des proprits
	<Browsable(False)> _
	Public Overrides Property BackColor() As System.Drawing.Color
		Get

		End Get
		Set(ByVal Value As System.Drawing.Color)

		End Set
	End Property

	<Browsable(False)> _
	Public Overrides Property BorderColor() As System.Drawing.Color
		Get

		End Get
		Set(ByVal Value As System.Drawing.Color)

		End Set
	End Property

	<Browsable(False)> _
	Public Overrides Property BorderStyle() As System.Web.UI.WebControls.BorderStyle
		Get

		End Get
		Set(ByVal Value As System.Web.UI.WebControls.BorderStyle)

		End Set
	End Property

	<Browsable(False)> _
	Public Overrides Property BorderWidth() As System.Web.UI.WebControls.Unit
		Get

		End Get
		Set(ByVal Value As System.Web.UI.WebControls.Unit)

		End Set
	End Property
End Class
