Imports System.ComponentModel
Imports System.Web.UI
Imports System.Web.UI.WebControls

<DefaultProperty("Caption"), _
ToolboxData("<{0}:LabelText runat=server></{0}:LabelText>")> _
Public Class LabelText
	Inherits System.Web.UI.WebControls.WebControl

	'---- Donnes prives
	Private lbl As Label
	Private txt As TextBox

	'---- Proprit Text
	<Bindable(True), _
	Category("Appearance"), _
	DefaultValue("")> _
	Property [Text]() As String
		Get
			EnsureChildControls()
			Return txt.Text
		End Get

		Set(ByVal Value As String)
			EnsureChildControls()
			txt.Text = Value
		End Set
	End Property

	'---- Proprit Caption
	<Bindable(True), _
	Category("Appearance"), _
	DefaultValue("")> _
	Property Caption() As String
		Get
			EnsureChildControls()
			Return lbl.Text
		End Get

		Set(ByVal Value As String)
			EnsureChildControls()
			lbl.Text = Value
		End Set
	End Property

	'---- Cration des contrles enfants
	Protected Overrides Sub CreateChildControls()
		' Le Label
		lbl = New Label
		Controls.Add(lbl)

		' Le TextBox
		txt = New TextBox
		Controls.Add(txt)
	End Sub

	'---- Initialisation
	Protected Overrides Sub OnInit(ByVal e As System.EventArgs)
		' Cre les contrles enfants
		EnsureChildControls()
		' Caption par dfaut : nom du contrle
		If Caption = "" Then Caption = ID
	End Sub
End Class
