// Initialisations
function Init()
{
	// Cache toutes les listes
	HideAll();
	
	// et dfinit leurs tailles et positions
	for (i in DDP_lst)
	{
		t = DDP_txt[i].offsetTop + DDP_txt[i].offsetHeight;
		p = DDP_txt[i].offsetParent;
		while (p != null)
		{
			t += p.offsetTop;
			p = p.offsetParent;
		}
		DDP_lst[i].style.top = t;
		l = DDP_txt[i].offsetLeft;
		p = DDP_txt[i].offsetParent;
		while (p != null)
		{
			l += p.offsetLeft;
			p = p.offsetParent;
		}
		DDP_lst[i].style.left = l;
		DDP_lst[i].style.width = DDP_txt[i].offsetWidth;
	}
}

// Inverse la visibilit d'une liste
function HideOrShow(lst)
{
	if (lst.style.visibility != "visible")
	{
		lst.style.visibility = "visible";
		lst.focus();
	}
	else
		lst.style.visibility = "hidden";
	event.cancelBubble = true;
}

// Cache toutes les listes de la page
function HideAll()
{
	for (i in DDP_lst)
	{
		DDP_lst[i].style.visibility = "hidden";
	}
}

// Cache une liste
function Hide(lst)
{
	lst.style.visibility = "hidden";
}

// Copie l'lment slectionn de la liste dans le texte
function Select(lst, txt)
{
	if (lst.style.visibility == "visible" && lst.selectedIndex != -1)
	{
		txt.value = lst.options[lst.selectedIndex].text;
		lst.style.visibility = "hidden";
		txt.focus();
	}
}

// Slection d'un lment dans la liste avec le clavier
function KeySelect(lst, txt)
{
	if (event.keyCode == 9 || event.keyCode == 13)
	{
		Select(lst, txt);
	}
}

// Modification dans le texte
function ChangeTexte(lst, txt)
{
	texte = txt.value.toLowerCase();
	nb = texte.length;
	
	// Flche bas
	if (event.keyCode == 40)
	{
		HideOrShow(lst);
		return;
	}

	// Recherche
	for (i=0; i<lst.length; i++)
	{
		if (lst.all(i).text.toLowerCase().substring(0, nb)==texte)
		{
			lst.all(i).selected=true;
			if (event.keyCode >=32 && event.keyCode != 35 && event.keyCode != 36 && event.keyCode != 45 && event.keyCode != 46)
			{
				if (txt.value!=lst.all(i).text)
				{
					// Copie
					txt.value=lst.all(i).text;
					// Slectionne le texte ajout
					
					var r = txt.createTextRange();
					r.moveStart("character", nb);
					r.select();
				}
			}
			break;
		}
	}
};
