
ANALYZE NO_WRITE_TO_BINLOG TABLE 
        Adherent,Pratique,Sport;

EXPLAIN
SELECT a.civilite, a.prenom, a.nom, a.tel 
FROM Adherent a
   WHERE NOT EXISTS
    (SELECT spid FROM Pratique 
      WHERE adhid IN 
           (SELECT adhid FROM Adherent
                  WHERE nom = 'LARRAZET'
                  AND   prenom = 'CELINE')
      AND spid NOT IN
      (SELECT spid FROM Pratique WHERE adhid = a.adhid)
     )
    AND NOT EXISTS
       (SELECT spid FROM Pratique WHERE adhid = a.adhid
           AND spid NOT IN
           (SELECT spid FROM Pratique WHERE adhid IN 
             (SELECT adhid FROM Adherent
                     WHERE nom = 'LARRAZET'
                     AND   prenom = 'CELINE')))
    AND a.nom <> 'LARRAZET' AND a.prenom <> 'CELINE';

+----------+---------+---------+----------------+
| civilite | prenom  | nom     | tel            |
+----------+---------+---------+----------------+
| Mlle.    | JENIFER | THIRIET | 06-63-71-28-54 |
+----------+---------+---------+----------------+
1 row in set (24 min 41.72 sec)


CREATE TEMPORARY TABLE temp1 AS
SELECT spid FROM Pratique 
      WHERE adhid IN 
           (SELECT adhid FROM Adherent
                  WHERE nom = 'LARRAZET'
                  AND   prenom = 'CELINE');
CREATE TEMPORARY TABLE temp2 AS SELECT * FROM temp1;

EXPLAIN
SELECT a.civilite, a.prenom, a.nom, a.tel 
FROM Adherent a
   WHERE NOT EXISTS
    (SELECT spid FROM temp1
      WHERE spid NOT IN
      (SELECT spid FROM Pratique WHERE adhid = a.adhid)
     )
    AND NOT EXISTS
     (SELECT spid FROM Pratique 
             WHERE adhid = a.adhid
             AND spid NOT IN
           (SELECT spid FROM temp2))
    AND a.nom <> 'LARRAZET' AND a.prenom <> 'CELINE';

+----------+---------+---------+----------------+
| civilite | prenom  | nom     | tel            |
+----------+---------+---------+----------------+
| Mlle.    | JENIFER | THIRIET | 06-63-71-28-54 |
+----------+---------+---------+----------------+
1 row in set (0.58 sec)

/* index sur table tempo */

CREATE INDEX idx_temp ON temp1 (spid);

/* pas fait */


DROP TABLE temp_adh_escrime_pingpong_golf;

CREATE TEMPORARY TABLE temp_adh_escrime_pingpong_golf
    AS SELECT a.adhid, s.spid, s.splibelle, 
       a.nom, a.prenom, a.tel, a.date_nais
       FROM  Adherent a, Sport s, Pratique p
       WHERE s.splibelle IN ('Escrime','Ping-pong','Golf')
       AND   a.adhid = p.adhid
       AND   s.spid  = p.spid
       ORDER BY s.splibelle,a.nom;

EXPLAIN
SELECT adhid, nom, prenom, tel, date_nais, splibelle
       FROM  temp_adh_escrime_pingpong
       WHERE EXTRACT(YEAR FROM date_nais) BETWEEN 1965 AND 1995;

EXPLAIN
  SELECT a.adhid, s.spid, s.splibelle, 
       a.nom, a.prenom, a.tel, a.date_nais
       FROM  Adherent a, Sport s, Pratique p
       WHERE s.splibelle IN ('Escrime','Ping-pong','Golf')
       AND   a.adhid = p.adhid
       AND   s.spid  = p.spid
       AND   EXTRACT(YEAR FROM a.date_nais) BETWEEN 1965 AND 1995
       ORDER BY s.splibelle,a.nom;

// si trop pnalisant rduire la volumtrie

delete from pratique where adhid > 800 and adhid < 25000;
delete from adherent where adhid > 800 and adhid < 25000;

SELECT COUNT(*) "Nombre de sports" FROM Sport s;
SELECT COUNT(*) "Nombre d'adherents" FROM Adherent a;
SELECT COUNT(*) "Nombre d'inscriptions" FROM Pratique p;