/*  partitions */

SHOW VARIABLES LIKE '%partition%';
SHOW PLUGINS;


/* RANGE */

DROP TABLE Adherent_partition_range;
CREATE TABLE Adherent_partition_range
 (adhid      SMALLINT UNSIGNED NOT NULL, 
  nom        VARCHAR(25) NOT NULL, 
  prenom     VARCHAR(30) NOT NULL, 
  civilite   VARCHAR(12) NOT NULL, 
  date_nais  DATE NOT NULL,
  tel        VARCHAR(15))
PARTITION BY RANGE COLUMNS (date_nais)
 (PARTITION retraites VALUES LESS THAN ('1945-01-01'),
  PARTITION actifs    VALUES LESS THAN ('1993-01-01'),
  PARTITION mineurs   VALUES LESS THAN (MAXVALUE)); 

INSERT INTO Adherent_partition_range  
       SELECT * FROM Adherent;

/* index local */

CREATE INDEX Adherent_partition_idx
       ON Adherent_partition_range(date_nais);

/*  collecte des stats */

ANALYZE NO_WRITE_TO_BINLOG TABLE Adherent,Adherent_partition_range;

EXPLAIN 
SELECT a.adhid, a.prenom, a.nom 
  FROM Adherent a
  WHERE a.date_nais >= '1920-01-01'
  AND   a.date_nais <  '1945-01-01';

EXPLAIN PARTITIONS 
SELECT a.adhid, a.prenom, a.nom 
  FROM Adherent_partition_range a
  WHERE a.date_nais >= '1920-01-01'
  AND   a.date_nais <  '1945-01-01';

DROP TABLE Adherent_partition_range;  

/* LIST */


DROP TABLE Adherent_partition_list;

CREATE TABLE Adherent_partition_list
 (adhid      SMALLINT UNSIGNED NOT NULL, 
  nom        VARCHAR(25) NOT NULL, 
  prenom     VARCHAR(30) NOT NULL, 
  civilite   VARCHAR(12) NOT NULL, 
  date_nais  DATE NOT NULL,
  tel        VARCHAR(15))
 PARTITION BY LIST COLUMNS (civilite) 
  (PARTITION femmes VALUES IN ('Mlle.','Mme.'),
   PARTITION hommes VALUES IN ('Mr.'));

/* index local ... UNIQUE pas possible */

CREATE INDEX idx_adh_list_adhid
      ON Adherent_partition_list(adhid);

SHOW INDEX FROM Adherent_partition_list;

INSERT INTO Adherent_partition_list 
       SELECT * FROM Adherent;

/* collecte des stats */

ANALYZE NO_WRITE_TO_BINLOG TABLE Adherent,Adherent_partition_list ;

EXPLAIN PARTITIONS
SELECT  adhid, nom, tel
  FROM  Adherent_partition_list
  WHERE prenom = 'CELINE'
  AND   (civilite = 'Melle.'
  OR    civilite = 'Mme.')
  AND adhid IN (19110, 777, 17075);

/*
ALTER TABLE Adherent_partition_list
      ADD CONSTRAINT 
      pk_Adh_partition_list PRIMARY KEY(civilite);
*/

INSERT INTO Adherent_partition_list 
  VALUES (3,'SOUTOU','JEAN','ET.', '1965-05-02','05.31.98.71.02');

ALTER TABLE Adherent_partition_list
      ADD PARTITION 
  (PARTITION Extra_terrestres VALUES IN ('ET.'));

DROP TABLE Adherent_partition_list;

/*  hachage */

DROP TABLE Adherent_partition_hash;

CREATE TABLE Adherent_partition_hash
 (adhid      SMALLINT UNSIGNED PRIMARY KEY, 
  nom        VARCHAR(25) NOT NULL, 
  prenom     VARCHAR(30) NOT NULL, 
  civilite   VARCHAR(12) NOT NULL, 
  date_nais  DATE NOT NULL,
  tel        VARCHAR(15))
 PARTITION BY HASH (MOD(adhid,100))
 PARTITIONS 10; 


DROP TABLE Adherent_partition_hash;

CREATE TABLE Adherent_partition_hash
 (adhid      SMALLINT UNSIGNED PRIMARY KEY, 
  nom        VARCHAR(25) NOT NULL, 
  prenom     VARCHAR(30) NOT NULL, 
  civilite   VARCHAR(12) NOT NULL, 
  date_nais  DATE NOT NULL,
  tel        VARCHAR(15))
 PARTITION BY HASH (YEAR (date_nais))
 PARTITIONS 10; 

DROP TABLE Adherent_partition_hash;

CREATE TABLE Adherent_partition_hash
 (adhid      SMALLINT UNSIGNED NOT NULL, 
  nom        VARCHAR(25) NOT NULL, 
  prenom     VARCHAR(30) NOT NULL, 
  civilite   VARCHAR(12) NOT NULL, 
  date_nais  DATE NOT NULL,
  tel        VARCHAR(15))
 PARTITION BY HASH (adhid)
 PARTITIONS 10; 

CREATE INDEX idx_adh_hash_adhid
      ON Adherent_partition_hash(adhid);

SHOW INDEX FROM Adherent_partition_hash;

/* possible 
 PARTITION BY HASH (YEAR (date_nais))

 pb 
 SELECT CONV(HEX(prenom),16,10) FROM Adherent WHERE adhid>600 and adhid<778;
 SELECT COUNT(distinct CONV(HEX(prenom),16,10)) FROM Adherent;
 PARTITION BY HASH (CONV(HEX(prenom),16,10))
 ERROR 1564 (HY000): This partition function is not allowed
*/

INSERT INTO Adherent_partition_hash
       SELECT * FROM Adherent;

ALTER TABLE Adherent_partition_hash
      ADD CONSTRAINT pk_Adh_partition_hash PRIMARY KEY(adhid);   

/* collecte des stats */

ANALYZE NO_WRITE_TO_BINLOG TABLE Adherent,
Adherent_partition_hash;

/* cl */

CREATE TABLE Adherent_partition_cle
 (adhid      SMALLINT UNSIGNED PRIMARY KEY, 
  nom        VARCHAR(25) NOT NULL, 
  prenom     VARCHAR(30) NOT NULL, 
  civilite   VARCHAR(12) NOT NULL, 
  date_nais  DATE NOT NULL,
  tel        VARCHAR(15))
 PARTITION BY KEY()
 PARTITIONS 10; 

DROP TABLE Adherent_partition_cle;

CREATE TABLE Pratique_partition_cle
  (adhid SMALLINT UNSIGNED, 
   spid TINYINT UNSIGNED,
   PRIMARY KEY(adhid,spid))
 PARTITION BY KEY(adhid)
 PARTITIONS 10;

DROP TABLE Pratique_partition_cle;

/* composite range-hash */

CREATE TABLE Adherent_range_hash
 (adhid      SMALLINT UNSIGNED, 
  nom        VARCHAR(25) NOT NULL, 
  prenom     VARCHAR(30) NOT NULL, 
  civilite   VARCHAR(12) NOT NULL, 
  date_nais  DATE NOT NULL,
  tel        VARCHAR(15))
PARTITION BY RANGE COLUMNS (date_nais)
  SUBPARTITION BY HASH(adhid)
  (
   PARTITION retraites 
     VALUES LESS THAN ('1945-01-01')
      (SUBPARTITION s1, SUBPARTITION s2),
  PARTITION actifs    
     VALUES LESS THAN ('1993-01-01')
      (SUBPARTITION s3, SUBPARTITION s4),
  PARTITION mineurs   
     VALUES LESS THAN (MAXVALUE)
      (SUBPARTITION s5, SUBPARTITION s6)
   );

INSERT INTO Adherent_range_hash
       SELECT * FROM Adherent;

ALTER TABLE Adherent_range_hash
      ADD CONSTRAINT pk_Adh_range_hash PRIMARY KEY(adhid);   

CREATE INDEX idx_adhid_range_hash 
 ON Adherent_range_hash(adhid);   

DESCRIBE INFORMATION_SCHEMA.PARTITIONS;

SELECT TABLE_SCHEMA,TABLE_NAME, PARTITION_NAME, PARTITION_METHOD
  FROM INFORMATION_SCHEMA.PARTITIONS;

SELECT PARTITION_NAME AS "PARTITION", 
        SUBPARTITION_NAME AS "SOUS-PAR.", 
        TABLE_ROWS, AVG_ROW_LENGTH, DATA_LENGTH
        FROM INFORMATION_SCHEMA.PARTITIONS
        WHERE TABLE_NAME ='Adherent_range_hash';

SELECT DISTINCT PARTITION_METHOD AS "Type part.",
PARTITION_EXPRESSION AS "Colonne",      
PARTITION_DESCRIPTION "Valeur",
SUBPARTITION_METHOD AS "Type sous-part.",
SUBPARTITION_EXPRESSION AS "Colonne"
 FROM INFORMATION_SCHEMA.PARTITIONS
        WHERE TABLE_NAME ='Adherent_range_hash';
   
SELECT  
PARTITION_NAME AS "PARTITION", 
        SUBPARTITION_NAME AS "SOUS-PAR.", 
INDEX_LENGTH,
DATA_FREE,
TABLESPACE_NAME
FROM INFORMATION_SCHEMA.PARTITIONS
        WHERE TABLE_NAME ='Adherent_range_hash';
   
DROP TABLE Adherent_range_hash;
