
CREATE TABLE AvionsdeAF
(immat CHAR(6), typeAvion CHAR(10), nbHVol DECIMAL(10,2),
CONSTRAINT pk_AvionsdeAF PRIMARY KEY (immat));

CREATE TABLE AvionsdeSING
(immatriculation CHAR(6), typeAv CHAR(10), prixAchat DECIMAL(14,2),
CONSTRAINT pk_AvionsdeSING PRIMARY KEY (immatriculation));

INSERT INTO AvionsdeAF VALUES ('F-WTSS', 'Concorde', 6570);
INSERT INTO AvionsdeAF VALUES ('F-GLFS', 'A320', 3500);
INSERT INTO AvionsdeAF VALUES ('F-GTMP', 'A340', NULL);

INSERT INTO AvionsdeSING VALUES ('S-ANSI', 'A320', 104500);
INSERT INTO AvionsdeSING VALUES ('S-AVEZ', 'A320', 156000);
INSERT INTO AvionsdeSING VALUES ('S-MILE', 'A330', 198000);
INSERT INTO AvionsdeSING VALUES ('F-GTMP', 'A340', 204500);

/* Intersection avec IN */

SELECT DISTINCT typeAvion FROM AvionsdeAF
WHERE  typeAvion IN (SELECT typeAv FROM AvionsdeSING);

SELECT DISTINCT typeAv FROM AvionsdeSING 
WHERE typeAv IN (SELECT typeAvion FROM AvionsdeAF);

SELECT DISTINCT immat,typeAvion FROM AvionsdeAF
WHERE immat IN (SELECT immatriculation FROM AvionsdeSING)
AND typeAvion IN (SELECT typeAv FROM AvionsdeSING);

SELECT DISTINCT immatriculation ,typeAv FROM AvionsdeSING 
WHERE immatriculation  IN (SELECT immat FROM AvionsdeAF)
AND typeAv IN (SELECT typeAvion FROM AvionsdeAF);

/* union */ 

SELECT nbHVol FROM AvionsdeAF UNION SELECT prixAchat FROM AvionsdeSING;

SELECT typeAvion FROM AvionsdeAF UNION 
SELECT typeAv FROM AvionsdeSING;

SELECT typeAvion FROM AvionsdeAF UNION DISTINCT
SELECT typeAv FROM AvionsdeSING;

SELECT typeAvion FROM AvionsdeAF UNION ALL
SELECT typeAv FROM AvionsdeSING;

/* Diffrence avec NOT IN */

SELECT DISTINCT typeAvion FROM AvionsdeAF 
WHERE typeAvion NOT IN (SELECT typeAv FROM AvionsdeSING);

SELECT DISTINCT typeAv FROM AvionsdeSING 
WHERE typeAv NOT IN (SELECT typeAvion  FROM AvionsdeAF) ;

/* ordre */

SELECT typeAvion FROM AvionsdeAF UNION 
SELECT typeAv FROM AvionsdeSING
ORDER BY typeAvion DESC;

SELECT typeAvion FROM AvionsdeAF UNION 
SELECT typeAv FROM AvionsdeSING
ORDER BY 1 DESC;

/* Ordonner un rsultat */

SELECT T.typeAvion FROM
(SELECT typeAvion FROM AvionsdeAF UNION 
SELECT typeAv FROM AvionsdeSING) T ORDER BY T.typeAvion DESC;

/* Ajout colonnes */

SELECT immatriculation,prixAchat FROM AvionsdeSING 
UNION 
SELECT immat, 0 FROM AvionsdeAF 
ORDER BY 2 DESC;

SELECT immatriculation,1.2*prixAchat px FROM AvionsdeSING 
UNION 
SELECT immat, 0 FROM AvionsdeAF 
ORDER BY px DESC;

/* produit cartsien */

CREATE TABLE Pilote
	(brevet VARCHAR(6) PRIMARY KEY,
	 nom VARCHAR(16), nbHVol DECIMAL(7,2), compa CHAR(4));

INSERT INTO Pilote VALUES ('PL-1', 'Gratien Viel', 450, 'AF');
INSERT INTO Pilote VALUES ('PL-2', 'Richard Grin', 1000, 'SING');
INSERT INTO Pilote VALUES ('PL-3', 'Placide Fresnais', 2450, 'CAST');
INSERT INTO Pilote VALUES ('PL-4', 'Daniel Vielle', 5000, 'AF');

SELECT p.brevet, avAF.immat
FROM Pilote p, AvionsdeAF avAF
WHERE p.compa = 'AF';

SELECT p.brevet, avSING.immatriculation
FROM Pilote p, AvionsdeSING avSING
WHERE p.compa = 'SING';

DROP TABLE Pilote;
DROP TABLE AvionsdeAF;
DROP TABLE AvionsdeSING;