
/* Dico donnes */

DESCRIBE INFORMATION_SCHEMA.SCHEMATA;

SELECT SCHEMA_NAME AS 'Base de donnees', 
  DEFAULT_CHARACTER_SET_NAME AS 'Jeu caracteres', 
  DEFAULT_COLLATION_NAME 'Collation'
  FROM INFORMATION_SCHEMA.SCHEMATA;

SELECT SCHEMA_NAME AS 'Base de donnees', 
  SQL_PATH 'SQL Path'
  FROM INFORMATION_SCHEMA.SCHEMATA;


/*  sous root */
mysql --user=root --host=localhost -p 

CREATE DATABASE bdnouvelle 
	DEFAULT CHARACTER SET ascii COLLATE ascii_general_ci;

GRANT CREATE VIEW ON bdnouvelle.* TO 'soutou'@'localhost';

FLUSH PRIVILEGES;


/* sous user : vues */

CREATE TABLE Pilote
(brevet CHAR(6), nom CHAR(15), nbHVol DECIMAL(7,2), grade CHAR(4),
CONSTRAINT pk_Pilote PRIMARY KEY(brevet));
INSERT INTO Pilote (brevet,nom,nbHVol,grade)
	VALUES ('PL-1', 'Daniel Vielle', 1000, 'CDB');

CREATE VIEW VueDesPilotesJoursOuvrables
  AS SELECT * FROM Pilote
  WHERE CURTIME()+0 BETWEEN 83000 AND 173000
  AND DATE_FORMAT(SYSDATE(),'%W') NOT IN ('Sunday', 'Saturday')
  AND CURRENT_USER() = 'root@localhost'
  WITH CHECK OPTION;

CREATE VIEW bdnouvelle.VueDesSocietes
  AS SELECT * FROM Pilote
  WHERE CURTIME()+0 BETWEEN 03000 AND 173000
  AND DATE_FORMAT(SYSDATE(),'%W') NOT IN ('Sunday', 'Saturday');

/* sous root */

DESCRIBE INFORMATION_SCHEMA.VIEWS;

SELECT TABLE_SCHEMA,TABLE_NAME,CHECK_OPTION 
  FROM INFORMATION_SCHEMA.VIEWS;

SELECT TABLE_NAME,VIEW_DEFINITION 
  FROM INFORMATION_SCHEMA.VIEWS;

SELECT TABLE_SCHEMA,TABLE_NAME,CHECK_OPTION 
  FROM INFORMATION_SCHEMA.VIEWS
  WHERE  TABLE_SCHEMA='bdsoutou';


DROP VIEW bdnouvelle.VueDesSocietes;
DROP VIEW VueDesPilotesJoursOuvrables;
DROP TABLE Pilote;




/* Inno DB */

INNODB_CMP
INNODB_CMP_RESET 
INNODB_CMPMEM
INNODB_CMPMEM_RESET 
INNODB_TRX 
INNODB_LOCKS 
INNODB_LOCK_WAITS 

DESCRIBE INFORMATION_SCHEMA.INNODB_SYS_TABLES;

SELECT 
TABLE_ID,
NAME,
FLAG,
N_COLS,
SPACE
FROM INFORMATION_SCHEMA.INNODB_SYS_TABLES;

+----------+---------------------------+------+--------+-------+
| TABLE_ID | NAME                      | FLAG | N_COLS | SPACE |
+----------+---------------------------+------+--------+-------+
|       11 | SYS_FOREIGN               |    0 |      7 |     0 |
|       12 | SYS_FOREIGN_COLS          |    0 |      7 |     0 |
|      270 | bdsoutou/avions_xml_2     |    1 |      6 |   258 |
|      177 | bdsoutou/installer        |    1 |      8 |   165 |
|      176 | bdsoutou/logiciel         |    1 |      9 |   164 |
|      302 | bdsoutou/pilote           |    1 |      7 |   290 |
|      175 | bdsoutou/poste            |    1 |      9 |   163 |
|      174 | bdsoutou/salle            |    1 |      7 |   162 |
|      173 | bdsoutou/segment          |    1 |      6 |   161 |
|      277 | bdsoutou/tab_avions_xml_5 |    1 |      7 |   265 |
|      237 | bdsoutou/test             |    1 |      7 |   225 |
|      178 | bdsoutou/types            |    1 |      5 |   166 |
+----------+---------------------------+------+--------+-------+


DESCRIBE  INFORMATION_SCHEMA.INNODB_SYS_INDEXES;

SELECT 
INDEX_ID,
NAME,
TABLE_ID,
TYPE,
N_FIELDS,
PAGE_NO,
SPACE
FROM INFORMATION_SCHEMA.INNODB_SYS_INDEXES;

+----------+-----------------+----------+------+----------+---------+-------+
| INDEX_ID | NAME            | TABLE_ID | TYPE | N_FIELDS | PAGE_NO | SPACE |
+----------+-----------------+----------+------+----------+---------+-------+
|       11 | ID_IND          |       11 |    3 |        1 |     302 |     0 |
|       12 | FOR_IND         |       11 |    0 |        1 |     303 |     0 |
|       13 | REF_IND         |       11 |    0 |        1 |     304 |     0 |
|       14 | ID_IND          |       12 |    3 |        2 |     305 |     0 |
|      257 | PRIMARY         |      173 |    3 |        1 |       3 |   161 |
|      258 | PRIMARY         |      174 |    3 |        1 |       3 |   162 |
|      259 | PRIMARY         |      175 |    3 |        1 |       3 |   163 |
|      260 | PRIMARY         |      176 |    3 |        1 |       3 |   164 |
|      261 | PRIMARY         |      177 |    3 |        1 |       3 |   165 |
|      262 | PRIMARY         |      178 |    3 |        1 |       3 |   166 |
|      350 | GEN_CLUST_INDEX |      237 |    1 |        0 |       3 |   225 |
|      385 | PRIMARY         |      270 |    3 |        1 |       3 |   258 |
|      392 | PRIMARY         |      277 |    3 |        1 |       3 |   265 |
|      421 | PRIMARY         |      302 |    3 |        1 |       3 |   290 |
+----------+-----------------+----------+------+----------+---------+-------+

DESCRIBE INFORMATION_SCHEMA.INNODB_SYS_COLUMNS;

SELECT 
TABLE_ID,
NAME,
POS,
MTYPE,
PRTYPE,
LEN
FROM INFORMATION_SCHEMA.INNODB_SYS_COLUMNS;

DESCRIBE   INFORMATION_SCHEMA.INNODB_SYS_FIELDS;

SELECT 
INDEX_ID,
NAME,
POS
FROM INFORMATION_SCHEMA.INNODB_SYS_FIELDS;


DESCRIBE  INFORMATION_SCHEMA.INNODB_SYS_FOREIGN;

SELECT 
ID,
FOR_NAME,
REF_NAME,
N_COLS,
TYPE
FROM INFORMATION_SCHEMA.INNODB_SYS_FOREIGN;

DESCRIBE  INFORMATION_SCHEMA.INNODB_SYS_FOREIGN_COLS ;

SELECT 
ID,
FOR_COL_NAME,
REF_COL_NAME,
POS
FROM INFORMATION_SCHEMA.INNODB_SYS_FOREIGN_COLS ;

DESCRIBE INFORMATION_SCHEMA.INNODB_SYS_TABLESTATS ;

SELECT 
TABLE_ID,
NAME,
STATS_INITIALIZED,
NUM_ROWS,
CLUST_INDEX_SIZE,
OTHER_INDEX_SIZE,
MODIFIED_COUNTER,
AUTOINC,
MYSQL_HANDLES_OPENED
FROM INFORMATION_SCHEMA.INNODB_SYS_TABLESTATS;



/* serveur */


DESCRIBE INFORMATION_SCHEMA.ENGINES;

SELECT ENGINE, SUPPORT, COMMENT
  FROM INFORMATION_SCHEMA.ENGINES;

SELECT ENGINE, XA, SAVEPOINTS
  FROM INFORMATION_SCHEMA.ENGINES;

SELECT
  PLUGIN_NAME, PLUGIN_STATUS, PLUGIN_TYPE, PLUGIN_LICENSE
  FROM INFORMATION_SCHEMA.PLUGINS;

/* sessions */

SELECT * FROM INFORMATION_SCHEMA.PROCESSLIST;

/* Tablespaces prsent en 5.1 absent en 5.5 */

DESCRIBE INFORMATION_SCHEMA.TABLESPACES;

SELECT TABLESPACE_NAME,ENGINE,TABLESPACE_TYPE
  FROM INFORMATION_SCHEMA.TABLESPACES;

/*
LOGFILE_GROUP_NAME
EXTENT_SIZE
AUTOEXTEND_SIZE
MAXIMUM_SIZE
NODEGROUP_ID
TABLESPACE_COMMENT
*/

/* variables serveur */

DESCRIBE INFORMATION_SCHEMA.GLOBAL_STATUS;

SELECT VARIABLE_NAME,VARIABLE_VALUE
  FROM INFORMATION_SCHEMA.GLOBAL_STATUS;
 
SELECT VARIABLE_NAME,VARIABLE_VALUE
  FROM INFORMATION_SCHEMA.SESSION_STATUS;

/* Database */


CREATE TEMPORARY TABLE bdnouvelle.Impots (rien CHAR(1));

/* n'apparait pas dans le dd */

DESCRIBE INFORMATION_SCHEMA.TABLES; 

SELECT TABLE_SCHEMA,TABLE_NAME,TABLE_TYPE,DATE(CREATE_TIME) 
  FROM INFORMATION_SCHEMA.TABLES
  WHERE TABLE_SCHEMA NOT IN ('information_schema','test','mysql');

SELECT ENGINE,AUTO_INCREMENT,TABLE_ROWS,AVG_ROW_LENGTH,DATA_LENGTH 
  FROM INFORMATION_SCHEMA.TABLES
  WHERE TABLE_SCHEMA = 'bdsoutou' 
  AND   TABLE_NAME='Installer';

SELECT TABLE_NAME,TABLE_COMMENT
  FROM INFORMATION_SCHEMA.TABLES
  WHERE TABLE_SCHEMA NOT IN ('information_schema','test','mysql');

DROP TEMPORARY TABLE bdnouvelle.Impots;

/* Tables */
         
DESCRIBE INFORMATION_SCHEMA.COLUMNS;
  
SELECT COLUMN_NAME,DATA_TYPE,ORDINAL_POSITION,COLUMN_DEFAULT,COLUMN_KEY 
       FROM INFORMATION_SCHEMA.COLUMNS 
WHERE TABLE_SCHEMA = 'bdsoutou' AND TABLE_NAME='Installer';

SELECT COLUMN_NAME,DATA_TYPE,CHARACTER_OCTET_LENGTH AS 'Taille max',IS_NULLABLE
       FROM INFORMATION_SCHEMA.COLUMNS 
WHERE TABLE_SCHEMA = 'bdsoutou' AND TABLE_NAME='Installer'
AND NUMERIC_PRECISION IS NULL AND DATA_TYPE NOT IN ('timestamp','time','date');

SELECT COLUMN_NAME,DATA_TYPE,NUMERIC_PRECISION AS 'Taille max',NUMERIC_SCALE AS 'Prcision'  
       FROM INFORMATION_SCHEMA.COLUMNS 
WHERE TABLE_SCHEMA = 'bdsoutou' AND TABLE_NAME='Installer'
AND CHARACTER_MAXIMUM_LENGTH IS NULL
AND DATA_TYPE NOT IN ('timestamp','time','date');

SELECT COLUMN_NAME,DATA_TYPE,COLUMN_DEFAULT
FROM INFORMATION_SCHEMA.COLUMNS 
WHERE TABLE_SCHEMA = 'bdsoutou' AND TABLE_NAME='Installer'
AND CHARACTER_MAXIMUM_LENGTH IS NULL
AND DATA_TYPE IN ('timestamp','time','date');

/* Partitions */

DESCRIBE INFORMATION_SCHEMA.PARTITIONS;

SELECT TABLE_SCHEMA,TABLE_NAME, PARTITION_NAME, PARTITION_METHOD
  FROM INFORMATION_SCHEMA.PARTITIONS;

/* contraintes */

SELECT
CONSTRAINT_SCHEMA ,    
CONSTRAINT_NAME    , 
CONSTRAINT_TYPE
FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS 
WHERE TABLE_SCHEMA = 'bdsoutou' AND TABLE_NAME='Installer';

CREATE TABLE test.testCont
(col1     varchar(7),
 col2       varchar(5),
 numIns     INTEGER(5) AUTO_INCREMENT,
 CONSTRAINT pk_Installer PRIMARY KEY(numIns),
 CONSTRAINT un_Installer UNIQUE(col1),
 CONSTRAINT ck_Installer CHECK (NOT (col2 ='MySQL')));

SELECT
CONSTRAINT_SCHEMA,CONSTRAINT_NAME,CONSTRAINT_TYPE
FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS 
WHERE TABLE_SCHEMA = 'test' AND TABLE_NAME='testCont';

DROP TABLE test.testCont;

/* nature d'une cl primaire (idem pour les FK) */

DESC INFORMATION_SCHEMA.KEY_COLUMN_USAGE ;

SELECT CONSTRAINT_NAME, COLUMN_NAME, ORDINAL_POSITION AS 'Position',
 POSITION_IN_UNIQUE_CONSTRAINT AS 'Position index'
       FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE 
WHERE TABLE_SCHEMA = 'bdsoutou' AND TABLE_NAME='Installer';

SELECT CONSTRAINT_NAME, COLUMN_NAME AS 'Cle', 
 REFERENCED_TABLE_SCHEMA AS 'Base cible',
 REFERENCED_TABLE_NAME AS 'Table pere',
 REFERENCED_COLUMN_NAME AS 'Col pere'
       FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE 
       WHERE TABLE_SCHEMA = 'bdsoutou' 
       AND TABLE_NAME='Installer'
       AND REFERENCED_TABLE_SCHEMA IS NOT NULL;

DESCRIBE INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS;

SELECT
CONSTRAINT_NAME,
UPDATE_RULE,
DELETE_RULE,
REFERENCED_TABLE_NAME "Table cible"
FROM  INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS
WHERE TABLE_NAME='Installer'
AND CONSTRAINT_SCHEMA='bdsoutou';

/*
SELECT
CONSTRAINT_CATALOG,
UNIQUE_CONSTRAINT_SCHEMA,
UNIQUE_CONSTRAINT_NAME,
UNIQUE_CONSTRAINT_CATALOG
FROM  INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS
WHERE TABLE_NAME='Installer'
AND CONSTRAINT_SCHEMA='bdsoutou';
*/


/* source procdure */

delimiter $

CREATE PROCEDURE test.sp1(par_1 CHAR(5), par_2 SMALLINT)
BEGIN
  DECLARE v_brevet CHAR(6);
  SET v_brevet := 'PROC';
END;
$

CREATE FUNCTION test.sp2(par_3 INT) RETURNS CHAR(3)
BEGIN
  DECLARE v_brevet CHAR(3);
  SET v_brevet := 'FCT';
  RETURN v_brevet ;
END;
$

delimiter ;

DESC INFORMATION_SCHEMA.ROUTINES ;

SELECT ROUTINE_NAME,ROUTINE_TYPE,ROUTINE_DEFINITION
FROM  INFORMATION_SCHEMA.ROUTINES 
WHERE ROUTINE_SCHEMA = 'test' ;

SELECT ROUTINE_NAME,EXTERNAL_NAME,EXTERNAL_LANGUAGE,PARAMETER_STYLE 
FROM  INFORMATION_SCHEMA.ROUTINES 
WHERE ROUTINE_SCHEMA = 'test' ;

SELECT ROUTINE_NAME,IS_DETERMINISTIC,SQL_DATA_ACCESS,SQL_PATH 
FROM  INFORMATION_SCHEMA.ROUTINES 
WHERE ROUTINE_SCHEMA = 'test' ;

SELECT ROUTINE_NAME,SECURITY_TYPE,CREATED,LAST_ALTERED,SQL_MODE
FROM  INFORMATION_SCHEMA.ROUTINES 
WHERE ROUTINE_SCHEMA = 'test' ;

SELECT ROUTINE_NAME,ROUTINE_COMMENT,DEFINER
FROM  INFORMATION_SCHEMA.ROUTINES 
WHERE ROUTINE_SCHEMA = 'test' ;

DESC INFORMATION_SCHEMA.PARAMETERS;

SELECT 
 SPECIFIC_NAME,ORDINAL_POSITION, 
 PARAMETER_MODE,PARAMETER_NAME
  FROM INFORMATION_SCHEMA.PARAMETERS
  WHERE SPECIFIC_SCHEMA='test';

SELECT 
 PARAMETER_NAME,DATA_TYPE,
CHARACTER_MAXIMUM_LENGTH,ROUTINE_TYPE
  FROM INFORMATION_SCHEMA.PARAMETERS
  WHERE SPECIFIC_SCHEMA='test';

SELECT 
 PARAMETER_NAME,CHARACTER_OCTET_LENGTH,
  NUMERIC_PRECISION,NUMERIC_SCALE,
CHARACTER_SET_NAME, COLLATION_NAME, DTD_IDENTIFIER
  FROM INFORMATION_SCHEMA.PARAMETERS
  WHERE SPECIFIC_SCHEMA='test';

DROP PROCEDURE test.sp1;
DROP FUNCTION test.sp2;

/* Utilisateurs global */

DESC INFORMATION_SCHEMA.USER_PRIVILEGES ;

SELECT GRANTEE,PRIVILEGE_TYPE,IS_GRANTABLE
FROM  INFORMATION_SCHEMA.USER_PRIVILEGES 
WHERE GRANTEE LIKE '''Paul%' OR GRANTEE LIKE '''Jules%';

/* privilges database */

DESC INFORMATION_SCHEMA.SCHEMA_PRIVILEGES ;


SELECT  TABLE_SCHEMA,GRANTEE,PRIVILEGE_TYPE,IS_GRANTABLE
FROM  INFORMATION_SCHEMA.SCHEMA_PRIVILEGES 
WHERE GRANTEE LIKE '''Paul%';

/* privilges table */

DESC INFORMATION_SCHEMA.TABLE_PRIVILEGES ;

SELECT CONCAT(TABLE_SCHEMA,'.',TABLE_NAME) AS 'Base.Table',
 GRANTEE,PRIVILEGE_TYPE AS 'Privilege'
FROM  INFORMATION_SCHEMA.TABLE_PRIVILEGES 
WHERE GRANTEE LIKE '''Paul%';

/* privilges columns */

DESC INFORMATION_SCHEMA.COLUMN_PRIVILEGES ;

SELECT CONCAT(TABLE_NAME,'.',COLUMN_NAME) AS 'Table.colonne', 
 GRANTEE,PRIVILEGE_TYPE AS 'Privilege'
FROM  INFORMATION_SCHEMA.COLUMN_PRIVILEGES 
WHERE  TABLE_SCHEMA='bdpaul';

SELECT * FROM  INFORMATION_SCHEMA.COLUMN_PRIVILEGES ;