
/* exceptions nommes */


delimiter ;
DROP TABLE IF EXISTS Pilote;
DROP TABLE IF EXISTS Compagnie;

CREATE TABLE Compagnie
	(comp VARCHAR(4), ville VARCHAR(15), nomComp VARCHAR(15),
 	CONSTRAINT pk_Compagnie PRIMARY KEY(comp));
CREATE TABLE Pilote
	(brevet VARCHAR(6) PRIMARY KEY,
	 nom VARCHAR(20), nbHVol DECIMAL(7,2), 
         comp VARCHAR(4),
        CONSTRAINT fkPil FOREIGN KEY (comp) REFERENCES Compagnie(comp));

INSERT INTO Compagnie	VALUES ('AF', 'Paris', 'Air France');
INSERT INTO Compagnie   VALUES ('SING', 'Singapour', 'Singapore AL');
INSERT INTO Compagnie   VALUES ('CAST', 'Blagnac', 'Castanet AL');
INSERT INTO Compagnie   VALUES ('EJET', 'Dublin', 'Easy Jet');

INSERT INTO Pilote VALUES ('PL-1', 'Gilles Laborde', 2450, 'AF');
INSERT INTO Pilote VALUES ('PL-2', 'Frdric D''Almeyda', 900, 'AF');
INSERT INTO Pilote VALUES ('PL-3', 'Florence Prissel', 1000, 'SING');
INSERT INTO Pilote VALUES ('PL-4', 'Sonia Dietrich', 2450, 'CAST');
INSERT INTO Pilote VALUES ('PL-5', 'Christine Royo', 200, 'AF');
INSERT INTO Pilote VALUES ('PL-6', 'Aurlia Ente', 2450, 'SING');

/* 
INSERT INTO Pilote VALUES ('PL-7', 'Bug', 450, 'Mada');
ERROR 1452 (23000): Cannot add or update a child row: a foreign key constraint f
ails (`bdsoutou/pilote`, CONSTRAINT `fkPil` FOREIGN KEY (`comp`) REFERENCES `compagnie` (`comp`))
*/

delimiter $

CREATE PROCEDURE bdsoutou.exception9(IN p_comp VARCHAR(4)) 
BEGIN
 DECLARE flagerr BOOLEAN DEFAULT 0;
  BEGIN
   DECLARE erreur_ilResteUnPilote CONDITION FOR SQLSTATE '23000';
-- DECLARE erreur_ilResteUnPilote CONDITION FOR 1217;
-- bug avec 1217 pourtant dans doc.
-- DECLARE erreur_ilResteUnPilote CONDITION FOR 1451;
   DECLARE EXIT HANDLER FOR erreur_ilResteUnPilote SET flagerr :=1;
   SET AUTOCOMMIT=0;
   DELETE FROM Compagnie WHERE comp = p_comp;
   SELECT CONCAT('Compagnie ',p_comp, ' dtruite') 
          AS 'Resultat procExceptionNommee';
  END;
  IF flagerr THEN
     ROLLBACK;
     SELECT CONCAT('Dsol, il reste encore un pilote  la compagnie ',p_comp) 
          AS 'Resultat procExceptionNommee';
   ELSE
   COMMIT;
 END IF;
END;
$

CALL bdsoutou.exception9('AF')$
CALL bdsoutou.exception9('SING')$
CALL bdsoutou.exception9('rien')$
CALL bdsoutou.exception9('EJET')$