
CREATE TABLE TypeAvion
	(typA VARCHAR(4), nomType VARCHAR(30));

CREATE TABLE Pilote
	(brevet VARCHAR(6), nom VARCHAR(20), nbHVol DECIMAL(7,2), compa VARCHAR(4), nbQualif TINYINT(1),
	 CONSTRAINT pk_Pilote PRIMARY KEY(brevet));

CREATE TABLE Qualifications
	(brevet VARCHAR(6), typa VARCHAR(4), expire DATE);

INSERT INTO TypeAvion VALUES ('A320', 'Biracteur Airbus 320');
INSERT INTO TypeAvion VALUES ('A330', 'Biracteur Airbus 330');
INSERT INTO TypeAvion VALUES ('A340', 'Quadriracteur Airbus 340');
INSERT INTO TypeAvion VALUES ('A380', 'Big-Quadriracteur 380');

INSERT INTO Pilote VALUES ('PL-1', 'P. Caboche', 450, 'AF',3);
INSERT INTO Pilote VALUES ('PL-2', 'G. Lebur', 3400, 'AF',1);
INSERT INTO Pilote VALUES ('PL-3', 'X. Leclercq', 900, 'SING',1);

INSERT INTO Qualifications VALUES ('PL-1', 'A340', '2005-06-22');
INSERT INTO Qualifications VALUES ('PL-1', 'A330', '2005-02-05');
INSERT INTO Qualifications VALUES ('PL-1', 'A320', '2004-01-16');
INSERT INTO Qualifications VALUES ('PL-2', 'A320', '2004-01-18');
INSERT INTO Qualifications VALUES ('PL-3', 'A330', '2006-01-22');

SELECT * FROM Pilote;
SELECT * FROM TypeAvion ;
SELECT * FROM Qualifications ;

/*  trigger after delete  */

delimiter $

CREATE TRIGGER TriDelQualif
 AFTER DELETE ON Qualifications
 FOR EACH ROW
BEGIN
   UPDATE Pilote SET nbQualif = nbQualif - 1 WHERE brevet = OLD.brevet;
END;
$

DELETE FROM Qualifications WHERE typa = 'A320'$

SELECT * FROM Pilote$
SELECT * FROM Qualifications$

/* AFTER INSERT */

delimiter ;
delete from Qualifications ;
delete from Pilote ;
delete from TypeAvion ;

INSERT INTO TypeAvion VALUES ('A320', 'Biracteur Airbus 320');
INSERT INTO TypeAvion VALUES ('A330', 'Biracteur Airbus 330');
INSERT INTO TypeAvion VALUES ('A340', 'Quadriracteur Airbus 340');
INSERT INTO TypeAvion VALUES ('A380', 'Big-Quadriracteur 380');

INSERT INTO Pilote VALUES ('PL-1', 'P. Caboche', 450, 'AF',3);
INSERT INTO Pilote VALUES ('PL-2', 'G. Lebur', 3400, 'AF',1);
INSERT INTO Pilote VALUES ('PL-3', 'X. Leclercq', 900, 'SING',1);

INSERT INTO Qualifications VALUES ('PL-1', 'A340', '2005-06-22');
INSERT INTO Qualifications VALUES ('PL-1', 'A330', '2005-02-05');
INSERT INTO Qualifications VALUES ('PL-1', 'A320', '2004-01-16');
INSERT INTO Qualifications VALUES ('PL-2', 'A320', '2004-01-18');
INSERT INTO Qualifications VALUES ('PL-3', 'A330', '2006-01-22');

delimiter $

CREATE TRIGGER TrigInsQualif
 AFTER INSERT ON Qualifications
 FOR EACH ROW
BEGIN
 UPDATE Pilote SET nbQualif = nbQualif + 1 WHERE brevet = NEW.brevet;
END;
$

SELECT * FROM Pilote$
SELECT * FROM Qualifications $

INSERT INTO Qualifications VALUES ('PL-2', 'A380', SYSDATE())$

SELECT * FROM Pilote$
SELECT * FROM Qualifications $

DROP TRIGGER TrigInsQualif$


/* trigger after update */

delimiter ;
delete from Qualifications ;
delete from Pilote ;
delete from TypeAvion ;

INSERT INTO TypeAvion VALUES ('A320', 'Biracteur Airbus 320');
INSERT INTO TypeAvion VALUES ('A330', 'Biracteur Airbus 330');
INSERT INTO TypeAvion VALUES ('A340', 'Quadriracteur Airbus 340');
INSERT INTO TypeAvion VALUES ('A380', 'Big-Quadriracteur 380');

INSERT INTO Pilote VALUES ('PL-1', 'P. Caboche', 450, 'AF',3);
INSERT INTO Pilote VALUES ('PL-2', 'G. Lebur', 3400, 'AF',1);
INSERT INTO Pilote VALUES ('PL-3', 'X. Leclercq', 900, 'SING',1);

INSERT INTO Qualifications VALUES ('PL-1', 'A340', '2005-06-22');
INSERT INTO Qualifications VALUES ('PL-1', 'A330', '2005-02-05');
INSERT INTO Qualifications VALUES ('PL-1', 'A320', '2004-01-16');
INSERT INTO Qualifications VALUES ('PL-2', 'A320', '2004-01-18');
INSERT INTO Qualifications VALUES ('PL-3', 'A330', '2006-01-22');

delimiter $

CREATE TRIGGER TrigUpdQualif
 AFTER UPDATE ON Qualifications 
 FOR EACH ROW
BEGIN
    UPDATE Pilote SET nbQualif = nbQualif + 1 WHERE brevet = NEW.brevet;
    UPDATE Pilote SET nbQualif = nbQualif - 1 WHERE brevet = OLD.brevet;
END;
$

SELECT * FROM Pilote$
SELECT * FROM Qualifications$

UPDATE Qualifications 
       SET brevet   = 'PL-2'
       WHERE brevet = 'PL-3'
       AND   typa   = 'A330'$

SELECT * FROM Pilote$
SELECT * FROM Qualifications$

/* Synthse OLD et NEW */

CREATE TRIGGER Trigtemp
 AFTER DELETE ON Qualifications
 FOR EACH ROW
BEGIN
   UPDATE Pilote SET nbQualif = nbQualif - 1 WHERE brevet = NEW.brevet;
END;
$

--> ERROR 1363 (HY000): There is no NEW row in on DELETE trigger

CREATE TRIGGER Trigtemp
 AFTER INSERT ON Qualifications
 FOR EACH ROW
BEGIN
 UPDATE Pilote SET nbQualif = nbQualif + 1 WHERE brevet = OLD.brevet;
END;
$

--> ERROR 1363 (HY000): There is no OLD row in on INSERT trigger

/* RETURN et LEAVE */ 

CREATE TRIGGER Trigtemp
 BEFORE INSERT ON Qualifications
 FOR EACH ROW
BEGIN
  RETURN;
END;
$
CREATE TRIGGER Trigtemp
 BEFORE INSERT ON Qualifications
 FOR EACH ROW
BEGIN
  RETURN;
END;
$

DROP TRIGGER IF EXISTS Trigtemp$
CREATE TRIGGER Trigtemp
 BEFORE INSERT ON Qualifications
 FOR EACH ROW
trigg:BEGIN
  LEAVE trigg;
END;
$

INSERT INTO Qualifications VALUES ('PL-3', 'A320', '2010-01-22')$
SELECT * FROM Pilote$
SELECT * FROM Qualifications$

/* Dictionnaire des donnes */

DROP TRIGGER TriDelQualif$
DROP TRIGGER TrigInsQualif$
DROP TRIGGER TrigUpdQualif$

CREATE TRIGGER TriDelQualif
 AFTER DELETE ON Qualifications
 FOR EACH ROW
BEGIN
   UPDATE Pilote SET nbQualif = nbQualif - 1 WHERE brevet = OLD.brevet;
END;
$

CREATE TRIGGER TrigInsQualif
 AFTER INSERT ON Qualifications
 FOR EACH ROW
BEGIN
 UPDATE Pilote SET nbQualif = nbQualif + 1 WHERE brevet = NEW.brevet;
END;
$

CREATE TRIGGER TrigUpdQualif
 AFTER UPDATE ON Qualifications 
 FOR EACH ROW
BEGIN
    UPDATE Pilote SET nbQualif = nbQualif + 1 WHERE brevet = NEW.brevet;
    UPDATE Pilote SET nbQualif = nbQualif - 1 WHERE brevet = OLD.brevet;
END;
$

SELECT TRIGGER_NAME,EVENT_OBJECT_TABLE "Table",
       EVENT_MANIPULATION "Evenement", ACTION_TIMING,EVENT_OBJECT_SCHEMA "Base"
  FROM INFORMATION_SCHEMA.TRIGGERS
WHERE  TRIGGER_SCHEMA='bdsoutou'$

SELECT ACTION_STATEMENT  FROM INFORMATION_SCHEMA.TRIGGERS
WHERE  TRIGGER_SCHEMA='bdsoutou' AND EVENT_OBJECT_TABLE='Qualifications'
AND EVENT_MANIPULATION='UPDATE' AND ACTION_TIMING='AFTER'$

SHOW TRIGGERS$

/* Appels procdures */

CREATE TABLE Trace(col VARCHAR(80))$

CREATE PROCEDURE bdsoutou.procTrigg(IN param DATETIME) 
BEGIN
   INSERT INTO Trace VALUES (CONCAT('Insertion pilote, appel de bdsoutou.procTrigg le ',param));	
 --  COMMIT;
 -- ERROR 1422 (HY000): Explicit or implicit commit is not allowed in stored functio
 -- n or trigger.
END;
$

CREATE TRIGGER bdsoutou.espionAjoutPilote
 BEFORE INSERT ON Pilote
 FOR EACH ROW
BEGIN
 CALL bdsoutou.procTrigg(SYSDATE());
END;
$

SELECT * FROM Pilote$
SELECT * FROM Trace$
INSERT INTO Pilote VALUES ('PL-4', 'C. Soutou', 100, 'AF',0)$
SELECT * FROM Pilote$
SELECT * FROM Trace$

/* si grade copil / nbHvol > ... 3cas */

DROP TABLE IF EXISTS Pilote$

CREATE TABLE Pilote
(brevet CHAR(6), nom CHAR(15), nbHVol DECIMAL(7,2), 
 grade CHAR(4),
CONSTRAINT pk_Pilote PRIMARY KEY(brevet))$

CREATE TRIGGER TrigInsGrade
 BEFORE INSERT ON Pilote
 FOR EACH ROW
BEGIN
 IF (NEW.grade = 'CDB' AND (NEW.nbHVol<1000)) THEN 
   SET NEW.grade := 'COPI';
 END IF;
 IF (NEW.grade = 'CDB' AND (NEW.nbHVol>4000)) THEN 
   SET NEW.grade := 'INST';
 END IF;
 IF (NEW.grade = 'COPI' AND (NEW.nbHVol>1000)) THEN 
   SET NEW.grade :=  'CDB';
 END IF;
 IF (NEW.grade = 'INST' AND (NEW.nbHVol<3000)) OR  (NEW.nbHVol<100) THEN 
   SET NEW.grade :=  NULL;
 END IF;
END;
$

INSERT INTO Pilote VALUES ('PL-1', 'Daniel Vielle', 1000, 'CDB')$
INSERT INTO Pilote VALUES ('PL-2', 'Benoit Treihlou', 450, 'COPI')$
INSERT INTO Pilote VALUES ('PL-3', 'Pierre Filoux', 9000, 'INST')$
INSERT INTO Pilote VALUES ('PL-4', 'Philippe Minier', 1000, 'COPI')$

SELECT * FROM Pilote$

INSERT INTO Pilote VALUES ('PL-5', 'Trop jeune', 100, 'CDB')$
INSERT INTO Pilote VALUES ('PL-6', 'Inexperimente', 2999, 'INST')$

SELECT * FROM Pilote$

/* Exceptions */

DROP TABLE IF EXISTS Qualifications$
DROP TABLE IF EXISTS Pilote$
DROP TABLE IF EXISTS TypeAvion$

CREATE TABLE TypeAvion
(typA VARCHAR(4), nomType VARCHAR(30))$
CREATE TABLE Pilote
(brevet VARCHAR(6), nom VARCHAR(20), nbHVol DECIMAL(7,2), 
compa VARCHAR(4), nbQualif TINYINT(1),
CONSTRAINT pk_Pilote PRIMARY KEY(brevet))$
CREATE TABLE Qualifications
(brevet VARCHAR(6), typa VARCHAR(4), expire DATE)$

INSERT INTO TypeAvion VALUES ('A320', 'Biracteur Airbus 320')$
INSERT INTO TypeAvion VALUES ('A330', 'Biracteur Airbus 330')$
INSERT INTO TypeAvion VALUES ('A340', 'Quadriracteur Airbus 340')$
INSERT INTO TypeAvion VALUES ('A380', 'Big-Quadriracteur 380')$

INSERT INTO Pilote VALUES ('PL-1', 'P. Caboche', 450, 'AF',3)$
INSERT INTO Pilote VALUES ('PL-2', 'G. Lebur', 3400, 'AF',1)$
INSERT INTO Pilote VALUES ('PL-3', 'X. Leclercq', 900, 'SING',1)$

INSERT INTO Qualifications VALUES ('PL-1', 'A340', '2005-06-22')$
INSERT INTO Qualifications VALUES ('PL-1', 'A330', '2005-02-05')$
INSERT INTO Qualifications VALUES ('PL-1', 'A320', '2004-01-16')$
INSERT INTO Qualifications VALUES ('PL-2', 'A320', '2004-01-18')$
INSERT INTO Qualifications VALUES ('PL-3', 'A330', '2006-01-22')$


CREATE TRIGGER TrigExceptionInsert
 BEFORE INSERT ON Qualifications
 FOR EACH ROW
BEGIN
 DECLARE v_compteur TINYINT(1);
 SELECT nbQualif INTO v_compteur FROM Pilote 
     WHERE brevet = NEW.brevet;
 IF v_compteur < 3 THEN
    UPDATE Pilote SET nbQualif = nbQualif + 1 
           WHERE brevet = NEW.brevet;
 ELSE
    SIGNAL SQLSTATE '45000'
        SET MESSAGE_TEXT = 'Le pilote a dj 3 qualifications', 
            MYSQL_ERRNO  = 8000;
 END IF;
END;
$

INSERT INTO Qualifications VALUES ('PL-2', 'A380', '2010-01-18')$

INSERT INTO Qualifications VALUES ('PL-1', 'A380', '2010-01-16')$
SHOW ERRORS$
SHOW WARNINGS$

SELECT * FROM Qualifications$
SELECT * FROM Pilote$

/* rcuprer l'erreur dans un bloc */


CREATE PROCEDURE bdsoutou.proc_ajout_trigger
 (IN v_brevet VARCHAR(6), 
  IN v_typa VARCHAR(4), IN v_expire DATE)
BEGIN
  DECLARE v_flag TINYINT DEFAULT 0;
  DECLARE CONTINUE HANDLER 
          FOR SQLSTATE VALUE '45000' SET v_flag = 1;
  INSERT INTO Qualifications
   (brevet,typa,expire)
   VALUES (v_brevet,v_typa,v_expire);
   CASE 
    WHEN v_flag=0 THEN SET v_flag = 0; /* Rien  faire */
    WHEN v_flag=1 THEN 
           SHOW ERRORS;
           SELECT nom "C'est lui!" FROM Pilote WHERE brevet=v_brevet;      
  END CASE;
END;
$
CALL bdsoutou.proc_ajout_trigger('PL-1','A380','2010-01-16')$

/* mutating */

SET @vs_nombre=0$

CREATE TRIGGER TrigMutant
 AFTER INSERT ON Trace 
 FOR EACH ROW
BEGIN
 DECLARE v_nombre TINYINT;
 SELECT COUNT(*) INTO  @vs_nombre FROM Trace;
END;
$

DELETE FROM Trace$
SELECT * FROM Trace$
SELECT @vs_nombre$
INSERT INTO Trace VALUES ('Test TrigMutant')$
SELECT @vs_nombre$
SELECT * FROM Trace$

DROP TRIGGER TrigMutant$

CREATE TRIGGER TrigMutant
 AFTER INSERT ON Trace 
 FOR EACH ROW
BEGIN
 DECLARE v_nombre TINYINT;
 SELECT COUNT(*) INTO  @vs_nombre FROM Trace;
 UPDATE Trace SET col = 'Le trigger est pass l...';
END;
$

DELETE FROM Trace$
SELECT * FROM Trace$
SELECT @vs_nombre$
INSERT INTO Trace VALUES ('Test2 TrigMutant')$

delimiter ;