
delimiter $

CREATE PROCEDURE bdsoutou.cursex1()
BEGIN
  DECLARE fincurs1 BOOLEAN DEFAULT 0;
  DECLARE v_brevet VARCHAR(6);
  DECLARE v_nbHv   DECIMAL(7,2);
  DECLARE v_comp   VARCHAR(4);
 
  DECLARE curs1 CURSOR FOR 
	SELECT brevet,nbHVol,comp 
	FROM bdsoutou.Pilote WHERE comp = 'AF';
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET fincurs1 := 1;

  OPEN curs1;

  REPEAT
    FETCH curs1 INTO v_brevet,v_nbHv,v_comp;
    IF NOT fincurs1 THEN
	SELECT  v_brevet,v_nbHv;
    END IF;
    UNTIL fincurs1 
  END REPEAT;
  CLOSE curs1;
END;
$

CALL bdsoutou.cursex1()$

CREATE PROCEDURE bdsoutou.cursex2()
BEGIN
  DECLARE fincurs1 BOOLEAN DEFAULT 0;
  DECLARE v_brevet VARCHAR(6);
  DECLARE v_nbHv   DECIMAL(7,2);
  DECLARE v_comp   VARCHAR(4);
 
  DECLARE curs1 CURSOR FOR 
	SELECT brevet,nbHVol,comp 
	FROM bdsoutou.Pilote WHERE comp = 'AF';
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET fincurs1 := 1;

  OPEN curs1;

  FETCH curs1 INTO v_brevet,v_nbHv,v_comp;
  WHILE (NOT fincurs1) DO 
	SELECT  v_brevet,v_nbHv;
	FETCH curs1 INTO v_brevet,v_nbHv,v_comp;  
  END WHILE;
  CLOSE curs1;
END;
$

CALL bdsoutou.cursex2()$

/* avec LOOP */

CREATE PROCEDURE bdsoutou.cursex3()
BEGIN
  DECLARE fincurs1 BOOLEAN DEFAULT 0;
  DECLARE v_brevet VARCHAR(6);
  DECLARE v_nbHv   DECIMAL(7,2);
  DECLARE v_comp   VARCHAR(4);
 
  DECLARE curs1 CURSOR FOR 
	SELECT brevet,nbHVol,comp 
	FROM bdsoutou.Pilote WHERE comp = 'AF';
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET fincurs1 := 1;

  OPEN curs1;

  boucle1: LOOP
    FETCH curs1 INTO v_brevet,v_nbHv,v_comp;
    IF (fincurs1) THEN
            LEAVE boucle1; 
    END IF;
    SELECT  v_brevet,v_nbHv;
  END LOOP;
  CLOSE curs1;
END;
$

CALL bdsoutou.cursex3()$

CREATE PROCEDURE bdsoutou.cursex4()
BEGIN
  DECLARE fincurs1 BOOLEAN DEFAULT 0;
  DECLARE v_nbHv   DECIMAL(7,2);
  DECLARE v_tot    DECIMAL(8,2) DEFAULT 0;
 
  DECLARE curs1 CURSOR FOR 
	SELECT nbHVol
	FROM bdsoutou.Pilote WHERE comp = 'AF';
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET fincurs1 := 1;

  OPEN curs1;

  REPEAT
    FETCH curs1 INTO v_nbHv;
    IF NOT fincurs1 THEN
	SET v_tot := v_tot+v_nbHv;
    END IF;
    UNTIL fincurs1 
  END REPEAT;
  CLOSE curs1;
  SELECT v_tot AS 'Total heures pour les pilotes de ''AF''';
END;
$

CALL bdsoutou.cursex4()$

CREATE PROCEDURE bdsoutou.cursex5()
BEGIN
  DECLARE fincurs1 BOOLEAN DEFAULT 0;
  DECLARE v_nbHv   DECIMAL(7,2);
  DECLARE v_tot    DECIMAL(8,2) DEFAULT 0;
 
  DECLARE curs1 CURSOR FOR 
	SELECT nbHVol
	FROM bdsoutou.Pilote WHERE comp = 'AF';
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET fincurs1 := 1;

  OPEN curs1;
  FETCH curs1 INTO v_nbHv;
  WHILE (NOT fincurs1) DO 
	SET v_tot := v_tot+v_nbHv;
	FETCH curs1 INTO v_nbHv;  
  END WHILE;
  CLOSE curs1;
  SELECT v_tot AS 'Total heures pour les pilotes de ''AF''';
END;
$
CALL bdsoutou.cursex5()$

CREATE PROCEDURE bdsoutou.cursex6()
BEGIN
  DECLARE fincurs1 BOOLEAN DEFAULT 0;
  DECLARE v_nbHv   DECIMAL(7,2);
  DECLARE v_tot    DECIMAL(8,2) DEFAULT 0;
 
  DECLARE curs1 CURSOR FOR 
	SELECT nbHVol
	FROM bdsoutou.Pilote WHERE comp = 'AF';
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET fincurs1 := 1;

  OPEN curs1;
  boucle1: LOOP
    FETCH curs1 INTO v_nbHv;
    IF (fincurs1) THEN
            LEAVE boucle1; 
    END IF;
    SET v_tot := v_tot+v_nbHv;
  END LOOP;
  CLOSE curs1;
  SELECT v_tot AS 'Total heures pour les pilotes de ''AF''';
END;
$
CALL bdsoutou.cursex6()$


/* solution avec une fonction
  ERROR 1415 (0A000): Not allowed to return a result set from a function
  c'est le SELECT  v_brevet,v_nbHv;
*/

DROP FUNCTION bdsoutou.cursex7$

CREATE FUNCTION bdsoutou.cursex7() RETURNS SMALLINT
LANGUAGE SQL READS SQL DATA 
BEGIN
  DECLARE fincurs1 BOOLEAN DEFAULT 0;
  DECLARE v_brevet VARCHAR(6);
  DECLARE v_nbHv   DECIMAL(7,2);
  DECLARE v_comp   VARCHAR(4);
  DECLARE v_nbpil  SMALLINT DEFAULT 0;

  DECLARE curs1 CURSOR FOR 
	SELECT brevet,nbHVol,comp 
	FROM bdsoutou.Pilote WHERE comp = 'AF';
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET fincurs1 := 1;

  OPEN curs1;

  FETCH curs1 INTO v_brevet,v_nbHv,v_comp;

  WHILE (NOT fincurs1) DO 
	SET v_nbpil  := v_nbpil+1;
--	SELECT  v_brevet,v_nbHv;
	FETCH curs1 INTO v_brevet,v_nbHv,v_comp;  
  END WHILE;

  CLOSE curs1;
  RETURN v_nbpil;
END;
$

SELECT bdsoutou.cursex7()$

/* FOR UPDATE */


CREATE PROCEDURE bdsoutou.cursex8()
BEGIN
  DECLARE fincurs BOOLEAN DEFAULT 0;
  DECLARE v_brevet VARCHAR(6);
  DECLARE v_nbHv   DECIMAL(7,2);
  DECLARE v_comp   VARCHAR(4);

  DECLARE curs CURSOR FOR 
	SELECT brevet,nbHVol,comp
	FROM bdsoutou.Pilote FOR UPDATE;
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET fincurs := 1;
  SET AUTOCOMMIT = 0;

  OPEN curs;
  FETCH curs INTO v_brevet,v_nbHv,v_comp;
  WHILE (NOT fincurs) DO 
	IF (v_comp='AF') THEN 
		UPDATE bdsoutou.Pilote SET nbHVol = nbHVol + 100
		WHERE brevet = v_brevet;
	ELSEIF (v_comp='SING') THEN 
	       UPDATE bdsoutou.Pilote SET nbHVol = nbHVol - 100 WHERE brevet = v_brevet;
	ELSE
               DELETE FROM bdsoutou.Pilote WHERE brevet = v_brevet;
	END IF;

	FETCH curs INTO v_brevet,v_nbHv,v_comp;  
  END WHILE;
  CLOSE curs;
 COMMIT;
END;
$

SELECT * FROM bdsoutou.pilote$

CALL bdsoutou.cursex8()$

SELECT * FROM bdsoutou.pilote$


CREATE PROCEDURE bdsoutou.cursex9(IN p_comp VARCHAR(4))
BEGIN
  DECLARE fincurs1 BOOLEAN DEFAULT 0;
--  DECLARE v_brevet VARCHAR(6);
  DECLARE v_nom    VARCHAR(20);
  DECLARE v_comp   VARCHAR(4);
  DECLARE v_nbHv   DECIMAL(7,2);
  DECLARE v_tot    DECIMAL(8,2) DEFAULT 0;
  DECLARE v_nbpil  SMALLINT DEFAULT 0;

  DECLARE curs1 CURSOR FOR 
	SELECT nom,nbHVol,comp 
	FROM bdsoutou.Pilote WHERE NOT (comp = p_comp);
 --  DECLARE CONTINUE HANDLER FOR SQLSTATE '02000' SET done = 1;

  DECLARE CONTINUE HANDLER FOR NOT FOUND SET fincurs1 := 1;

  OPEN curs1;

  REPEAT
    FETCH curs1 INTO v_nom,v_nbHv,v_comp;
    IF NOT fincurs1 THEN
       --
	SET v_nbpil  := v_nbpil+1;
	SELECT v_nom AS 'Nom',v_comp AS 'compagnie';
	SET v_tot := v_tot+v_nbHv;
    END IF;
    UNTIL fincurs1 
  END REPEAT;
  CLOSE curs1;
  SELECT CONCAT(v_nbpil,' pilotes pour ',v_tot,' heures',' pour compagnie diffrent de ',p_comp)
	 AS 'Total heures';
END;
$

CALL bdsoutou.cursex9('AF')$

CALL bdsoutou.cursex9('SING')$

delimiter ;