/* Index */

/*  Supression des index cle etrangere */

ALTER TABLE Pratique DROP INDEX idx_adhid_pratique;
ALTER TABLE Pratique DROP INDEX idx_spid_pratique;

/*  Supression des index cl primaire */

ALTER TABLE Sport    DROP PRIMARY KEY ;
ALTER TABLE Adherent DROP PRIMARY KEY;

SHOW INDEX FROM Adherent FROM bdsoutou;
SHOW INDEX FROM Sport FROM bdsoutou;
SHOW INDEX FROM Pratique FROM bdsoutou;

/*  division tous les sports */

SELECT a.civilite, a.prenom, a.nom, a.tel 
FROM Adherent a
   WHERE NOT EXISTS
    (SELECT spid FROM Sport
      WHERE spid NOT IN
      (SELECT spid FROM Pratique WHERE adhid = a.adhid))
    AND NOT EXISTS
       (SELECT spid FROM Pratique WHERE adhid = a.adhid
           AND spid NOT IN
           (SELECT spid FROM Sport));

/*  index cls primaires */

ALTER TABLE Sport
      ADD CONSTRAINT pk_Sport PRIMARY KEY (spid);
ALTER TABLE Adherent
      ADD CONSTRAINT pk_Adherent PRIMARY KEY (adhid);

/*  index cls trangres */

CREATE INDEX idx_adhid_pratique
    USING BTREE 
    ON Pratique (adhid)
    COMMENT 'numro adhrent - cl trangre';

CREATE INDEX idx_spid_pratique
    USING BTREE 
    ON Pratique (spid)
    COMMENT 'numro sport - cl trangre';

SHOW INDEX FROM Sport    FROM bdsoutou;
SHOW INDEX FROM Adherent FROM bdsoutou;
SHOW INDEX FROM Pratique FROM bdsoutou;

ANALYZE NO_WRITE_TO_BINLOG TABLE 
        Adherent,Pratique,Sport;

/* index pas utilis sur une expression */ 

EXPLAIN
SELECT adhid, nom, tel
     FROM  Adherent
     WHERE prenom = 'JENIFER' OR prenom = 'CELINE';

CREATE INDEX idx_prenom_adherent
    USING BTREE 
    ON Adherent (prenom);

EXPLAIN
SELECT adhid, nom, tel
     FROM  Adherent
     WHERE prenom = 'JENIFER' OR prenom = 'CELINE';

EXPLAIN
SELECT adhid, nom, tel
     FROM  Adherent
     WHERE UPPER(prenom) = 'JENIFER' 
     OR    UPPER(prenom) = 'CELINE';

ALTER TABLE Adherent
      DROP INDEX idx_prenom_adherent;


/* index hash */ 

ALTER TABLE Adherent ENGINE = MEMORY;

ALTER TABLE Adherent
      ADD CONSTRAINT pk_Adherent 
      PRIMARY KEY (adhid);

CREATE INDEX idx_btree_adhid
    USING BTREE
    ON Adherent (adhid);

SHOW INDEX FROM Adherent FROM bdsoutou;

EXPLAIN
SELECT adhid, nom, tel, prenom, civilite
     FROM  Adherent
     WHERE adhid=5674;

EXPLAIN
SELECT adhid, nom, tel, prenom, civilite
     FROM  Adherent
     WHERE adhid>5674 AND adhid<17890;

EXPLAIN
SELECT adhid, nom, tel, prenom, civilite
     FROM  Adherent
     WHERE adhid>5674;

EXPLAIN
SELECT adhid, nom, tel, prenom, civilite
     FROM  Adherent
     WHERE adhid IN (5674,34,56,790,25999);

EXPLAIN
SELECT adhid, nom, tel, prenom, civilite
     FROM  Adherent
     WHERE adhid NOT IN (5674,34,56,790,25999);

ALTER TABLE Adherent
      DROP INDEX idx_btree_adhid;

ALTER TABLE Adherent ENGINE = InnoDB;

/*  Supression des index cle etrangere */

ALTER TABLE Pratique DROP INDEX idx_adhid_pratique;
ALTER TABLE Pratique DROP INDEX idx_spid_pratique;

/*  Supression des index cl primaire */

ALTER TABLE Sport    DROP PRIMARY KEY ;
ALTER TABLE Adherent DROP PRIMARY KEY;

SHOW INDEX FROM Adherent FROM bdsoutou;
SHOW INDEX FROM Sport FROM bdsoutou;
SHOW INDEX FROM Pratique FROM bdsoutou;

ANALYZE NO_WRITE_TO_BINLOG TABLE 
        Sport,Pratique,Adherent;

/* NULLs */
			
EXPLAIN
SELECT   COUNT(nom) 
   FROM  Adherent 
   WHERE tel IS NULL;

EXPLAIN
SELECT   COUNT(nom) 
   FROM  Adherent 
   WHERE tel ='06-63-71-28-54';

EXPLAIN
SELECT   COUNT(nom) 
   FROM  Adherent 
   WHERE tel IS NOT NULL;

CREATE INDEX idx_tel_btree
  USING BTREE
  ON Adherent (tel);

SELECT ISNULL(NULL), ISNULL(0), ISNULL(1);
SELECT IFNULL(NULL,'a'), IFNULL(0,'b');

ALTER TABLE Adherent
      DROP INDEX idx_tel_btree;

/* multi colonnes */

SHOW INDEX FROM Adherent FROM bdsoutou;

ANALYZE NO_WRITE_TO_BINLOG TABLE Adherent;


CREATE INDEX idx_nompretel_btree
  USING BTREE
  ON Adherent (nom, prenom(18), tel);

CREATE INDEX idx_telnom_btree
  USING BTREE
  ON Adherent (tel,nom);

EXPLAIN
SELECT adhid, civilite, nom, tel
     FROM  Adherent
     WHERE nom LIKE 'LARR%';

EXPLAIN
SELECT adhid, civilite, nom, tel
     FROM  Adherent
     WHERE nom LIKE 'LARR%' AND tel='08-31-48-45-65';

/* sans index */

EXPLAIN
SELECT adhid, civilite, nom, tel
     FROM  Adherent
     WHERE nom LIKE '%LARR%' 
     AND tel LIKE '%08%';

EXPLAIN
SELECT adhid, civilite, nom, tel
     FROM  Adherent
     WHERE nom LIKE '%LARR%' 
     OR    tel LIKE '%08%';

/* destruction index */

ALTER TABLE Adherent
      DROP INDEX idx_telnom_btree;

ALTER TABLE Adherent
      DROP INDEX idx_nompretel_btree;

/* fulltext */

DROP TABLE forums_MySQL;

CREATE TABLE forums_MySQL
(
  entryID INT(9) UNSIGNED NOT NULL AUTO_INCREMENT,
  titre   VARCHAR(80) NOT NULL,
  texte   TEXT NOT NULL,
  PRIMARY KEY (entryID)
)  ENGINE=MyISAM;


INSERT INTO forums_MySQL (titre,texte)
  VALUES ('ORDER BY [une certaine valeur en 1er]'
         ,'Bonjour,
Jai une suite de donnes toute simple :
J\'aimerais classer tout a par ordre alphabtique MAIS avec une certaine valeur, ici \'Jean\', en tte de liste... c\'est--dire obtenir :
MySQL permet-il de faire ceci en une seule requte ?
Ou alors dois-utiliser PHP pour faire mes tris sur la page ? (j\'aimerais que non, car PHP gre dj la pagination des rsultats). Je n\'aimerais pas non plus faire 2 listes de rsultats en utilisant 2 requtes...
N\'y aurait-il pas une possibilit d\'crire qqch comme a (je sais bien que non, mais...) :
Code :
SELECT name FROM people ORDER BY [name = \'Jean\'], name ASC
Avec tous mes remerciements 
');

INSERT INTO forums_MySQL (titre,texte)
  VALUES ('gerer une erreur de script sur un DROP USER ou un REVOKE'
         ,
          'C\'est pas encore cela
mysql -u root -p</tmp/essai.sql
Code :
le fichier essai.sql
 
IF EXISTS(SELECT User FROM mysql.USER WHERE User=\'user1\') THEN
DELETE FROM mysql.USER WHERE user=\'user1\' AND host=\'localhost\';
FLUSH PRIVILEGES;
DROP USER \'user1\'@\'localhost\';  
END IF;
 
celui ci nonplus ?
IF EXISTS(SELECT user FROM mysql.user WHERE user=\'user1\') THEN
DROP user \'user1\'@\'localhost\'; ');


INSERT INTO forums_MySQL (titre,texte)
  VALUES ('Variables dans un trigger'
         ,
          '
Bonjour  tous,
Je suis en train de crer un trigger qui devra insrer des informations dans une table, lors de diffrentes modifications apport  d\'autres tables, jusque l rien de bien compliqu.
Mon problme est que cela fait peu de temps que j\'utilise les dclencheurs et j\'ai un soucie, car je ne sait pas trs bien comment dclarer et affecter des variables.
Dans mon cas je souhaite dclarer deux variable, qui reoivent le rsultat de requtes "COUNT".
Code :
delimiter //
CREATE TRIGGER mon_trigger AFTER INSERT INTO ma_table3
FOR EACH ROW
BEGIN
    DECLARE cpt1 INT;
    DECLARE cpt2 INT;
    SET cpt1 = SELECT COUNT(id_table1)
                    FROM table1
                    WHERE ... ;
');


INSERT INTO forums_MySQL (titre,texte)
  VALUES ('Gestion d\'exception dans une procdure stocke'
         ,
          'Toutes les nuits, je recharge dans MySQL 5.0.81 en mode batch, via des procdures stockes plusieurs tables. Si une procdure tombe en erreur, se sont tous mes rapports d\'analyse qui sont dans les choux le matin.
L\'objectif serait de grer une exception lors une requte tombe en erreur sans pour autant arrter le batch et tracer dans une autre table l\'erreur (ventuellement le code de l\'erreur) pour que le matin je puisse rapidement trouver l\'erreur
Voici la procdure que j\'ai imagin (simplifi) mais qui ne fonctionne pas comme je voudrais :
Code :
DROP PROCEDURE IF EXISTS sp1;
DELIMITER $$
-- 
CREATE PROCEDURE sp1()
BEGIN
 DECLARE EXIT HANDLER FOR SQLEXCEPTION
  BEGIN
	CREATE TABLE `ra_0002` ENGINE = MYISAM CHARACTER SET latin1 COLLATE latin1_general_ci AS
	SELECT un_champ FROM ma_table;
  END;
	INSERT INTO job (Proc_sto,DateTime) VALUES (\'sp1\',CURRENT_TIMESTAMP());
END$$
-- 
DELIMITER ;
Lorsque je call cette procdure, la table ra_0002 est bien cre mais l\'exception est aussi leve et un enregistrement est rajout dans la table job. Si je remplace un_champ par un_champ_qui_n_existe_pas la table n\'est pas cre et un enregistrement est rajout dans la table job.
Comment faut-il faire pour que seulement en cas d\'erreur il rajoute un enregistrement dans la table job sans stopper l\'excution de la procdure ?
Quelle est l\'influence du paramtre SQLEXCEPTION ? je n\'ai rien trouv sur le net.
');


INSERT INTO forums_MySQL (titre,texte)
  VALUES ('Une valeur par dfaut pour un paramtre de procdure stockes'
         ,
       'Voil mon petit problme, j\'ai une procdure stocke a qui je souhaiterai mettre un paramtre (le dernier) avec une valeur par dfaut. L\'intrt est tout simple, c\'est pour appel cette procdure de deux manires diffrentes, avec le dernier paramtres ou sans. Exemple :

Code :
CALL maprocedure("mon@email.com","monpass",1);
CALL maprocedure("mon@email.com","monpass");
Si quelqu\'un avait une petite ide ce serait gnial , j\'ai pas trouv dans la doc de renseignement dessus et j\'ai essay ma procdure avec ceci:
Code :
CREATE PROCEDURE `maprocedure`(IN param1 VARCHAR(30), IN param2 VARCHAR(30), IN param3 TINYINT DEFAULT 0) [....]

Mais rien du tout, juste le ronchonnement du soft ^^

Merci de votre aide!'
 );

INSERT INTO forums_MySQL (titre,texte)
  VALUES ('requete imbrique sur une meme table'
         ,
       'Bonjour,
je cale sur une requete SQL.
C\'est une requete avec des sous requetes sur la meme table, je me demande s\'il n\'est pas possible de faire des jointures plutt que des select imbriqus, qui affectent fortement les performances.
Plus concrtement, c\'est pour un script de "forum maison"; en gros un forum  un id, et un parent_id s\'il s\'agit d\'un sous forum. On pourrait schmatiser mon arborescence comme ci dessous

forum 1
--sous forum 1.1
--sous forum 1.2
--sous forum 1.3
--sous forum 2.1
--sous forum 2.2
------sous forum 2.2.1
------sous forum 2.2.3
forum 2
etc
3 niveaux donc.
J\'aimerai que le forum 1 affiche les topics de tous ses sous forums.
Ca me donne des requetes avec des SELECT imbriqu ainsi:
Code :
 SELECT * FROM topics 
WHERE forum_id IN 
(SELECT id FROM forums WHERE id=1 OR parent_forum_id=1 OR id IN (SELECT parent_forum_id FROM forums WHERE parent_forum_id=1))
edit: (ma requette ci dessus est fausse la partie
Code :
OR id IN (SELECT parent_forum_id FROM forums WHERE parent_forum_id=1))
est bidon. )'
 );

INSERT INTO forums_MySQL (titre,texte)
  VALUES ('probleme syntaxe avec alias de table'
         ,
       'Bonsoir
J\'ai un petit soucis, ma base me rponds que "Every derived table must have its own alias ", sauf que l je vois pas quel alias manque. Quelqu\'un peut me prter ses lunettes?
Code :
SELECT
	m.idmembre,
	m.prenom AS \'prnom\',
	m.nom,
	m.connu,
	COUNT(x1.idparticipation) AS \'nombre pointage\',
	COUNT(i1.idinscription) AS \'nombre pointage\',
	SUM( IF( joursemaine = 2, 1, 0 ) ) AS \'Lundi\',
	SUM( IF( joursemaine = 3, 1, 0 ) ) AS \'Mardi\',
	SUM( IF( joursemaine = 4, 1, 0 ) ) AS \'Mercredi\',
	SUM( IF( joursemaine = 5, 1, 0 ) ) AS \'Jeudi\',
	SUM( IF( joursemaine = 6, 1, 0 ) ) AS \'Vendredi\',
	SUM( IF( joursemaine = 7, 1, 0 ) ) AS \'Samedi\',
	SUM( IF( joursemaine = 1, 1, 0 ) ) AS \'Dimanche\'
FROM gestion_membre AS m
	LEFT JOIN gestion_participation AS x1 ON x1.idmembre = m.idmembre
	INNER JOIN
	(
		SELECT
			s2.idsession,
			s2.date_session,
			DAYOFWEEK(s2.date_session) AS joursemaine,
			s2.idplanning
		FROM gestion_session AS s2
		WHERE   "2010-08-01 00:00:00" <= s2.date_session AND s2.date_session <= "2011-08-01 00:00:00" 
	) AS s1 ON x1.idsession = s1.idsession
	LEFT JOIN
	(
		SELECT
			i2.idinscription,
			i2.idmembre,
			i2.idplanning,
			i2.carte
		FROM gestion_inscription AS i2
		WHERE  "2010-08-01 00:00:00" <= i2.date_debut AND i2.date_debut <= "2011-08-01 00:00:00" )
	) AS i1 ON i1.idmembre = m.idmembre
GROUP BY m.idmembre
merci '
 );


INSERT INTO forums_MySQL (titre,texte)
  VALUES ('Insert ou Update probleme avec on duplicate key'
         ,
       'Bonjour a tous,
J\'ai une requte html simple de remplissage de table avec un formulaire.
Je me sert d\'un formulaire pour remplir ma table et j\'ai fait en sorte que lorsque des donne on dj t indiqu dans le formulaire qu\'elle reaparaise dans les value="" de mes champs de formulaire.
J\'aimerai faire en sorte que si on modifie un de ces champs preremplis que cela fasse un UPDATE et que si le champs etai vide que cela fasse un INSERT.
Je pense que on duplicate key peux rpondre a mes attentes mais cela ne semble pas fonctionner.
Voici ma requte a l\'heure actuelle
Code :
mysql_query("INSERT INTO fiches_membres (genre, nom, prenom, texte_travail, id_membre) 
		VALUES(\'$genre\',\'$nom\',\'$prenom\',\'$texte_travail\', \'$id\')") OR die (mysql_error()); 
Merci par avance pour le coup de main '
 );


CREATE FULLTEXT INDEX idx_forums_MySQL
       ON forums_MySQL (titre,texte);

show CREATE TABLE forums_MySQL;
show INDEX FROM forums_MySQL;

SELECT entryID, titre , texte  
     FROM forums_MySQL;

SELECT entryID, titre    
     FROM forums_MySQL 
     WHERE MATCH (titre,texte) AGAINST ('SELECT' IN BOOLEAN MODE);

SELECT entryID, titre    
     FROM forums_MySQL 
     WHERE MATCH (titre,texte) AGAINST ('SELECT' IN NATURAL LANGUAGE MODE);

--> prsent dans + de 50% des lignes

SELECT entryID, titre, 
       MATCH (titre,texte) AGAINST ('SELECT INSERT' IN NATURAL LANGUAGE MODE) AS score   
     FROM forums_MySQL 
     WHERE MATCH (titre,texte) AGAINST ('SELECT INSERT' IN NATURAL LANGUAGE MODE)
      ORDER BY score DESC;

SELECT entryID, titre, 
       MATCH (titre,texte) AGAINST ('+SELECT +DELETE' IN NATURAL LANGUAGE MODE) AS score   
     FROM forums_MySQL 
     WHERE MATCH (titre,texte) AGAINST ('+SELECT +DELETE' IN NATURAL LANGUAGE MODE)
      ORDER BY score DESC;

SELECT entryID, titre, 
       MATCH (titre,texte) AGAINST ('+SELECT PROCEDURE' IN NATURAL LANGUAGE MODE) AS score   
     FROM forums_MySQL 
     WHERE MATCH (titre,texte) AGAINST ('+SELECT PROCEDURE' IN NATURAL LANGUAGE MODE)
      ORDER BY score DESC;

SELECT entryID, titre,
     MATCH (titre,texte) AGAINST ('+UPDATE -PROCEDURE' IN NATURAL LANGUAGE MODE) AS score
     FROM forums_MySQL 
     WHERE MATCH (titre,texte) AGAINST ('+UPDATE -PROCEDURE' IN NATURAL LANGUAGE MODE);


SELECT entryID, titre, 
       MATCH (titre,texte) AGAINST ('+SELECT ~INSERT' IN NATURAL LANGUAGE MODE) AS score   
     FROM forums_MySQL 
     WHERE MATCH (titre,texte) AGAINST ('+SELECT ~INSERT' IN NATURAL LANGUAGE MODE)
      ORDER BY score DESC;


SELECT entryID, titre, 
       MATCH (titre,texte) AGAINST ('+SELECT +(>UPDATE <PROCEDURE)' IN NATURAL LANGUAGE MODE) AS score   
     FROM forums_MySQL 
     WHERE MATCH (titre,texte) AGAINST ('+SELECT +(>UPDATE <PROCEDURE)' IN NATURAL LANGUAGE MODE)
      ORDER BY score DESC;

SELECT entryID, titre, 
       MATCH (titre,texte) AGAINST ('"CREATE T*"' IN NATURAL LANGUAGE MODE) AS score   
     FROM forums_MySQL 
     WHERE MATCH (titre,texte) AGAINST ('"CREATE T*"' IN NATURAL LANGUAGE MODE)
      ORDER BY score DESC;

/* */

