
/* dnormalisation */

/* Ajout de colonnes calcules */

ALTER TABLE Sport
    ADD COLUMN nb_adherents SMALLINT UNSIGNED NOT NULL DEFAULT 0;

UPDATE Sport s
 SET s.nb_adherents = (SELECT COUNT(p.adhid) FROM Pratique p WHERE p.spid=s.spid); 

ALTER TABLE Adherent 
    ADD COLUMN nb_sports TINYINT UNSIGNED NOT NULL DEFAULT 0;

UPDATE Adherent a
 SET a.nb_sports = (SELECT COUNT(p.adhid) FROM Pratique p WHERE p.adhid=a.adhid); 

SHOW INDEX FROM Sport    FROM bdsoutou;
SHOW INDEX FROM Adherent FROM bdsoutou;
SHOW INDEX FROM Pratique FROM bdsoutou;

ANALYZE NO_WRITE_TO_BINLOG TABLE Adherent,Pratique,Sport;

/* requetes */

EXPLAIN
SELECT splibelle, nb_adherents
   FROM Sport
   WHERE splibelle IN ('Natation','Moto','Football');

EXPLAIN
SELECT   s.splibelle, COUNT(p.adhid)
   FROM  Sport s,Pratique p
   WHERE s.splibelle IN ('Natation','Moto','Football')
   AND   s.spid = p.spid
   GROUP BY s.splibelle;

EXPLAIN
SELECT   adhid,nom,prenom,tel,civilite, nb_sports
   FROM  Adherent
   WHERE nb_sports > 4
   AND  tel LIKE '06-%' AND civilite <> 'Mr.'
   ORDER BY nom;

EXPLAIN
SELECT   a.adhid,a.prenom,a.nom,a.tel,a.civilite,COUNT(p.spid) AS "nb_sports"
   FROM  Adherent a, Pratique p
   WHERE a.adhid = p.adhid
   AND   a.tel LIKE '06-%' AND a.civilite <> 'Mr.'
   GROUP BY a.adhid,a.prenom,a.nom,a.tel,a.civilite
   HAVING COUNT(p.spid)>4   
   ORDER BY a.nom;


/* Duplication de colonnes */

DROP TABLE temp3;
CREATE TEMPORARY TABLE temp3 AS
SELECT s.splibelle, a.nom, a.prenom, a.tel, a.civilite, a.date_nais, a.nb_sports
      FROM  Pratique p, Sport s, Adherent a
      WHERE p.spid=s.spid
      AND   p.adhid=a.adhid
      AND s.splibelle IN ('Tennis','Volley','Hand-ball');

EXPLAIN
SELECT   splibelle,nom,prenom,tel,civilite
   FROM  temp3 
   WHERE nb_sports > 3
   AND  tel LIKE '06-%' AND civilite <> 'Mr.'
   ORDER BY splibelle,nom;

EXPLAIN
SELECT   s.splibelle,a.nom,a.prenom,a.tel,a.civilite
   FROM  Adherent a, Pratique p, Sport s
   WHERE a.adhid = p.adhid
   AND   p.spid  = s.spid
   AND   a.tel LIKE '06-%' AND a.civilite <> 'Mr.'
   AND   s.splibelle IN ('Tennis','Volley','Hand-ball')
   AND   EXISTS  
         (SELECT p2.adhid 
           FROM Pratique p2
           WHERE p2.adhid = a.adhid
           GROUP BY p2.adhid 
           HAVING COUNT(p2.spid)>3)
   GROUP BY s.splibelle,a.nom,a.prenom,a.tel,a.civilite  
   ORDER BY s.splibelle,a.nom;

/* Ajout de cl trangre */

CREATE TABLE Adresse
   (adr_id SMALLINT AUTO_INCREMENT PRIMARY KEY,
    ADR_LIGNE1 VARCHAR(32) NOT NULL,
    ADR_LIGNE2 VARCHAR(32),
    ADR_LIGNE3 VARCHAR(32),
    ADR_LIGNE4 VARCHAR(32),
    ADR_CP     CHAR(5) NOT NULL,
    ADR_VILLE  CHAR(32) NOT NULL);

ALTER TABLE Adherent ADD adr_id SMALLINT;

/*  Supression des index  */

ALTER TABLE Pratique DROP INDEX idx_adhid_pratique;
ALTER TABLE Pratique DROP INDEX idx_spid_pratique;
ALTER TABLE Sport    DROP PRIMARY KEY ;
ALTER TABLE Adherent DROP PRIMARY KEY;
ANALYZE NO_WRITE_TO_BINLOG TABLE Adherent,Pratique,Sport;

/* Ajout index */

ALTER TABLE Sport
      ADD CONSTRAINT pk_Sport PRIMARY KEY (spid);
ALTER TABLE Adherent
      ADD CONSTRAINT pk_Adherent PRIMARY KEY (adhid);
CREATE INDEX idx_adhid_pratique
    USING BTREE 
    ON Pratique (adhid)
    COMMENT 'numro adhrent - cl trangre';
CREATE INDEX idx_spid_pratique
    USING BTREE 
    ON Pratique (spid)
    COMMENT 'numro sport - cl trangre';

ANALYZE NO_WRITE_TO_BINLOG TABLE Adherent,Pratique,Sport;

SELECT COUNT(*) "Nombre de sports" FROM Sport s;
SELECT COUNT(*) "Nombre d'adherents" FROM Adherent a;
SELECT COUNT(*) "Nombre d'inscriptions" FROM Pratique p;

SELECT COUNT(DISTINCT(prenom)) "Nombre de prenoms distincts" FROM Adherent;
SELECT COUNT(DISTINCT(tel)) "Nombre de tel distincts" FROM Adherent;
SELECT COUNT(*) "Nombre de tel nuls" FROM Adherent WHERE tel IS NULL;


DROP TABLE IF EXISTS Pratique;
DROP TABLE IF EXISTS Adherent ;
DROP TABLE IF EXISTS Sport;