
CREATE TABLE Trajets
	(dpart VARCHAR2(10), arrive VARCHAR2(10), tempsVol NUMBER(5,2));

INSERT INTO Trajets VALUES ('Paris', 'Blagnac', 1);
INSERT INTO Trajets VALUES ('Paris', 'Lyon', 0.8);
INSERT INTO Trajets VALUES ('Paris', 'Marseille', 0.9);
	INSERT INTO Trajets VALUES ('Blagnac', 'Pau', 0.4);
	INSERT INTO Trajets VALUES ('Lyon', 'Grenoble', 0.3);
	INSERT INTO Trajets VALUES ('Lyon', 'Valence', 0.2);
		INSERT INTO Trajets VALUES ('Grenoble', 'Gap', 0.35);
		INSERT INTO Trajets VALUES ('Valence', 'Ales', 0.25);
	INSERT INTO Trajets VALUES ('Marseille', 'Frejus', 0.2);
	INSERT INTO Trajets VALUES ('Marseille', 'Toulon', 0.15);
	INSERT INTO Trajets VALUES ('Marseille', 'Nimes', 0.35);


SELECT * FROM Trajets;


--bas en haut
SELECT LEVEL,arrive,dpart,tempsVol 
FROM Trajets
START WITH dpart='Paris'
CONNECT BY PRIOR dpart = arrive;

--haut en bas de Lyon
SELECT LEVEL, dpart, arrive, tempsVol 
FROM Trajets
START WITH dpart='Lyon'
CONNECT BY PRIOR  arrive =dpart;

--mise en forme : indentation
COLUMN DepartParis FORMAT A15
SELECT LPAD(' ',4*LEVEL-4)||arrive DepartParis, tempsVol
FROM Trajets
START WITH dpart='Paris'
CONNECT BY PRIOR arrive = dpart;

--lagage 
--sans Lyon
COLUMN DepartParis FORMAT A15
SELECT LPAD(' ',4*LEVEL-4)||arrive DepartParis, tempsVol
FROM Trajets
WHERE NOT (dpart = 'Lyon' OR arrive = 'Lyon')
START WITH dpart='Paris'
CONNECT BY PRIOR arrive = dpart;

--sans l'arborescence sous Lyon
COLUMN DepartParis FORMAT A15
SELECT LPAD(' ',4*LEVEL-4)||arrive DepartParis, tempsVol
FROM Trajets
START WITH dpart='Paris'
CONNECT BY PRIOR arrive = dpart
AND NOT dpart = 'Lyon';

--sans l'arborescence sous Lyon et sans Lyon
COLUMN DepartParis FORMAT A15
SELECT LPAD(' ',4*LEVEL-4)||arrive DepartParis, tempsVol
FROM Trajets
WHERE NOT (arrive = 'Lyon')
START WITH dpart='Paris'
CONNECT BY PRIOR arrive = dpart
AND NOT dpart = 'Lyon';

--Join

DROP TABLE Aroports;
CREATE TABLE Aroports
(nomAero VARCHAR2(10), frequenceTWR NUMBER(6,3));

INSERT INTO  Aroports VALUES ('Blagnac', 118.10);
INSERT INTO  Aroports VALUES ('Paris', 123.40);
INSERT INTO  Aroports VALUES ('Lyon', 123.80);
INSERT INTO  Aroports VALUES ('Marseille', 118.70);
INSERT INTO  Aroports VALUES ('Pau', 117.90);
INSERT INTO  Aroports VALUES ('Grenoble', 115.60);
INSERT INTO  Aroports VALUES ('Valence', 126.90);
INSERT INTO  Aroports VALUES ('Gap', 122.70);
INSERT INTO  Aroports VALUES ('Ales', 120.30);
INSERT INTO  Aroports VALUES ('Frejus', 114.70);
INSERT INTO  Aroports VALUES ('Toulon', 119.90);
INSERT INTO  Aroports VALUES ('Nimes', 126.20);


SELECT LPAD(' ',4*LEVEL-4)||arrive DepartParis, tempsVol, frequenceTWR 
FROM Trajets, Aroports 
WHERE NOT (arrive = 'Lyon') AND arrive = nomAero 
START WITH dpart='Paris'
CONNECT BY PRIOR arrive = dpart
AND NOT dpart = 'Lyon';

--ORDRE
COLUMN DepartParis FORMAT A15
SELECT LPAD(' ',4*LEVEL-4)||arrive DepartParis, tempsVol
FROM Trajets
START WITH dpart='Paris'
CONNECT BY PRIOR arrive = dpart
ORDER SIBLINGS BY arrive DESC;



DROP TABLE Aroports;
DROP TABLE Trajets;
