
delimiter $

CREATE TABLE Compagnie
(comp VARCHAR(4), nrue INT(3), rue VARCHAR(20), ville VARCHAR(15), nomComp VARCHAR(15),
 CONSTRAINT pk_Compagnie PRIMARY KEY(comp))$

CREATE TABLE Pilote
	(brevet VARCHAR(6), nom CHAR(20), nbHVol DECIMAL(7,2), compa VARCHAR(4),
	 CONSTRAINT pk_Pilote PRIMARY KEY(brevet),
	 CONSTRAINT fk_Pil_compa_Comp FOREIGN KEY(compa) REFERENCES Compagnie(comp))$

INSERT INTO Compagnie	VALUES ('AF', 124, 'Port Royal', 'Paris', 'Air France')$
INSERT INTO Compagnie   VALUES ('SING', 7, 'Camparols', 'Singapour', 'Singapore AL')$
INSERT INTO Compagnie   VALUES ('CAST', 1, 'G. Brassens', 'Blagnac', 'Castanet AL')$

INSERT INTO Pilote VALUES ('PL-1', 'Gratien Viel', 450, 'AF')$
INSERT INTO Pilote VALUES ('PL-2', 'Didier Donsez', 0, 'AF')$
INSERT INTO Pilote VALUES ('PL-3', 'Richard Grin', 1000, 'SING')$
INSERT INTO Pilote VALUES ('PL-4', 'Placide Fresnais', 2450, 'CAST');
INSERT INTO Pilote VALUES ('PL-5', 'Daniel Vielle', NULL, 'AF')$

SELECT compa FROM Pilote WHERE brevet='PL-2'$

SET @vs_compa=''$
SELECT compa INTO @vs_compa FROM Pilote WHERE brevet='PL-2'$
SELECT @vs_compa$


SET @vs_compa=''$

DROP PROCEDURE sp1$
CREATE PROCEDURE sp1()
BEGIN
SELECT compa INTO @vs_compa FROM Pilote WHERE brevet='PL-2';		
END;
$
CALL sp1()$

SELECT @vs_compa$


DROP PROCEDURE sp1$
CREATE PROCEDURE sp1()
BEGIN
DECLARE v_comp VARCHAR(15);
SELECT compa INTO v_comp FROM Pilote WHERE brevet='PL-2';
SELECT v_comp ;		
END;
$
CALL sp1()$

SELECT compa FROM Pilote WHERE brevet='PL-2'$
SET @vs_compa=''$

SELECT compa INTO @vs_compa FROM Pilote$
SELECT @vs_compa$

SET @vs_compa=''$
SELECT compa INTO @vs_compa FROM Pilote WHERE brevet='PL-9'$
SELECT @vs_compa$

DROP PROCEDURE sp1$
CREATE PROCEDURE sp1()
BEGIN
DECLARE v_comp VARCHAR(15);
SELECT compa INTO v_comp FROM Pilote WHERE brevet='PL-9';
SELECT v_comp ;		
END;
$
CALL sp1()$


SELECT * FROM Pilote WHERE brevet='PL-1'$

DROP PROCEDURE sp1$
CREATE PROCEDURE sp1()
BEGIN
DECLARE v_nomEnMAJUSCULES CHAR(20); 
SELECT UPPER(nom) INTO v_nomEnMAJUSCULES
  FROM Pilote WHERE brevet = 'PL-1';
SELECT v_nomEnMAJUSCULES  ;	
END;
$
CALL sp1()$

SET @vs_plusGrandHVol=''$
SELECT MAX(nbHVol) INTO @vs_plusGrandHVol 
  FROM Pilote$
SELECT @vs_plusGrandHVol $	


DROP PROCEDURE sp1$
CREATE PROCEDURE sp1()
BEGIN
DECLARE v_plusGrandHVol DECIMAL(7,2); 
SELECT MAX(nbHVol) INTO v_plusGrandHVol FROM Pilote;
SELECT v_plusGrandHVol ;	
END;
$
CALL sp1()$

DROP PROCEDURE sp1$
CREATE PROCEDURE sp1()
BEGIN
 DECLARE v_brevet VARCHAR(6) DEFAULT 'PL-7';
 DECLARE v_nom    VARCHAR(20);
 DECLARE v_HVol   DECIMAL(7,2) DEFAULT 0; 
 DECLARE v_comp   VARCHAR(6);
 INSERT INTO Pilote VALUES ('PL-6', 'Jules Ente', 3000, 'AF');	
 SET v_nom  := 'Fabrice Peyrard';
 SET v_comp := 'SING';
 INSERT INTO Pilote VALUES (v_brevet,v_nom,v_HVol,v_comp);
END;
$
CALL sp1()$

SELECT * FROM Pilote$

DROP PROCEDURE sp1$
CREATE PROCEDURE sp1()
BEGIN
 DECLARE v_dureeVol DECIMAL(3,1) DEFAULT 4.8; 
 UPDATE Pilote SET nbHVol= nbHVol + v_dureeVol WHERE brevet= 'PL-6';
 UPDATE Pilote SET nbHVol= nbHVol + 10 WHERE  compa = 'AF';
END;
$
CALL sp1()$

SELECT * FROM Pilote$

DROP PROCEDURE sp1$
CREATE PROCEDURE sp1()
BEGIN
 DECLARE v_hVolMini DECIMAL(7,2) DEFAULT 1000.00; 
 DELETE FROM Pilote WHERE nbHVol < v_hVolMini;
 DELETE FROM Pilote WHERE brevet = 'PL-3';
 DELETE FROM Pilote WHERE brevet = NULL;
END;
$
CALL sp1()$

SELECT * FROM Pilote$

DROP PROCEDURE sp1$
DROP TABLE Pilote$
DROP TABLE Compagnie$

delimiter ;