
delimiter $

CREATE PROCEDURE bdsoutou.exsignal1(IN p_brevet VARCHAR(6))
BEGIN
  DECLARE v_nbHv   DECIMAL(7,2);
  DECLARE v_comp   VARCHAR(4);
  DECLARE pilote_trop_bleu CONDITION FOR SQLSTATE '45000';
 
  SELECT comp,nbHVol INTO v_comp,v_nbHv FROM bdsoutou.Pilote WHERE brevet = p_brevet;
  IF (v_nbHv < 1000) THEN
       SIGNAL pilote_trop_bleu 
            SET MESSAGE_TEXT='Pilote trop peu experimente.',
                MYSQL_ERRNO = 9001,
                SCHEMA_NAME='bdsoutou',
                TABLE_NAME='Pilote',
                COLUMN_NAME='nbHVol';
   ELSEIF (v_comp != 'AF') THEN
       SIGNAL SQLSTATE '01000'
            SET MESSAGE_TEXT = 'Warning, pas Air France', 
                MYSQL_ERRNO = 9000,
                SCHEMA_NAME='bdsoutou',
                TABLE_NAME='Pilote',
                COLUMN_NAME='comp';
       ELSE
            SELECT p_brevet,v_nbHv,v_comp;
   END IF; 
END;
$

CALL bdsoutou.exsignal1('PL-5')$
SHOW ERRORS$
CALL bdsoutou.exsignal1('PL-6')$
SHOW WARNINGS$
CALL bdsoutou.exsignal1('PL-1')$

CREATE PROCEDURE bdsoutou.exsignal2(IN p_brevet VARCHAR(6))
BEGIN
  DECLARE v_flag TINYINT DEFAULT 0;
  DECLARE CONTINUE HANDLER 
-- (idem)    FOR SQLWARNING SET v_flag = 1;
          FOR SQLSTATE '01000' SET v_flag = 1;
  DECLARE CONTINUE HANDLER 
          FOR SQLSTATE VALUE '45000' SET v_flag = 2;

  CALL bdsoutou.exsignal1(p_brevet);
   CASE 
   WHEN v_flag=0 THEN SET v_flag = 0; /* Rien  faire */
   WHEN v_flag=1 THEN SHOW WARNINGS;
   WHEN v_flag=2 THEN SHOW ERRORS;
  END CASE;
END;
$

CALL bdsoutou.exsignal2('PL-5')$
CALL bdsoutou.exsignal2('PL-6')$
CALL bdsoutou.exsignal2('PL-1')$

/* RESIGNAL */


/* dans un sous bloc */

DROP TABLE table_inexistante$

CREATE PROCEDURE bdsoutou.exresignal1 ()
BEGIN
  DECLARE EXIT HANDLER FOR SQLEXCEPTION
  /* bloc qui s'excute aprs erreur SQL */
   BEGIN
    SET @v_passage = @v_passage + 2;
    IF @v_a = 0 THEN 
       RESIGNAL; 
    END IF;
  END;
  SET @v_passage = @v_passage + 1;
  SELECT col FROM table_inexistante;
END;
$

SET @v_passage = 0$
SET @v_a       = 1$
CALL bdsoutou.exresignal1 ()$
SHOW WARNINGS$
SELECT @v_passage$

SET @v_passage = 0$
SET @v_a       = 0$
CALL bdsoutou.exresignal1 ()$
SELECT @v_passage$

/* dans un sous prog appel */

CREATE PROCEDURE bdsoutou.exsignal1bis
  (IN p_brevet VARCHAR(6),
   OUT v_sortie TINYINT)
BEGIN
  DECLARE v_nbHv   DECIMAL(7,2);
  DECLARE v_comp   VARCHAR(4);
  DECLARE pilote_trop_bleu CONDITION FOR SQLSTATE '45000';
  SET v_sortie := 0;
  SELECT comp,nbHVol INTO v_comp,v_nbHv FROM bdsoutou.Pilote WHERE brevet = p_brevet;
  IF (v_nbHv < 1000) THEN
       SIGNAL pilote_trop_bleu 
            SET MESSAGE_TEXT='Pilote trop peu experimente.',
                MYSQL_ERRNO = 9001;
   ELSEIF (v_comp != 'AF') THEN
       SIGNAL SQLSTATE '01000'
            SET MESSAGE_TEXT = 'Warning, pas Air France', 
                MYSQL_ERRNO = 9000;
       ELSE
            SET v_sortie := 1;
            SELECT p_brevet,v_nbHv,v_comp;
   END IF; 
END;
$

CREATE PROCEDURE bdsoutou.exresignal2
  (IN p_brevet VARCHAR(6))
BEGIN
  DECLARE v_sortie TINYINT DEFAULT 0;
  CALL bdsoutou.exsignal1bis(p_brevet,v_sortie);
  IF v_sortie=0 THEN
     RESIGNAL;
  END IF;
END;
$

DROP PROCEDURE bdsoutou.exappelresignal$
CREATE PROCEDURE bdsoutou.exappelresignal(IN p_brevet VARCHAR(6))
BEGIN
  DECLARE v_flag TINYINT DEFAULT 0;
  DECLARE CONTINUE HANDLER 
          FOR SQLSTATE '01000' SET v_flag = 1;
  DECLARE CONTINUE HANDLER 
          FOR SQLSTATE VALUE '45000' SET v_flag = 2;
  CALL bdsoutou.exresignal2(p_brevet);
  CASE 
   WHEN v_flag=0 THEN SET v_flag = 0; /* Rien  faire */
   WHEN v_flag=1 THEN SHOW WARNINGS;
   WHEN v_flag=2 THEN SHOW ERRORS;
  END CASE;
END;
$

CALL bdsoutou.exappelresignal('PL-5')$
CALL bdsoutou.exappelresignal('PL-1')$
/* 
   en 5.5.6 : retourne une erreur 
   ERROR 1645 (0K000): RESIGNAL when handler not active
   ?
*/
CALL bdsoutou.exappelresignal('PL-6')$

/* chgt d'erreur */

DROP TABLE table_inexistante$

DROP PROCEDURE bdsoutou.exresignal3$
CREATE PROCEDURE bdsoutou.exresignal3 ()
BEGIN
  DECLARE EXIT HANDLER FOR SQLEXCEPTION
  BEGIN
    IF @v_a = 0 THEN 
          RESIGNAL 
          SET MYSQL_ERRNO = 3002,
          MESSAGE_TEXT='O est la table?'; 
    END IF;
  END;
  SELECT col FROM table_inexistante;
END;
$

SET @v_a       = 1$
CALL bdsoutou.exresignal3 ()$
SHOW WARNINGS$

SET @v_a       = 0$
CALL bdsoutou.exresignal3 ()$
SHOW WARNINGS$


/* chgt de statut */

DROP TABLE IF EXISTS table_existante$
CREATE TABLE table_existante(col CHAR(1))$
INSERT INTO table_existante VALUES ('A')$
INSERT INTO table_existante VALUES ('A')$

CREATE PROCEDURE bdsoutou.exresignal4()
BEGIN
  DECLARE v_col CHAR(1);
  DECLARE EXIT HANDLER FOR SQLSTATE VALUE '42000'
  BEGIN
         RESIGNAL SQLSTATE VALUE '45000' SET MYSQL_ERRNO = 3003,
             MESSAGE_TEXT='Il n''y a personne?'; 
  END;
  SELECT col INTO v_col FROM table_existante;
END;
$

CALL bdsoutou.exresignal4 ()$
SHOW WARNINGS$


delimiter ;

DROP TABLE IF EXISTS Pilote;