
--1	Type du poste p8
SELECT nPoste, typePoste
  FROM Poste WHERE nPoste = 'p8';

--2	Noms des logiciels UNIX
SELECT nomLog
  FROM Logiciel
  WHERE typeLog = 'UNIX';

--3	Nom, adresse IP, numro de salle des postes de type UNIX ou PCWS.
SELECT nomPoste, indIP, ad, nSalle
  FROM poste 
  WHERE typePoste = 'UNIX'
  OR    typePoste = 'PCWS';

--4	Mme requte pour les postes du segment 130.120.80 tris 
--par numro de salle dcroissant
SELECT nomPoste, indIP, ad, nSalle
  FROM poste 
  WHERE (typePoste = 'UNIX'
  OR    typePoste = 'PCWS')
  AND   indIP = '130.120.80'
	ORDER BY nSalle DESC;

--5  Numros des logiciels installs sur le poste p6.
SELECT  nLog
  FROM  Installer
  WHERE nPoste = 'p6';

--6	Numros des postes qui hbergent le logiciel log1.
SELECT  nPoste
  FROM  Installer
  WHERE nLog = 'log1';

--7	Nom et adresse IP complte (ex : 130.120.80.01) des postes de type TX
SELECT  nomPoste, CONCAT(indIP,'.',ad)
  FROM  Poste 
  WHERE typePoste = 'TX';


--8
SELECT nPoste, COUNT(nLog)
  FROM installer 
  GROUP BY (nPoste);

--9
SELECT nSalle, COUNT(nPoste)
  FROM Poste
  GROUP BY (nSalle)
  ORDER BY 2;

--10
SELECT nLog, COUNT(nPoste)
  FROM Installer 
  GROUP BY (nLog);

--11
SELECT AVG(prix)
  FROM Logiciel
  WHERE typeLog = 'UNIX';

--12
SELECT MAX(dateAch)
  FROM Logiciel;

--13
SELECT nPoste FROM Installer
  GROUP BY nPoste
  HAVING COUNT(nLog)=2;

--14
SELECT COUNT(*) FROM
  (SELECT nPoste FROM Installer GROUP BY nPoste HAVING COUNT(nLog)=2) T;

--15
SELECT DISTINCT typeLP FROM Types
 WHERE typeLP NOT IN (SELECT DISTINCT typePoste FROM Poste);

--16
SELECT DISTINCT typeLog FROM Logiciel
  WHERE typeLog IN (SELECT typePoste FROM Poste);

--17
SELECT DISTINCT typePoste FROM Poste
  WHERE typePoste NOT IN (SELECT typeLog FROM Logiciel);

--18
SELECT  CONCAT(indIP,'.',ad)
  FROM  Poste
  WHERE nPoste IN
	(SELECT nPoste 
	 FROM   Installer
	 WHERE  nLog = 'log6');

--19
SELECT  CONCAT(indIP,'.',ad)
  FROM  Poste
  WHERE nPoste IN
	(SELECT nPoste 
 	 FROM   Installer
	 WHERE  nLog =
		(SELECT nLog 
		 FROM   Logiciel
		 WHERE  nomLog = 'Oracle 8'));

--20
SELECT  nomSegment
  FROM  Segment
  WHERE indIP IN
	(SELECT   indIP
	 FROM     Poste
	 WHERE    typePoste = 'TX'
	 GROUP BY indIP
	 HAVING   COUNT(*)=3);

--21
SELECT  nomSalle 
  FROM  Salle
  WHERE nSalle IN
	(SELECT nSalle
 	 FROM   Poste
	 WHERE  nPoste IN
		(SELECT nPoste 
		 FROM   Installer
		 WHERE  nLog =
			(SELECT nLog 
			 FROM   Logiciel
			 WHERE  nomLog  = 'Oracle 6')));

--22	Nom du logiciel ayant la date dachat la plus rcente (utiliser la requte 12).
SELECT  nomLog
  FROM  Logiciel 
  WHERE dateAch =
	(SELECT MAX(dateAch) FROM Logiciel);

--23	Adresse IP des postes qui hbergent le logiciel log6.
SELECT  CONCAT(indIP,'.',ad)
  FROM  Poste p, Installer i
  WHERE p.nPoste = i.nPoste 
  AND   i.nLog   = 'log6';
  
--24	Adresse IP des postes qui hbergent le logiciel de nom Oracle 8
SELECT  CONCAT(indIP,'.',ad)
  FROM  Poste p, Installer i, Logiciel l
  WHERE p.nPoste = i.nPoste 
  AND   l.nLog   = i.nLog
  AND   l.nomLog = 'Oracle 8';

--25	Noms des segments possdant exactement trois postes de travail de type TX
SELECT   s.nomSegment
  FROM   Segment s, Poste p
  WHERE  s.indIP     = p.indIP
  AND    p.typePoste = 'TX'
  GROUP  BY s.nomSegment
  HAVING COUNT(*)=3;

--26	Noms des salles ou lon peut trouver au moins un poste hbergeant Oracle 6
SELECT  s.nomSalle
  FROM  Salle s, Poste p, Installer i, Logiciel l
  WHERE s.nSalle  = p.nSalle 
  AND   p.nPoste  = i.nPoste 
  AND   i.nLog    = l.nLog 
  AND   l.nomLog  = 'Oracle 6';

--27
SELECT sg.nomSegment, s.nSalle, p.indIP||'.' || p.ad, l.nomLog, i.dateIns
  FROM  segment sg, Salle s, Poste p, Logiciel l, Installer i
  WHERE s.nSalle = p.nSalle 
  AND   s.indIP  = sg.indIP
  AND   p.nPoste = i.nPoste 
  AND   i.nLog   = l.nLog
  ORDER BY 1,2,3;

--SQL2

--28	Adresse IP des postes qui hbergent le logiciel log6.
SELECT  CONCAT(indIP,'.',ad)
  FROM  Poste NATURAL JOIN Installer
  WHERE nLog   = 'log6';
  
--29	Adresse IP des postes qui hbergent le logiciel de nom Oracle 8
SELECT  CONCAT(indIP,'.',ad)
  FROM  Poste NATURAL JOIN Installer 
	NATURAL JOIN Logiciel
  	WHERE nomLog = 'Oracle 8';

--30	Noms des segments possdant exactement trois postes de travail de type TX
SELECT   nomSegment
  FROM   Segment JOIN Poste USING(indIP)
  WHERE  typePoste = 'TX'
  GROUP  BY nomSegment
  HAVING COUNT(*)=3;

--31	Noms des salles ou lon peut trouver au moins un poste hbergeant Oracle 6
SELECT  nomSalle
  FROM  Salle NATURAL JOIN  Poste 
	NATURAL JOIN  Installer 
		NATURAL JOIN  Logiciel 
		 WHERE nomLog  = 'Oracle 6';


--32
SELECT nomPoste 
  FROM Poste p
  WHERE EXISTS
 	(SELECT DISTINCT i1.nLog 
	 FROM   Installer i1
	 WHERE  i1.nPoste = p.nPoste
	 AND i1.nLog IN
	(
	 SELECT i2.nLog 
	 FROM   Installer i2
	 WHERE  i2.nPoste = 'p6')
	)
  AND NOT (nPoste ='p6');



--33
SELECT  nomPoste 
  FROM Poste p
  WHERE NOT EXISTS
	(SELECT DISTINCT i2.nLog 
	 FROM   Installer i2
	 WHERE  i2.nPoste = 'p6'
	  AND   i2.nLog NOT IN
	(
	 SELECT i1.nLog 
	 FROM   Installer i1
	 WHERE  i1.nPoste = p.nPoste))
  AND NOT (nPoste ='p6');


--34
SELECT  nomPoste 
  FROM Poste p
  WHERE NOT EXISTS
	(SELECT i2.nLog 
	 FROM   Installer i2
	 WHERE  i2.nPoste = 'p2'
	AND   i2.nLog NOT IN
	(
	 SELECT i1.nLog 
	 FROM   Installer i1
	 WHERE  i1.nPoste = p.nPoste))
  AND NOT EXISTS
	(SELECT i1.nLog 
	 FROM   Installer i1
	 WHERE  i1.nPoste = p.nPoste
	  AND   i1.nLog NOT IN
	(
	 SELECT i2.nLog 
	 FROM   Installer i2
	 WHERE  i2.nPoste = 'p2'))
  AND NOT (nPoste ='p2');

