
delimiter $

--
DROP TABLE IF EXISTS test.Trace$
CREATE TABLE test.Trace(message VARCHAR(80))$

--

DROP PROCEDURE IF EXISTS installLogSeg$

CREATE PROCEDURE installLogSeg (IN param1 VARCHAR(11), IN param2 VARCHAR(5),IN param3 VARCHAR(20), 
 IN param4 TIMESTAMP, IN param5 VARCHAR(7), IN param6 VARCHAR(9), IN param7 DECIMAL(6,2))
BEGIN
 DECLARE fincurs    BOOLEAN DEFAULT 0;
 DECLARE v_nomPoste VARCHAR(20);
 DECLARE v_nomSalle VARCHAR(20);
 DECLARE v_nPoste   VARCHAR(7); 
 DECLARE curseur    CURSOR FOR 
         SELECT     p.nomPoste,p.nPoste,s.nomSalle
                    FROM  Poste p, Salle s
                    WHERE p.indIP  = param1 AND p.typePoste = param6
                    AND p.nSalle = s.nSalle;
 DECLARE CONTINUE HANDLER FOR NOT FOUND SET fincurs := 1;

 SET AUTOCOMMIT = 0;
 INSERT INTO Logiciel VALUES (param2,param3,param4,param5,param6,param7,0);
 INSERT INTO test.Trace VALUES (CONCAT(param3,' stock dans la table Logiciel'));
 OPEN curseur;
 FETCH curseur INTO v_nomPoste,v_nPoste,v_nomSalle;
 WHILE (NOT fincurs) DO
   INSERT INTO Installer (nPoste,nLog,delai)  
         VALUES(v_nPoste, param2, TIMESTAMPDIFF(SECOND,param4,SYSDATE())/(24*3600) );
   INSERT INTO test.Trace VALUES (CONCAT('Installation sur ',v_nomPoste,' dans ',v_nomSalle));
   FETCH curseur INTO v_nomPoste,v_nPoste,v_nomSalle;
 END WHILE;	
 CLOSE curseur;
 COMMIT;
 SELECT * FROM test.Trace;
END;
$

DELETE FROM test.Trace$
SELECT nPoste,nomPoste FROM Poste WHERE indIP='130.120.80'$
SELECT * FROM Logiciel$
SELECT * FROM Installer$

CALL installLogSeg('130.120.80', 'log99','Blaster', '2005-09-05', '9.9', 'PCWS', 999.9 )$

SELECT * FROM Logiciel$
SELECT * FROM Installer WHERE nLog='log99'$

--
DELETE FROM Installer WHERE nLog='log99'$
DELETE FROM Logiciel WHERE nLog='log99'$




