import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class Normalisation extends HttpServlet {
	
	public void doPost(	HttpServletRequest requete,
						HttpServletResponse reponse)
						throws IOException, ServletException {
							
		String texteBrut = requete.getParameter("texte");
		String texteNormalis = normalise(texteBrut);
		
		reponse.setContentType("text/html");
		PrintWriter pw = reponse.getWriter();
		
		pw.println("<html>");
		pw.println("<head>");
		pw.println("<title>Normalisation</title>");
		pw.println("</head>");
		pw.println("<body bgcolor='white'>");
		pw.println("<h2 align='center'>Normalisation de texte</h2>");
		pw.println("<p align='center'>Texte brut : <b>" + texteBrut + "</b>");
		pw.println("<p align='center'>Texte normalis : <b>");
		pw.println(texteNormalis + "</b>");
		pw.println("</body>");
		pw.println("</html>");
	}
	
	private String normalise(String chane) {
		
		StringBuffer buffer = new StringBuffer(chane.length());
		boolean espace = true;
		char car = ' ';
		for (int index1 = 0; index1 < chane.length(); index1++) {
			car = chane.charAt(index1);
			if (car == ' ') {
				if (espace)
					continue;
				espace = true;
				buffer.append('-');
			}
			else {
				if (car == '\'') {
					if (espace) {
						buffer.deleteCharAt(buffer.length() - 1);
					}
					espace = true;
				}
				else {
					espace = false;
				}
				buffer.append(car);
			}
		}
		if (espace) {
			buffer.deleteCharAt(buffer.length() - 1);
		}
		return buffer.toString();
	}
}