/*
 * @(#) NormalisationAdresse.java	1.0		2000/07/31
 *
 * Copyright (c) Pierre-Yves Saumont et Antoine Mirecourt
 *
 */


import java.io.*;
import java.util.*;
import java.text.*;
import javax.servlet.*;
import javax.servlet.http.*;

/**
 * La classe NormalisationAdresse est une servlet qui reoit une adresse postale 
 * entre dans un formulaire HTML et lui applique un certain degr de 
 * normalisation : les mots reoivent une majuscule  l'initiale, sauf les mots 
 * courants tels que "l", "la", "du", "de", "rue", "avenue". Les mots courants 
 * prennent toutefois une majuscule sils se trouvent en dbut de ligne. Les 
 * mots courants sont contenus dans le tableau statique littral "mots" de la 
 * classe "Dictionnaire".
 *
 * Les noms de villes sont entirement en majuscules et les espaces sont 
 * remplacs par des tirets. Le programme ne traite pas la virgule aprs les 
 * numros de rues.
 *
 * @version		1.0		31 juillet 2000
 * @author		Pierre-Yves Saumont et Antoine Mirecourt
 */
public class NormalisationAdresse extends HttpServlet {
	public void doPost(HttpServletRequest requete,
			HttpServletResponse reponse)
			throws IOException, ServletException {
		String titre = requete.getParameter("titre");
		String nom = requete.getParameter("nom");
		String prnom = requete.getParameter("prnom");
		String socit = requete.getParameter("socit");
		String adresse1 = requete.getParameter("adresse1");
		String adresse2 = requete.getParameter("adresse2");
		String codePostal = requete.getParameter("codepostal");
		String ville = requete.getParameter("ville");
		
		String titreV = titre;
		String nomV= valid(nom);
		String prnomV = valid(prnom);
		String socitV = socit;
		String adresse1V = valid(adresse1);
		String adresse2V = valid(adresse2);
		String codePostalV = validCP(codePostal);
		String villeV = validVille(ville);
		//
		PrintWriter pw = reponse.getWriter();
		reponse.setContentType("text/html");
		//
		pw.println("<html>");
		pw.println("<head>");
		pw.println("<title>Validation Email</title>");
		pw.println("</head>");
		pw.println("<body bgcolor='white'>");
		pw.println("<h3>Votre adresse est :</h3>");
		pw.println("<p>" + titreV + " " + prnomV + " " + nomV);
		if (!socit.equals("")) {
			pw.println("<p>" + socitV);
		}
		pw.println("<p>" + adresse1V);
		if (!adresse2.equals("")) {
			pw.println("<br>" + adresse2V);
		}
		pw.println("<p>" + codePostalV + " " + villeV);
		pw.println("</body>");
		pw.println("</html>");
	}
	
	/**
	 * Mthode private String valid(String chane)
	 * 
	 * Cette mthode met chaque mot de l'argument chane en minuscules avec une
	 * majuscule  l'initiale, sauf pour les mots contenus dans Dictionnaire.mots
	 * qui sont entirement en minuscules lorsqu'ils ne sont pas en dbut de
	 * chane.
	 */
	private String valid(String chane) {
		// buffer contiendra le rsultat
		StringBuffer buffer = new StringBuffer(chane.length());
		// Un BreakIterator permet le dcoupage de la chane en mots.
		BreakIterator boundary = BreakIterator.getWordInstance(Locale.FRANCE);
		boundary.setText(chane);
		int start = boundary.first();
		boolean dansDico = false; 										// Le mot est dans le dictionnaire
		boolean premier = true;										// Le mot est le premier d'une ligne
		for (int end = boundary.next();										// Dcoupage de la chane
				end != BreakIterator.DONE;
				start = end, end = boundary.next()) {
			String mot = chane.substring(start,end);	// mot contient un lment
			// Comparaison de l'lment avec les mots du dictionnaire
			for (int i = 0; i < Dictionnaire.mots.length; i++) {
				// Si le mot n'est pas le premier de la chane et est dans le
				// dictionnaire
				if (!premier && mot.equalsIgnoreCase(Dictionnaire.mots[i])) {
					mot = Dictionnaire.mots[i];									// On prend le mot du dict.
					dansDico = true;
					buffer.append(mot);									// On l'ajoute au buffer
					premier = false;									// Le prochain mot ne sera
														// pas le premier !
					break;
				}
			}
			// Si le mot est dans le dictionnaire, on l'ajoute en mettant en
			// majuscule chaque partie (en cas de mot compos)
			if (!dansDico) {
				buffer.append(normaliseTiret(mot));
			}
			dansDico = false;
			premier = false;
		}	
		return buffer.toString();
	}
	
	/**
	 * Mthode private String normaliseTiret(String chane)
	 * 
	 * Cette mthode recherche les tirets ("-") dans une chane de caractres
	 * (mot compos) et renvoie la mme chane dans laquelle le dbut de chaque
	 * partie commence par une majuscule et la suite est en minuscules.
	 */
	private String normaliseTiret(String chane) {
		StringBuffer buffer = new StringBuffer(chane.length());
		int index;
		if (chane.length() < 2) {
			return chane;
		}
		index = chane.indexOf('-');
		if (index == -1) {
			buffer.append(chane.substring(0, 1).toUpperCase());
			buffer.append(chane.substring(1).toLowerCase());
		}
		else {
			buffer.append(chane.substring(0, 1).toUpperCase());
			buffer.append(chane.substring(1, index + 1).toLowerCase());
			buffer.append(normaliseTiret(chane.substring(index + 1)));
		}
		return buffer.toString();
	}
	
	
	/**
	 * Mthode private String normaliseTiretEspace(String chane)
	 * 
	 * Cette mthode recherche les espaces dans une chane de caractres
	 * et renvoie la mme chane dans laquelle les espaces sont remplacs
	 * par des tirets. Par ailleurs, la chane est mise en majuscules.
	 */
	private String normaliseEspaceTiret(String chane) {
		StringBuffer buffer = new StringBuffer(chane.length());
		int index;
		if (chane.length() < 2) {
			return chane.toUpperCase(); 
		}
		index = chane.indexOf(' ');
		if (index == 0) {
			return normaliseEspaceTiret(chane.substring(1));
		}
		if (index == -1) {
			buffer.append(chane.substring(0, 1).toUpperCase());
			buffer.append(chane.substring(1).toUpperCase());
		}
		else {
			buffer.append(chane.substring(0, 1).toUpperCase());
			buffer.append(chane.substring(1, index).toUpperCase());
			buffer.append("-");
			buffer.append(normaliseEspaceTiret(chane.substring(index + 1)));
		}
		return buffer.toString();
	}

	
	/**
	 * Mthode private String validCP(String chane)
	 * 
	 * Cette mthode valide les codes postaux. Dans cette version, elle n'est 
	 * pas implmente.
	 */
	private String validCP(String chane) {
		return chane;	
	}
	
	
	/**
	 * Mthode private String validVille(String chane)
	 * 
	 * Cette mthode valide les noms de villes. Dans cette version, elle ne fait
	 * qu'appeler la mthode normaliseTiretEspace(String chane)
	 */
	private String validVille(String chane) {
		return normaliseEspaceTiret(chane);
	}
}


class Dictionnaire {
	static String[] mots = {
		"alle",
		"appt",
		"av", 
		"avenue", 
		"b",
		"bd", 
		"bis",
		"bld", 
		"boulevard", 
		"chemin",
		"cite",
		"cours",
		"d",
		"de", 
		"des", 
		"du", 
		"en",
		"impasse",
		"l", 
		"la", 
		"les", 
		"place",
		"quai",
		"rsidence",
		"rue", 
		"t",
		"ter",
		"villa		"
	};
}
