import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class NormalisationParam extends HttpServlet {
	
	public void doPost(	HttpServletRequest requete,
						HttpServletResponse reponse)
						throws IOException, ServletException {
							
		String param1 = requete.getParameter("param1");
		String param2 = requete.getParameter("param2");
		String param3 = requete.getParameter("param3");
		boolean gal = ServletUtil.equalsNormal(param1, param2);
		
		reponse.setContentType("text/html");
		PrintWriter pw = reponse.getWriter();
		
		pw.println("<html>");
		pw.println("<head>");
		pw.println("<title>Normalisation des paramtres</title>");
		pw.println("</head>");
		pw.println("<body bgcolor='white'>");
		pw.println("<h2 align='center'>Normalisation des paramtres</h2>");
		pw.println("<p align='center'>Paramtre 1 : <b>");
		pw.println(ServletUtil.normalise(param1) + "</b>");
		pw.println("<p align='center'>Paramtre 2 : <b>");
		pw.println(ServletUtil.normalise(param2) + "</b>");
		pw.println("<p align='center'>Les deux paramtres sont :<b>");
		if (gal) {
			pw.println("gaux");
		}
		else {
			pw.println("ingaux");
		}
		pw.println("</b><p align='center'>Le paramtre 2 existe : <b>");
		pw.println(ServletUtil.nonNul(param2));
		pw.println("</b><p align='center'>Le paramtre 3 existe : <b>");
		pw.println(ServletUtil.nonNul(param3));
		pw.println("</body>");
		pw.println("</html>");
	}
}

class ServletUtil {
	static String normalise(String s) {
		if (s == null) {
			return "";
		}
		else {
			return s.trim().toLowerCase();
		}
	}
	
	static boolean equalsNormal(String s1, String s2) {
		if (s1 == null || s2 == null) {
			return false;
		}
		else {
			return s1.trim().equalsIgnoreCase(s2);
		}
	}

	static boolean nonNul(String s) {
		return (s != null) && !(s.trim().equals(""));
	}
}