import java.io.*;
import java.util.*;
import java.text.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class ValidationCB extends HttpServlet {
	public void doPost(	HttpServletRequest requete,
						HttpServletResponse reponse)
						throws IOException, ServletException {
		String ncb1 = requete.getParameter("ncb1");
		String ncb2 = requete.getParameter("ncb2");
		String ncb3 = requete.getParameter("ncb3");
		String ncb4 = requete.getParameter("ncb4");
		String mois = requete.getParameter("mois");
		String anne = requete.getParameter("anne");
		String type = requete.getParameter("type");

		Vector rponse = validCB(ncb1, ncb2, ncb3, ncb4, mois, anne, type);
		boolean numValid = ((Boolean)rponse.elementAt(0)).booleanValue();
		boolean dateValid = ((Boolean)rponse.elementAt(1)).booleanValue();
		boolean typeValid = ((Boolean)rponse.elementAt(2)).booleanValue();
		
		reponse.setContentType("text/html");
		PrintWriter pw = reponse.getWriter();
		
		pw.println("<html>");
		pw.println("<head>");
		pw.println("<title>Validation CB</title>");
		pw.println("</head>");
		pw.println("<body bgcolor='white'>");
		if (numValid && dateValid && typeValid) {
			pw.println("<h2 align='center'>***** OK *****</h2>");
			pw.println("<p align='center'>Le numro de Carte Bancaire,");
			pw.println("la date d'expiration et le type sont valides.");
			pw.println("<p align='center'>Nous vous remercions");
			pw.println("de votre confiance&nbsp;");			
		}
		else {
			pw.println("<h2 align='center'>***** ERREUR *****</h2>");
			pw.println("<p align='center'>Les informations communiques");
			pw.println("ne sont pas valides :");
			pw.println("<p>&nbsp");
			if (!numValid) {
				pw.println("<p align='center'><b>Numro CB incorrect.</b><br>");
			}
			if (!dateValid) {
				pw.println("<p align='center'><b>Date d'expiration");
				pw.println("dpasse.</b><br>");
			}				
			if (!typeValid) {
				pw.println("<p align='center'><b>Type de carte incompatible");
				pw.println("avec le numro.</b><br>");
			}				
			pw.println("<p align='center'>Cliquez sur le bouton");
			pw.println("<i>Page prcdente</i><br>de votre navigateur");
			pw.println("et corrigez.");
		}
		pw.println("</body>");
		pw.println("</html>");
	}
	
	private Vector validCB(	String ncb1, String ncb2, String ncb3, String ncb4, 
							String mois, String anne, String type) {
								
		Vector v = new Vector(2);
		//
		// Vrification du numro
		//
		String numro = ncb1 + ncb2 + ncb3 + ncb4;
		if (numro.length() != 16) {
			v.add(new Boolean(false));
		}
		else {
			int[] x = new int[16];
			for (int i = 0; i < 8; i++) {
				x[2 * i] = 
					((new Integer(numro.charAt(2 * i))).intValue() - 48) * 2;
				x[(2 * i) + 1] = 
					((new Integer(numro.charAt((2 * i) + 1))).intValue() - 48);
			}
			int control1 = 0;
			int control2 = 0;
			for (int i = 0; i < 16; i++) {
				control1 += ((int)x[i] / 10) + x[i] - ((int)x[i] / 10) * 10;
			}
			control2 = ((int)control1 / 10) * 10;
			v.add(new Boolean(control1 == control2));
		}
		//
		// Vrification de la date
		//
		if (!mois.equals("") && !anne.equals("")) {
			int m = (new Integer(mois)).intValue(); // mois de 0  11
			int a = (new Integer(anne)).intValue() + 2000;
			if (m == 12) {
				m = 0;
				a++;
			}
			Calendar calendar = new GregorianCalendar();
			calendar.clear();
			calendar.set(a,m,1);
			Date expire = calendar.getTime();
			Date maintenant = new Date();
			v.add(new Boolean(maintenant.before(expire)));
		}
		else {
			v.add(new Boolean(false));
		}
		//
		// Vrification du type
		//
		if (ncb1.length() != 4) {
			v.add(new Boolean(false));
		}
		else {
			try {
				int mcode = (new Integer(ncb1.substring(0, 2))).intValue();
				v.add(new Boolean(
					(type.equals("Visa") && ncb1.substring(0, 1).equals("4"))
					|| (type.equals("Mastercard") && mcode > 50 && mcode < 56)
						));
			}
			catch (NumberFormatException e) {
				v.add(new Boolean(false));
			}				
		}
		return v;
	}
}