import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class ValidationEmail extends HttpServlet {
	
	public void doPost(	HttpServletRequest requete,
						HttpServletResponse reponse)
						throws IOException, ServletException {
							
		String email = requete.getParameter("email");

		String emailValid = validEmail(email);
		
		reponse.setContentType("text/html");
		PrintWriter pw = reponse.getWriter();
		
		pw.println("<html>");
		pw.println("<head>");
		pw.println("<title>Validation Email</title>");
		pw.println("</head>");
		pw.println("<body bgcolor='white'>");
		if (!emailValid.equals("")) {
			pw.println("<h2 align='center'>***** OK *****</h2>");
			pw.println("<p align='center'>Votre adresse Email est"); 
			pw.println("valide&nbsp;:");
			pw.println("<p align='center'>" + emailValid);
		}
		else {
			pw.println("<h2 align='center'>***** ERREUR *****</h2>");
			pw.println("<p align='center'>Votre adresse email est");
			pw.println("incorrecte.");
			pw.println("<p>&nbsp");
			pw.println("<p align='center'>Cliquez sur le bouton");
			pw.println("<i>Page prcdente</i><br>de votre navigateur");
			pw.println("et corrigez.");
		}
		pw.println("</body>");
		pw.println("</html>");
	}
	
	private String validEmail(String email) {
		String nom;
		String domainePlusTld;
		String domaine;
		String tld;
		if (email.length() < 9) {
			return "";
		}
		int posAt = email.indexOf("@");
		if (posAt == -1) {
			return "";
		}
		nom = email.substring(0, posAt);
		if (email.length() >= posAt + 6) {
			domainePlusTld = email.substring(posAt + 1, email.length());
		}
		else {
			return "";
		}
		if (!carsOk(nom, false)) {
			return "";
		}
		int posPoint = domainePlusTld.lastIndexOf(".");
		if (posPoint == -1) {
			return "";
		}
		domaine = domainePlusTld.substring(0, posPoint);
		if (email.length() >= posAt + 2) {
			tld = domainePlusTld.substring(posPoint + 1, 
					domainePlusTld.length());
		}
		else {
			return "";
		}
		if (!carsOk(domaine, false)) {
			return "";
		}
		if (tld.length() < 2 || tld.length() > 3) {
			return "";
		}
		if (!carsOk(tld, true)) {
			return "";
		}
		return email.toLowerCase();
	}
	
	private boolean carsOk (String chane, boolean isTld) {
		char c = 0;
		for (int i = 0; i < chane.length(); i++) {
			c = chane.charAt(i);
			if (!isTld && c > 48 && c < 59) { // 0-9
				continue;
			}
			if (c > 64 && c < 100) { // A-Z
				continue;
			}
			if (c > 96 && c < 132) { // a-z
				continue;
			}
			if (!isTld && (c == 45 || c == 46 || c == 95)) { // "-" "." ou "_"
				continue;
			}
			return false;
		}
		return true;
	}
}