import java.io.*;
import java.util.*;
import java.text.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class Reponse extends HttpServlet {

	public void doPost(	HttpServletRequest requte,
						HttpServletResponse rponse)
						throws IOException, ServletException {

		ServletContext contexte = getServletConfig().getServletContext();
		String langue = requte.getParameter("langue");
		if (langue.equals("Franais")) {
			langue = "fr";
		}
		if (langue.equals("Anglais")) {
			langue = "en";
		}
		String pays = requte.getParameter("pays");
		if (pays.equals("France")) {
			pays = "fr";
		}
		if (pays.equals("Etats-Unis")) {
			pays = "us";
		}
		rponse.setLocale(new Locale(langue, pays));

		rponse.setContentType("text/html");
		PrintWriter pw = rponse.getWriter();
		pw.println("<html>");
		pw.println("<body>");
		pw.println("<head>");
		pw.println("<title>Exemples d'utilisation des mthodes de");
		pw.println("HttpServletResponse, ServletResponse");
		pw.println("et ServletContext</title>");
		pw.println("</head>");
		pw.println("<body>");
		pw.println("<h3>Exemples d'utilisation des mthodes de<br>");
		pw.println("HttpServletResponse, ServletResponse<br>");
		pw.println("et ServletResponse</h3>");
		pw.println("<table>");
		pw.println("<tr><td colspan='2' align='center' bgcolor='lightgreen'>");
		pw.println("<b>Informations sur la rponse</b></td></tr>");
		pw.println("<tr>");
		pw.println("<td><b>Taille du tampon :</b></td>");
		pw.println("<td>" + rponse.getBufferSize() + "</td>");
		pw.println("</tr><tr>");
		pw.println("<td><b>Encodage :</b></td>");
		pw.println("<td>" + rponse.getCharacterEncoding() + "</td>");
		pw.println("</tr><tr>");
		pw.println("<td><b>Locale :</b></td>");
		pw.println("<td>" + rponse.getLocale() + "</td>");
		pw.println("</tr><tr>");
		pw.println("<td><b>Version de l'API Servlet :</b></td>");
		pw.println("<td>" + contexte.getMajorVersion() + "." 
					+ contexte.getMinorVersion() + "</td>");
		pw.println("</tr><tr>");
		pw.println("<td valign='top'><b>Conteneur :</b></td>");
		pw.println("<td>" + contexte.getServerInfo() + "</td>");
		pw.println("</tr><tr>");
		pw.println("<td><b>Chemin d'accs rel :</b></td>");
		pw.println("<td>" + contexte.getRealPath("/") + "</td>");
		pw.println("</tr>");
		pw.println("<tr><td colspan='2' align='center' bgcolor='lightgreen'>");
		pw.println("<b>Attributs</b></td></tr>");
		Enumeration e1 = contexte.getAttributeNames();
		while (e1.hasMoreElements()) {
			String nom = (String)e1.nextElement();
			String valeur = contexte.getAttribute(nom).toString();
			pw.println("<tr><td><b>" + nom + "</b></td>");
			pw.println("<td>" + valeur + "</td></tr>");
		}
		pw.println("<tr><td colspan='2' align='center' bgcolor='lightgreen'>");
		pw.println("<b>Paramtres d'initialisation</b></td></tr>");
		Enumeration e2 = contexte.getInitParameterNames();
		if (!e2.hasMoreElements()) {
			pw.println("<tr><td colspan='2' align='center'>");
			pw.println("Aucun paramtre d'initialisation</td></tr>");
		}
		else {
			while (e2.hasMoreElements()) {
				String nom = (String)e2.nextElement();
				String valeur = contexte.getInitParameter(nom);
				pw.println("<tr><td><b>" + nom + "</b></td>");
				pw.println("<td>" + valeur + "</td></tr>");
			}
		}
		pw.println("</table>");
		pw.println("</body>");
		pw.println("</html>");
	}
}