import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import org.apache.xalan.xslt.*;
import org.apache.fop.apps.*;
import org.apache.fop.render.pdf.*;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class DeptMulti extends HttpServlet {
	
	public void doPost(	HttpServletRequest requete,
						HttpServletResponse reponse)
						throws IOException, ServletException {
							
		String styleSheet = null;
		String typeMIME = null;
		String dept = requete.getParameter("dept");
		String format = requete.getParameter("format");
		boolean html = (format.equals("HTML"));
		boolean xml = (format.equals("XML"));
		boolean rtf = (format.equals("RTF"));
		boolean pdf = (format.equals("PDF"));
		boolean texte = (format.equals("Texte avec sparateurs"));
	
		PrintWriter pw = reponse.getWriter();
		String[] result = getResult(dept);
		
		StringBuffer buf = new StringBuffer();
		buf.append("<?xml version='1.0'?>");
		buf.append("<document>");
		buf.append("<titre>Les Dpartements Franais</titre>");
		buf.append("<departement>" + result[0] + "</departement>");
		buf.append("<code>" + result[1] + "</code>");
		buf.append("<region>" + result[2] + "</region>");
		buf.append("<prefecture>" + result[3] + "</prefecture>");
		buf.append("<indicatif>" + result[4] + "</indicatif>");
		buf.append("</document>");

		if (html) {
			styleSheet = "depthtml.xsl";
			typeMIME   = "text/html";
		}
		if (xml) {
			styleSheet = "deptxml.xsl";
			typeMIME   = "text/xml";
		}
		if (rtf) {
			styleSheet = "deptrtf.xsl";
			typeMIME   = "text/rtf";
		}
		if (pdf) {
			styleSheet = "deptfo.xsl";
			typeMIME   = "application/pdf";
		}
		if (texte) {
			styleSheet = "depttexte.xsl";
			typeMIME   = "text/plain";
		}
		
		reponse.setContentType(typeMIME);

		StringBuffer outBuf = new StringBuffer();
		StringWriter outWriter = new StringWriter();

		xslTransform(buf.toString(), outWriter, styleSheet);
		outBuf = outWriter.getBuffer();
		
		if (pdf) {
			xslfoRender(pw, outBuf.toString());
		}
		else {
			pw.println(outBuf.toString());
		}
	}
	
	private void xslfoRender(Writer pw, String styleSheet) {
		InputSource inputSource = new InputSource(new StringReader(styleSheet));
		Parser parser = new org.apache.xerces.parsers.SAXParser();

		Driver driver = new Driver();
		driver.setRenderer("org.apache.fop.render.pdf.PDFRenderer", "Volga");
		driver.addElementMapping("org.apache.fop.fo.StandardElementMapping");
		driver.setWriter((PrintWriter)pw);
		try {
			driver.buildFOTree(parser, inputSource);
			driver.format();
			driver.render();
		}
		catch (FOPException FOPe) {
			System.out.println(FOPe);
		}
		catch (IOException FOPe) {
			System.out.println(FOPe);
		}
	}

	private void xslTransform(String buffer, Writer pw, String styleSheet) {
		
		try {
			// Instanciation d'un XSLProcessor  l'aide de XSLTProcessorFactory
			XSLTProcessor processor = XSLTProcessorFactory.getProcessor();

			// 
			XSLTInputSource xmlSource 
					= new XSLTInputSource(new StringReader(buffer));
			XSLTInputSource xslSheet 
					= new XSLTInputSource(getServletConfig()
					.getServletContext()
					.getRealPath("/" + styleSheet));
			XSLTResultTarget xmlResult 
					= new XSLTResultTarget(pw);

			// Transformation XSL
			processor.process(xmlSource, xslSheet, xmlResult);
		}
		catch(org.xml.sax.SAXException se) {
			System.out.println(se);
		}
	}
	
	private String[] getResult(String s) {
		String[] result = {s, "89", "Bourgogne", "Auxerre", "03 86"};
		return result;
	}
}